/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.snowflake.model;

import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLDollarQuoteRule;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLMultiWordRule;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.model.text.parser.TPTokenType;
import org.jkiss.utils.CommonUtils;

public class SnowflakeSQLDialect
extends GenericSQLDialect
implements TPRuleProvider {
    private static final String[][] SNOWFLAKE_BEGIN_END_BLOCK = new String[][]{{"BEGIN", "END"}, {"IF", "END"}};

    public SnowflakeSQLDialect() {
        super("Snowflake", "snowflake");
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        this.addSQLKeywords(Arrays.asList("QUALIFY", "ILIKE", "PACKAGE", "PIPE", "STAGE", "STREAM", "TAG", "TASK"));
    }

    @NotNull
    public TPRule[] extendRules(@Nullable DBPDataSourceContainer dataSource, @NotNull TPRuleProvider.RulePosition position) {
        if (position == TPRuleProvider.RulePosition.INITIAL || position == TPRuleProvider.RulePosition.PARTITION) {
            return new TPRule[]{new SQLDollarQuoteRule(position == TPRuleProvider.RulePosition.PARTITION, false, false, dataSource == null || dataSource.getPreferenceStore().getBoolean("ddString"))};
        }
        if (position == TPRuleProvider.RulePosition.KEYWORDS) {
            TPTokenDefault keywordToken = new TPTokenDefault((TPTokenType)SQLTokenType.T_KEYWORD);
            return new TPRule[]{new SQLMultiWordRule(new String[]{"BEGIN", "TRANSACTION"}, (TPToken)keywordToken), new SQLMultiWordRule(new String[]{"IF", "EXISTS"}, (TPToken)keywordToken), new SQLMultiWordRule(new String[]{"IF", "NOT", "EXISTS"}, (TPToken)keywordToken)};
        }
        return new TPRule[0];
    }

    public String[][] getBlockBoundStrings() {
        return SNOWFLAKE_BEGIN_END_BLOCK;
    }

    @NotNull
    public String getSearchStringEscape() {
        return "\\";
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public String getColumnTypeModifiers(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        switch (typeName) {
            case "DECIMAL": 
            case "NUMBER": 
            case "NUMERIC": {
                DBSDataType dataType = DBUtils.getDataType((DBSTypedObject)column);
                Integer scale = column.getScale();
                int precision = CommonUtils.toInt((Object)column.getPrecision());
                if (precision == 0 && dataType != null && scale != null && scale.intValue() == dataType.getMinScale()) {
                    return "";
                }
                if (precision == 0 || precision > 38) {
                    precision = 38;
                }
                if (scale == null && precision <= 0) break;
                return "(" + (precision > 0 ? precision : 38) + (scale != null && scale > 0 ? "," + scale : "") + ")";
            }
            case "INTEGER": 
            case "INT": 
            case "REAL": 
            case "FLOAT": 
            case "DOUBLE PRECISION": 
            case "BIGINT": 
            case "DOUBLE": {
                return null;
            }
        }
        return super.getColumnTypeModifiers(dataSource, column, typeName, dataKind);
    }

    public boolean validIdentifierStart(char c) {
        return SQLUtils.isLatinLetter((int)c) || c == '_';
    }

    public boolean validIdentifierPart(char c, boolean quoted) {
        return SQLUtils.isLatinLetter((int)c) || Character.isDigit(c) || c == '_' || quoted && this.validCharacters.indexOf(c) != -1 || c == '$';
    }

    public boolean mustBeQuoted(@NotNull String str, boolean forceCaseSensitive) {
        if (str.isBlank()) {
            return true;
        }
        return super.mustBeQuoted(str, forceCaseSensitive);
    }
}

