/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.text.CharacterIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class SQLDocumentCharacterIterator
implements CharacterIterator,
CharSequence {
    private int index = -1;
    private final IDocument document;
    private final int first;
    private final int last;

    private void invariant() {
        Assert.isTrue((this.index >= this.first ? 1 : 0) != 0);
        Assert.isTrue((this.index <= this.last ? 1 : 0) != 0);
    }

    public SQLDocumentCharacterIterator(IDocument document) throws BadLocationException {
        this(document, 0);
    }

    public SQLDocumentCharacterIterator(IDocument document, int first) throws BadLocationException {
        this(document, first, document.getLength());
    }

    public SQLDocumentCharacterIterator(IDocument document, int first, int last) throws BadLocationException {
        if (document == null) {
            throw new NullPointerException();
        }
        if (first < 0 || first > last) {
            throw new BadLocationException();
        }
        if (last > document.getLength()) {
            throw new BadLocationException();
        }
        this.document = document;
        this.first = first;
        this.last = last;
        this.index = first;
        this.invariant();
    }

    @Override
    public char first() {
        return this.setIndex(this.getBeginIndex());
    }

    @Override
    public char last() {
        if (this.first == this.last) {
            return this.setIndex(this.getEndIndex());
        }
        return this.setIndex(this.getEndIndex() - 1);
    }

    @Override
    public char current() {
        if (this.index >= this.first && this.index < this.last) {
            try {
                return this.document.getChar(this.index);
            }
            catch (BadLocationException badLocationException) {}
        }
        return '\uffff';
    }

    @Override
    public char next() {
        return this.setIndex(Math.min(this.index + 1, this.getEndIndex()));
    }

    @Override
    public char previous() {
        if (this.index > this.getBeginIndex()) {
            return this.setIndex(this.index - 1);
        }
        return '\uffff';
    }

    @Override
    public char setIndex(int position) {
        if (position < this.getBeginIndex() || position > this.getEndIndex()) {
            throw new IllegalArgumentException();
        }
        this.index = position;
        this.invariant();
        return this.current();
    }

    @Override
    public int getBeginIndex() {
        return this.first;
    }

    @Override
    public int getEndIndex() {
        return this.last;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public int length() {
        return this.getEndIndex() - this.getBeginIndex();
    }

    @Override
    public char charAt(int index) {
        if (index >= 0 && index < this.length()) {
            try {
                return this.document.getChar(this.getBeginIndex() + index);
            }
            catch (BadLocationException badLocationException) {
                return '\uffff';
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end < start) {
            throw new IndexOutOfBoundsException();
        }
        if (end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            return new SQLDocumentCharacterIterator(this.document, this.getBeginIndex() + start, this.getBeginIndex() + end);
        }
        catch (BadLocationException badLocationException) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public String toString() {
        return this.document.get().substring(this.getBeginIndex(), this.getEndIndex());
    }
}

