/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm.mapping;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathEvaluationResult;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathNodes;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.lsm.mapping.AbstractSyntaxNode;
import org.jkiss.dbeaver.model.lsm.mapping.ModelErrorsCollection;
import org.jkiss.dbeaver.model.lsm.mapping.SyntaxModel;
import org.jkiss.dbeaver.model.lsm.mapping.SyntaxModelMappingResult;
import org.jkiss.dbeaver.model.lsm.mapping.SyntaxSubnodeLookupMode;
import org.jkiss.dbeaver.model.lsm.mapping.internal.FieldTypeKind;
import org.jkiss.dbeaver.model.lsm.mapping.internal.LiteralTypeInfo;
import org.jkiss.dbeaver.model.lsm.mapping.internal.NodeFieldInfo;
import org.jkiss.dbeaver.model.lsm.mapping.internal.NodeTypeInfo;
import org.jkiss.dbeaver.model.lsm.mapping.internal.NodesList;
import org.jkiss.dbeaver.model.lsm.mapping.internal.XTreeNodeBase;
import org.w3c.dom.Node;

public class SyntaxModelMappingSession {
    private final ModelErrorsCollection errors = new ModelErrorsCollection();
    private final SyntaxModel modelInfo;

    public SyntaxModelMappingSession(SyntaxModel modelInfo) {
        this.modelInfo = modelInfo;
    }

    private static boolean isEmptyValue(XPathEvaluationResult<?> xvalue) {
        Object value = xvalue.value();
        if (value == null) {
            return true;
        }
        switch (xvalue.type()) {
            case BOOLEAN: 
            case NUMBER: 
            case STRING: {
                if (!(value instanceof String)) break;
                return ((String)value).length() < 1;
            }
            case ANY: 
            case NODESET: 
            case NODE: {
                if (!(value instanceof XPathNodes)) break;
                XPathNodes nodes = (XPathNodes)value;
                return nodes.size() < 1;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected xpath value type " + (Object)((Object)xvalue.type()));
            }
        }
        return false;
    }

    private static XTreeNodeBase tryGetNode(XPathEvaluationResult<?> xvalue) throws XPathException {
        XPathNodes nodes;
        Object value = xvalue.value();
        if (value instanceof XTreeNodeBase) {
            return (XTreeNodeBase)value;
        }
        if (value instanceof XPathNodes && (nodes = (XPathNodes)value).size() == 1) {
            return (XTreeNodeBase)nodes.get(0);
        }
        return null;
    }

    private AbstractSyntaxNode instantiateAndFill(@NotNull NodeTypeInfo typeInfo, @NotNull XTreeNodeBase nodeInfo) {
        try {
            if (nodeInfo.getModel() == null) {
                AbstractSyntaxNode model = typeInfo.ctor.newInstance(new Object[0]);
                model.setAstNode(nodeInfo);
                nodeInfo.setModel(model);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            this.errors.add(ex, "Failed to instantiate syntax model node of type " + typeInfo.type.getName());
            return null;
        }
        HashSet<XTreeNodeBase> subnodes = new HashSet<XTreeNodeBase>(5);
        block8: for (NodeFieldInfo field : typeInfo.fields.values()) {
            subnodes.clear();
            for (XPathExpression expr : field.termExprs) {
                try {
                    XPathEvaluationResult<?> value = expr.evaluateExpression(nodeInfo);
                    if (SyntaxModelMappingSession.isEmptyValue(value)) continue;
                    this.bindValue(nodeInfo, field, value);
                    XTreeNodeBase valueNode = SyntaxModelMappingSession.tryGetNode(value);
                    if (valueNode == null) continue;
                    nodeInfo.getModel().appendBinding(new AbstractSyntaxNode.BindingInfo(field, null, valueNode));
                }
                catch (XPathException e) {
                    this.errors.add(e, "Failed to evaluate syntax model term expression for field " + field.getFieldName() + " of type " + field.getDeclaringClassName());
                }
            }
            if (field.kind == FieldTypeKind.Array || field.kind == FieldTypeKind.List) {
                for (NodeFieldInfo.SubnodeInfo subnodeInfo : field.subnodesInfo) {
                    boolean tryDescedants = subnodeInfo.lookupMode == SyntaxSubnodeLookupMode.DEPTH_FIRST;
                    try {
                        if (subnodeInfo.scopeExpr != null) {
                            XPathEvaluationResult<?> scopeOrSubnode = subnodeInfo.scopeExpr.evaluateExpression(nodeInfo);
                            if (scopeOrSubnode.type() == XPathEvaluationResult.XPathResultType.NODESET && scopeOrSubnode.value() instanceof XPathNodes) {
                                for (Node scopeSubnode : (XPathNodes)scopeOrSubnode.value()) {
                                    if (!(scopeSubnode instanceof XTreeNodeBase)) continue;
                                    NodeTypeInfo subnodeTypeInfo = subnodeInfo.getNodeTypeInfo();
                                    this.mapSubtrees((XTreeNodeBase)scopeSubnode, subnodeTypeInfo, true, tryDescedants, subnodes);
                                }
                                continue;
                            }
                            if (scopeOrSubnode.type() != XPathEvaluationResult.XPathResultType.NODE || !(scopeOrSubnode.value() instanceof XTreeNodeBase)) continue;
                            NodeTypeInfo subnodeTypeInfo = subnodeInfo.getNodeTypeInfo();
                            this.mapSubtrees((XTreeNodeBase)scopeOrSubnode.value(), subnodeTypeInfo, true, tryDescedants, subnodes);
                            continue;
                        }
                        if (tryDescedants) {
                            this.mapSubtrees(nodeInfo, subnodeInfo.getNodeTypeInfo(), false, true, subnodes);
                            continue;
                        }
                        for (XTreeNodeBase candidateSubnode : nodeInfo.getSubnodes().getCollection()) {
                            this.mapSubtrees(candidateSubnode, subnodeInfo.getNodeTypeInfo(), true, false, subnodes);
                        }
                    }
                    catch (XPathExpressionException e) {
                        this.errors.add(e, "Failed to evaluate syntax model subnode scope expression for subnode " + subnodeInfo.subnodeType.getName() + " of field " + field.getFieldName() + " of type " + field.getDeclaringClassName());
                    }
                }
                List<XTreeNodeBase> orderedSubnodes = subnodes.stream().sorted(Comparator.comparingInt(a -> a.getModel().getStartPosition())).collect(Collectors.toList());
                this.bindValue(nodeInfo, field, orderedSubnodes);
                orderedSubnodes.forEach(n -> nodeInfo.getModel().appendBinding(new AbstractSyntaxNode.BindingInfo(field, n.getModel(), (XTreeNodeBase)n)));
                continue;
            }
            for (NodeFieldInfo.SubnodeInfo subnodeInfo : field.subnodesInfo) {
                boolean tryDescedants = subnodeInfo.lookupMode == SyntaxSubnodeLookupMode.DEPTH_FIRST;
                try {
                    AbstractSyntaxNode subnode = null;
                    if (subnodeInfo.scopeExpr != null) {
                        XPathEvaluationResult<?> scopeOrSubnode = subnodeInfo.scopeExpr.evaluateExpression(nodeInfo);
                        if (scopeOrSubnode.type() == XPathEvaluationResult.XPathResultType.NODESET && scopeOrSubnode.value() instanceof XPathNodes) {
                            for (Node scopeSubnode : (XPathNodes)scopeOrSubnode.value()) {
                                NodeTypeInfo subnodeTypeInfo;
                                if (!(scopeSubnode instanceof XTreeNodeBase) || (subnode = this.mapSubtree((XTreeNodeBase)scopeSubnode, subnodeTypeInfo = subnodeInfo.getNodeTypeInfo(), true, tryDescedants)) == null) {
                                    continue;
                                }
                                break;
                            }
                        } else if (scopeOrSubnode.type() == XPathEvaluationResult.XPathResultType.NODE && scopeOrSubnode.value() instanceof XTreeNodeBase) {
                            NodeTypeInfo subnodeTypeInfo = subnodeInfo.getNodeTypeInfo();
                            subnode = this.mapSubtree((XTreeNodeBase)scopeOrSubnode.value(), subnodeTypeInfo, true, tryDescedants);
                        }
                    } else if (tryDescedants) {
                        subnode = this.mapSubtree(nodeInfo, subnodeInfo.getNodeTypeInfo(), false, true);
                    } else {
                        for (XTreeNodeBase candidateSubnode : nodeInfo.getSubnodes().getCollection()) {
                            this.mapSubtrees(candidateSubnode, subnodeInfo.getNodeTypeInfo(), true, false, subnodes);
                        }
                    }
                    if (subnode == null) continue;
                    this.bindRawValue(nodeInfo, field, subnode);
                    nodeInfo.getModel().appendBinding(new AbstractSyntaxNode.BindingInfo(field, subnode, subnode.getAstNode()));
                    continue block8;
                }
                catch (XPathExpressionException e) {
                    this.errors.add(e, "Failed to evaluate syntax model subnode scope expression for subnode " + subnodeInfo.subnodeType.getName() + " of field " + field.getFieldName() + " of type " + field.getDeclaringClassName());
                }
            }
        }
        return nodeInfo.getModel();
    }

    private Object mapLiteralValue(XTreeNodeBase nodeInfo, LiteralTypeInfo typeInfo) {
        if (typeInfo != null) {
            try {
                String str;
                String string = str = typeInfo.stringExpr == null ? nodeInfo.getTextContent() : typeInfo.stringExpr.evaluateExpression(nodeInfo, String.class);
                if (str != null && str.length() > 0) {
                    Object value = typeInfo.valuesByName.get(typeInfo.isCaseSensitive ? str : str.toUpperCase());
                    return value;
                }
            }
            catch (XPathExpressionException e) {
                this.errors.add(e, "Failed to evaluate syntax model literal expression of type " + typeInfo.type.getName());
            }
            for (Map.Entry<Object, XPathExpression> literalCase : typeInfo.exprByValue.entrySet()) {
                try {
                    Boolean value = literalCase.getValue().evaluateExpression(nodeInfo, Boolean.class);
                    if (!Boolean.TRUE.equals(value)) continue;
                    return literalCase.getKey();
                }
                catch (XPathExpressionException e) {
                    this.errors.add(e, "Failed to evaluate syntax model literal case condition expression for case " + literalCase.getKey() + " of type " + typeInfo.type.getName());
                }
            }
        }
        return null;
    }

    private void bindValue(XTreeNodeBase nodeInfo, NodeFieldInfo fieldInfo, final List<XTreeNodeBase> subnodes) {
        this.bindValue(nodeInfo, fieldInfo, new XPathEvaluationResult<XPathNodes>(){

            @Override
            public XPathEvaluationResult.XPathResultType type() {
                return XPathEvaluationResult.XPathResultType.NODESET;
            }

            @Override
            public XPathNodes value() {
                return new XPathNodes(){

                    @Override
                    public int size() {
                        return subnodes.size();
                    }

                    @Override
                    public Iterator<Node> iterator() {
                        return subnodes.iterator();
                    }

                    @Override
                    public Node get(int index) {
                        return (Node)subnodes.get(index);
                    }
                };
            }
        });
    }

    private void bindValue(XTreeNodeBase nodeInfo, NodeFieldInfo fieldInfo, XPathEvaluationResult<?> xvalue) {
        Object value;
        block1 : switch (fieldInfo.kind) {
            case Object: 
            case Array: 
            case List: {
                switch (xvalue.type()) {
                    case NODESET: 
                    case NODE: {
                        value = xvalue.value();
                        break block1;
                    }
                }
                throw new UnsupportedOperationException("Not supported");
            }
            case LiteralList: {
                switch (xvalue.type()) {
                    case ANY: 
                    case STRING: 
                    case NODESET: 
                    case NODE: {
                        value = xvalue.value();
                        break block1;
                    }
                }
                throw new UnsupportedOperationException("Not supported value type for binding: " + (Object)((Object)xvalue.type()));
            }
            case String: {
                value = this.getScalarString(fieldInfo, xvalue);
                break;
            }
            case Byte: {
                value = Byte.parseByte(Objects.requireNonNull(this.getScalarString(fieldInfo, xvalue)));
                break;
            }
            case Short: {
                value = Short.parseShort(Objects.requireNonNull(this.getScalarString(fieldInfo, xvalue)));
                break;
            }
            case Int: {
                value = Integer.parseInt(Objects.requireNonNull(this.getScalarString(fieldInfo, xvalue)));
                break;
            }
            case Long: {
                value = Long.parseLong(Objects.requireNonNull(this.getScalarString(fieldInfo, xvalue)));
                break;
            }
            case Bool: {
                value = Boolean.parseBoolean(this.getScalarString(fieldInfo, xvalue));
                break;
            }
            case Float: {
                value = Float.valueOf(Float.parseFloat(Objects.requireNonNull(this.getScalarString(fieldInfo, xvalue))));
                break;
            }
            case Double: {
                value = Double.parseDouble(Objects.requireNonNull(this.getScalarString(fieldInfo, xvalue)));
                break;
            }
            case Enum: {
                switch (xvalue.type()) {
                    case NODE: {
                        value = this.mapLiteralValue((XTreeNodeBase)xvalue.value(), fieldInfo.getLiteralTypeInfo());
                        break block1;
                    }
                    case NODESET: {
                        XPathNodes nodes = (XPathNodes)xvalue.value();
                        if (nodes.size() == 1) {
                            try {
                                value = this.mapLiteralValue((XTreeNodeBase)nodes.get(0), fieldInfo.getLiteralTypeInfo());
                            }
                            catch (XPathException e) {
                                this.errors.add(e, "Failed to bind raw value to field " + fieldInfo.getFieldName() + " of type " + fieldInfo.getDeclaringClassName());
                                value = null;
                            }
                            break block1;
                        }
                        value = null;
                        break block1;
                    }
                }
                throw new UnsupportedOperationException("Not supported");
            }
            default: {
                throw new UnsupportedOperationException("Unexpected syntax model field kind " + (Object)((Object)fieldInfo.kind));
            }
        }
        if (value != null) {
            this.bindRawValue(nodeInfo, fieldInfo, value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String getScalarString(@NotNull NodeFieldInfo fieldInfo, @NotNull XPathEvaluationResult<?> xvalue) {
        try {
            switch (xvalue.type()) {
                case NODE: {
                    XTreeNodeBase nodeInfo = (XTreeNodeBase)xvalue.value();
                    return nodeInfo.getNodeValue();
                }
                case NODESET: {
                    XPathNodes nodes = (XPathNodes)xvalue.value();
                    int count = nodes.size();
                    if (count == 0) {
                        return null;
                    }
                    if (count == 1) {
                        return nodes.get(0).getNodeValue();
                    }
                    this.errors.add("Ambiguous resolution of syntax model value expression for field " + fieldInfo.getFieldName() + " of type " + fieldInfo.getDeclaringClassName());
                    return nodes.get(0).getNodeValue();
                }
            }
            if (xvalue.value() != null) {
                return xvalue.value().toString();
            }
            return null;
        }
        catch (XPathException ex) {
            this.errors.add(ex, "Failed to evaluate syntax model scalar value expression for field " + fieldInfo.getFieldName() + " of type " + fieldInfo.getDeclaringClassName());
            return null;
        }
    }

    private void bindRawValue(@NotNull XTreeNodeBase nodeInfo, @NotNull NodeFieldInfo fieldInfo, @NotNull Object value) {
        try {
            this.bindRawValueImpl(nodeInfo, fieldInfo, value);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            this.errors.add(ex, "Failed to bind raw value to field " + fieldInfo.getFieldName() + " of type " + fieldInfo.getDeclaringClassName());
        }
    }

    private void bindRawValueImpl(@NotNull XTreeNodeBase nodeInfo, @NotNull NodeFieldInfo fieldInfo, @Nullable Object value) throws IllegalArgumentException, IllegalAccessException {
        switch (fieldInfo.kind) {
            case Object: {
                if (value instanceof XTreeNodeBase) {
                    XTreeNodeBase subnodeInfo = (XTreeNodeBase)value;
                    if (subnodeInfo.getModel() == null) break;
                    fieldInfo.setValue(nodeInfo.getModel(), subnodeInfo.getModel());
                    break;
                }
                fieldInfo.setValue(nodeInfo.getModel(), value);
                break;
            }
            case Array: {
                throw new UnsupportedOperationException("Arrays binding for syntax model is not implemented yet");
            }
            case List: {
                ArrayList<Object> list = (ArrayList<Object>)fieldInfo.getValue(nodeInfo.getModel());
                if (list == null) {
                    list = new ArrayList<Object>();
                    fieldInfo.setValue(nodeInfo.getModel(), list);
                } else {
                    list.clear();
                }
                if (value instanceof XPathNodes) {
                    XPathNodes nodes = (XPathNodes)value;
                    if (list instanceof ArrayList) {
                        list.ensureCapacity(nodes.size());
                    }
                    for (Node xnode : nodes) {
                        XTreeNodeBase subnodeInfo;
                        if (!(xnode instanceof XTreeNodeBase) || (subnodeInfo = (XTreeNodeBase)xnode).getModel() == null) continue;
                        list.add(subnodeInfo.getModel());
                    }
                    break;
                }
                if (value instanceof XTreeNodeBase) {
                    XTreeNodeBase subnodeInfo = (XTreeNodeBase)value;
                    if (subnodeInfo.getModel() == null) break;
                    list.add(subnodeInfo.getModel());
                    break;
                }
                list.add(value);
                break;
            }
            case LiteralList: {
                ArrayList<Object> list = (ArrayList<Object>)fieldInfo.getValue(nodeInfo.getModel());
                if (list == null) {
                    list = new ArrayList<Object>();
                    fieldInfo.setValue(nodeInfo.getModel(), list);
                } else {
                    list.clear();
                }
                if (value instanceof String) {
                    list.add(value);
                    break;
                }
                if (value instanceof XPathNodes) {
                    XPathNodes nodes = (XPathNodes)value;
                    if (list instanceof ArrayList) {
                        list.ensureCapacity(nodes.size());
                    }
                    for (Node xnode : nodes) {
                        if (!(xnode instanceof XTreeNodeBase)) continue;
                        XTreeNodeBase subnodeInfo = (XTreeNodeBase)xnode;
                        list.add(subnodeInfo.getNodeValue());
                    }
                    break;
                }
                if (value instanceof XTreeNodeBase) {
                    XTreeNodeBase subnodeInfo = (XTreeNodeBase)value;
                    list.add(subnodeInfo.getNodeValue());
                    break;
                }
                list.add(value);
                break;
            }
            default: {
                fieldInfo.setValue(nodeInfo.getModel(), value);
            }
        }
    }

    private void mapSubtrees(@NotNull XTreeNodeBase nodeInfo, @NotNull NodeTypeInfo typeInfo, boolean tryExact, boolean tryDescedants, @NotNull Set<XTreeNodeBase> subnodes) {
        if (typeInfo != null) {
            if (tryExact && nodeInfo.getLocalName().equals(typeInfo.ruleName)) {
                if (subnodes.add(nodeInfo)) {
                    this.instantiateAndFill(typeInfo, nodeInfo);
                }
                return;
            }
            if (tryDescedants) {
                NodesList<XTreeNodeBase> childNodes = nodeInfo.findDescedantLayerByName(typeInfo.ruleName);
                for (XTreeNodeBase childNode : childNodes) {
                    if (!subnodes.add(childNode)) continue;
                    this.instantiateAndFill(typeInfo, childNode);
                }
            }
        }
    }

    private AbstractSyntaxNode mapSubtree(XTreeNodeBase nodeInfo, NodeTypeInfo typeInfo, boolean tryExact, boolean tryDescedants) {
        if (typeInfo != null) {
            XTreeNodeBase childNode;
            if (tryExact && nodeInfo.getLocalName().equals(typeInfo.ruleName)) {
                return this.instantiateAndFill(typeInfo, nodeInfo);
            }
            if (tryDescedants && (childNode = nodeInfo.findFirstDescedantByName(typeInfo.ruleName)) != null) {
                return this.instantiateAndFill(typeInfo, childNode);
            }
        }
        return null;
    }

    public <T extends AbstractSyntaxNode> SyntaxModelMappingResult<T> map(XTreeNodeBase rootInfo, Class<T> type) {
        AbstractSyntaxNode modelNode;
        NodeTypeInfo typeInfo = this.modelInfo.findNodeTypeInfo(type);
        if (typeInfo == null) {
            this.errors.add("Failed to find syntax model node info for type " + type.getName() + ". Consider introducing it to the model.");
        }
        if ((modelNode = this.mapSubtree(rootInfo, typeInfo, true, true)) != null) {
            AbstractSyntaxNode result = modelNode;
            return new SyntaxModelMappingResult<AbstractSyntaxNode>(this.errors, result);
        }
        return new SyntaxModelMappingResult<Object>(this.errors, null);
    }
}

