/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.stm;

import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.Tree;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.stm.STMParserOverrides;
import org.jkiss.dbeaver.model.stm.STMTreeRuleNode;

public interface STMTreeNode
extends Tree {
    public void fixup(@NotNull STMParserOverrides var1);

    @NotNull
    public String getNodeName();

    @NotNull
    public Interval getRealInterval();

    @Nullable
    default public String getTextContent() {
        String result = null;
        if (this instanceof STMTreeRuleNode) {
            STMTreeRuleNode ruleNode = (STMTreeRuleNode)this;
            Interval textRange = ruleNode.getRealInterval();
            result = ruleNode.getStart().getInputStream().getText(textRange);
        } else if (this instanceof TerminalNode) {
            Interval textRange = this.getRealInterval();
            result = ((TerminalNode)this).getSymbol().getInputStream().getText(textRange);
        } else if (this instanceof ParseTree) {
            result = ((ParseTree)this).getText();
        } else {
            STMTreeNode first = this;
            STMTreeNode last = this;
            while (!(first instanceof TerminalNode) && first.getChildCount() > 0) {
                first = first.getChild(0);
            }
            while (!(last instanceof TerminalNode) && last.getChildCount() > 0) {
                last = last.getChild(last.getChildCount() - 1);
            }
            if (first instanceof TerminalNode && last instanceof TerminalNode) {
                TerminalNode a = (TerminalNode)first;
                TerminalNode b = (TerminalNode)last;
                Interval textRange = Interval.of((int)a.getSymbol().getStartIndex(), (int)b.getSymbol().getStopIndex());
                result = b.getSymbol().getTokenSource().getInputStream().getText(textRange);
            }
        }
        return result;
    }

    @NotNull
    public String getText();
}

