/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.exec.SQLNativeExecutorDescriptor;
import org.jkiss.dbeaver.ui.actions.exec.SQLNativeExecutorRegistry;
import org.jkiss.dbeaver.ui.actions.exec.SQLScriptExecutor;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class NavigatorHandlerExec
extends AbstractHandler {
    private static final Log log = Log.getLog(NavigatorHandlerExec.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection.isEmpty()) {
            return null;
        }
        DBNNode node = NavigatorUtils.getSelectedNode(selection);
        assert (node instanceof DBNResource);
        IResource resource = ((DBNResource)node).getResource();
        assert (resource instanceof IFile);
        final IFile script = (IFile)resource;
        final DBPDataSourceContainer container = EditorUtils.getFileDataSource((IFile)script);
        if (container == null) {
            return null;
        }
        new AbstractJob("Calling native execution"){

            protected IStatus run(DBRProgressMonitor monitor) {
                block14: {
                    DBPProject project = DBPPlatformDesktop.getInstance().getWorkspace().getProject(script.getProject());
                    String resourcePath = project.getResourcePath((IResource)script);
                    String catalog = (String)project.getResourceProperty(resourcePath, "default-catalog");
                    try {
                        File file;
                        SQLNativeExecutorDescriptor executorDescriptor;
                        DBPDataSource launchObject;
                        block15: {
                            Collection children;
                            DBSObject foundCatalog;
                            DBPDataSource dataSource;
                            if (!container.isConnected()) {
                                container.connect(monitor, true, false);
                            }
                            launchObject = dataSource = container.getDataSource();
                            if (catalog != null && dataSource instanceof DBSObjectContainer && DBSCatalog.class.isAssignableFrom(((DBSObjectContainer)dataSource).getPrimaryChildType(monitor)) && (foundCatalog = (DBSObject)DBUtils.findObject((Collection)(children = ((DBSObjectContainer)dataSource).getChildren(monitor)), (String)catalog)) != null) {
                                launchObject = foundCatalog;
                            }
                            if ((executorDescriptor = SQLNativeExecutorRegistry.getInstance().getExecutorDescriptor(container)) == null || executorDescriptor.getNativeExecutor() == null) break block14;
                            if (DBWorkbench.isDistributed()) {
                                file = Files.createTempFile("temp_script", ".sql", new FileAttribute[0]).toFile();
                                IFileStore store = EFS.getStore((URI)script.getLocationURI());
                                Throwable throwable = null;
                                Object var11_13 = null;
                                try (InputStream inputStream = store.openInputStream(0, monitor.getNestedMonitor());){
                                    Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                    break block15;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            file = new File(script.getLocationURI());
                        }
                        SQLScriptExecutor<? extends DBSObject> nativeExecutor = executorDescriptor.getNativeExecutor();
                        DBPDataSource finalLaunchObject = launchObject;
                        UIUtils.syncExec(() -> 1.lambda$0(nativeExecutor, (DBSObject)finalLaunchObject, file));
                    }
                    catch (Throwable exception) {
                        return Status.error((String)"Error calling native execution", (Throwable)exception);
                    }
                }
                return Status.OK_STATUS;
            }

            private static /* synthetic */ void lambda$0(SQLScriptExecutor sQLScriptExecutor, DBSObject dBSObject, File file) {
                try {
                    sQLScriptExecutor.execute(dBSObject, file);
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
            }
        }.schedule();
        return null;
    }
}

