/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions.node;

import org.eclipse.swt.widgets.Event;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorNodeActionHandlerAbstract;
import org.jkiss.utils.CommonUtils;

public class NNAHDataSourceTunnel
extends NavigatorNodeActionHandlerAbstract {
    @Override
    public boolean isEnabledFor(INavigatorModelView view, DBNNode node) {
        if (node instanceof DBNDataSource) {
            return ((DBNDataSource)node).hasNetworkHandlers();
        }
        return false;
    }

    @Override
    public DBPImage getNodeActionIcon(INavigatorModelView view, DBNNode node) {
        return UIIcon.BUTTON_TUNNEL;
    }

    @Override
    public String getNodeActionToolTip(INavigatorModelView view, DBNNode node) {
        StringBuilder tip = new StringBuilder("Network handlers enabled:");
        for (DBWHandlerConfiguration handler : ((DBNDataSource)node).getDataSourceContainer().getConnectionConfiguration().getHandlers()) {
            if (!handler.isEnabled()) continue;
            tip.append("\n  -").append(handler.getHandlerDescriptor().getLabel());
            String hostName = handler.getStringProperty("host");
            if (CommonUtils.isEmpty((String)hostName)) continue;
            tip.append(": ").append(hostName);
        }
        return tip.toString();
    }

    @Override
    public void handleNodeAction(INavigatorModelView view, DBNNode node, Event event, boolean defaultAction) {
        if (node instanceof DBNDatabaseNode) {
            DBPDataSourceContainer dataSourceContainer = ((DBNDatabaseNode)node).getDataSourceContainer();
            String nhId = null;
            for (DBWHandlerConfiguration nhc : dataSourceContainer.getConnectionConfiguration().getHandlers()) {
                if (!nhc.isEnabled() || nhc.getHandlerDescriptor().getType() != DBWHandlerType.TUNNEL) continue;
                nhId = nhc.getId();
                break;
            }
            UIServiceConnections serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class);
            if (serviceConnections != null) {
                serviceConnections.openConnectionEditor(dataSourceContainer, "ConnectionPageNetworkHandler." + nhId);
            }
        }
    }
}

