/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.dialogs;

import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.dbeaver.ui.navigator.dialogs.ObjectBrowserDialogBase;

public class ObjectBrowserDialog
extends ObjectBrowserDialogBase {
    private Class<?>[] allowedTypes;
    private Class<?>[] resultTypes;
    private Class<?>[] leafTypes;

    private ObjectBrowserDialog(Shell parentShell, String title, DBNNode rootNode, DBNNode selectedNode, boolean singleSelection, Class<?>[] allowedTypes, Class<?>[] resultTypes, Class<?>[] leafTypes) {
        super(parentShell, title, rootNode, selectedNode, singleSelection);
        this.allowedTypes = allowedTypes;
        this.resultTypes = resultTypes == null ? allowedTypes : resultTypes;
        this.leafTypes = leafTypes;
    }

    @Override
    protected DatabaseNavigatorTreeFilter createNavigatorFilter() {
        return new DatabaseNavigatorTreeFilter(){

            @Override
            public boolean isLeafObject(Object object) {
                if (ObjectBrowserDialog.this.leafTypes != null && ObjectBrowserDialog.this.leafTypes.length > 0 && object instanceof DBNDatabaseNode) {
                    DBNDatabaseNode node = (DBNDatabaseNode)object;
                    DBSObject dbObject = node.getObject();
                    DBXTreeNode meta = node.getMeta();
                    if (dbObject != null) {
                        Class<?>[] classArray = ObjectBrowserDialog.this.leafTypes;
                        int n = ObjectBrowserDialog.this.leafTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Class<?> leafType = classArray[n2];
                            if (leafType.isAssignableFrom(dbObject.getClass())) {
                                if (DBSObjectContainer.class.isAssignableFrom(leafType)) {
                                    return !DBNNode.nodeHasStructureContainers((DBNNode)node, (DBXTreeNode)meta);
                                }
                                return true;
                            }
                            ++n2;
                        }
                    }
                }
                return super.isLeafObject(object);
            }
        };
    }

    @Override
    protected ViewerFilter createViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (ObjectBrowserDialog.isShowConnected()) {
                    if (element instanceof DBNDataSource) {
                        return ((DBNDataSource)element).getDataSource() != null;
                    }
                    if (element instanceof DBNLocalFolder) {
                        return ((DBNLocalFolder)element).hasConnected();
                    }
                }
                if (element instanceof TreeNodeSpecial || element instanceof DBNLocalFolder) {
                    return true;
                }
                if (element instanceof DBNNode) {
                    if (element instanceof DBNDatabaseFolder) {
                        DBNDatabaseFolder folder = (DBNDatabaseFolder)element;
                        Class folderItemsClass = folder.getChildrenClass();
                        return folderItemsClass != null && ObjectBrowserDialog.this.matchesType(folderItemsClass, false);
                    }
                    if (element instanceof DBNProject || element instanceof DBNProjectDatabases || element instanceof DBNDataSource || element instanceof DBSWrapper && ObjectBrowserDialog.this.matchesType(((DBSWrapper)element).getObject().getClass(), false)) {
                        return true;
                    }
                    if (!(element instanceof DBNDatabaseNode) && !((DBNNode)element).isPersisted()) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    @Override
    protected boolean matchesType(Object object, boolean result) {
        Class<?>[] classArray = result ? this.resultTypes : this.allowedTypes;
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> ot = classArray[n2];
            if (ot.isAssignableFrom(object.getClass())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean matchesType(Class<?> nodeType, boolean result) {
        Class<?>[] classArray = result ? this.resultTypes : this.allowedTypes;
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> ot = classArray[n2];
            if (ot.isAssignableFrom(nodeType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static DBNNode selectObject(Shell parentShell, String title, DBNNode rootNode, DBNNode selectedNode, Class<?>[] allowedTypes, Class<?>[] resultTypes, Class<?>[] leafTypes) {
        ObjectBrowserDialog scDialog = new ObjectBrowserDialog(parentShell, title, rootNode, selectedNode, true, allowedTypes, resultTypes, leafTypes);
        if (scDialog.open() == 0) {
            List<DBNNode> result = scDialog.getSelectedObjects();
            return result.isEmpty() ? null : result.get(0);
        }
        return null;
    }

    public static List<DBNNode> selectObjects(Shell parentShell, String title, DBNNode rootNode, DBNNode selectedNode, Class<?>[] allowedTypes, Class<?>[] resultTypes, Class<?>[] leafTypes) {
        ObjectBrowserDialog scDialog = new ObjectBrowserDialog(parentShell, title, rootNode, selectedNode, false, allowedTypes, resultTypes, leafTypes);
        if (scDialog.open() == 0) {
            return scDialog.getSelectedObjects();
        }
        return null;
    }
}

