/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.lsm.LSMElement;
import org.jkiss.dbeaver.model.lsm.mapping.ConcreteSyntaxNode;
import org.jkiss.dbeaver.model.lsm.mapping.SyntaxNode;
import org.jkiss.dbeaver.model.lsm.mapping.internal.NodeFieldInfo;
import org.jkiss.dbeaver.model.lsm.mapping.internal.XTreeNodeBase;

public abstract class AbstractSyntaxNode
implements LSMElement {
    private static final Map<Class<? extends AbstractSyntaxNode>, String> syntaxNodeNameByType = new HashMap<Class<ConcreteSyntaxNode>, String>(Map.of(ConcreteSyntaxNode.class, ""));
    public static final int UNDEFINED_POSITION = -1;
    private final String name;
    private XTreeNodeBase astNode = null;
    private List<BindingInfo> subnodeBindings = null;
    private static final Comparator<BindingInfo> BINDING_MY_POS_COMPARER = (a, b) -> {
        Interval x = a.astNode.getSourceInterval();
        Interval y = b.astNode.getSourceInterval();
        int rc = Integer.compare(x.a, y.a);
        if (rc == 0) {
            rc = Integer.compare(x.b, y.b);
        }
        return rc;
    };

    @NotNull
    private static String getNodeName(@NotNull Class<? extends AbstractSyntaxNode> type) {
        return syntaxNodeNameByType.computeIfAbsent(type, t -> Optional.of(t.getAnnotation(SyntaxNode.class).name()).orElse(t.getName()));
    }

    protected AbstractSyntaxNode() {
        this.name = AbstractSyntaxNode.getNodeName(this.getClass());
    }

    protected AbstractSyntaxNode(@Nullable String name) {
        this.name = name;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public int getStartPosition() {
        return this.astNode != null ? this.astNode.getRealInterval().a : -1;
    }

    public int getEndPosition() {
        return this.astNode != null ? this.astNode.getRealInterval().b : -1;
    }

    void setAstNode(@NotNull XTreeNodeBase astNode) {
        this.astNode = astNode;
        this.subnodeBindings = null;
    }

    @NotNull
    XTreeNodeBase getAstNode() {
        return this.astNode;
    }

    void appendBinding(@NotNull BindingInfo binding) {
        if (this.subnodeBindings == null) {
            this.subnodeBindings = new LinkedList<BindingInfo>();
        }
        this.subnodeBindings.add(binding);
    }

    @NotNull
    List<BindingInfo> getBindings() {
        if (this.subnodeBindings == null) {
            return Collections.emptyList();
        }
        if (this.subnodeBindings instanceof LinkedList) {
            ArrayList<BindingInfo> bindings = new ArrayList<BindingInfo>(this.subnodeBindings);
            bindings.sort(BINDING_MY_POS_COMPARER);
            this.subnodeBindings = bindings;
        }
        return this.subnodeBindings;
    }

    @Nullable
    public SyntaxModelLookupResult findBoundSyntaxAt(int position) {
        Interval location = new Interval(position, position);
        AbstractSyntaxNode node = this;
        if (node.astNode.getRealInterval().properlyContains(location)) {
            BindingInfo nodeBinding = AbstractSyntaxNode.findBindingOfLocation(node, location);
            while (nodeBinding != null && nodeBinding.value instanceof AbstractSyntaxNode) {
                node = (AbstractSyntaxNode)nodeBinding.value;
                nodeBinding = AbstractSyntaxNode.findBindingOfLocation(node, location);
            }
            return new SyntaxModelLookupResult(node, nodeBinding);
        }
        return null;
    }

    @Nullable
    private static BindingInfo findBindingOfLocation(@NotNull AbstractSyntaxNode node, @NotNull Interval location) {
        List<BindingInfo> bindings = node.getBindings();
        int index = AbstractSyntaxNode.binarySearchByKey(bindings, b -> b.astNode.getRealInterval(), location, (x, y) -> {
            if (x.b < y.a) {
                return -1;
            }
            if (x.a > y.b) {
                return 1;
            }
            return 0;
        });
        if (index < 0) {
            return null;
        }
        int resultIndex = index;
        BindingInfo result = bindings.get(index);
        Interval interval = result.astNode.getRealInterval();
        while (index > 0) {
            BindingInfo prev = bindings.get(--index);
            Interval prevInterval = prev.astNode.getRealInterval();
            if (!prevInterval.properlyContains(location) || prevInterval.length() >= interval.length()) break;
            result = prev;
            interval = prevInterval;
        }
        if (resultIndex == index) {
            int lastIndex = bindings.size() - 1;
            while (index < lastIndex) {
                BindingInfo next = bindings.get(++index);
                Interval nextInterval = next.astNode.getRealInterval();
                if (!nextInterval.properlyContains(location) || nextInterval.length() >= interval.length()) break;
                result = next;
                interval = nextInterval;
            }
        }
        return result;
    }

    private static <T, K> int binarySearchByKey(@NotNull List<T> list, @NotNull Function<T, K> keyGetter, @NotNull K key, @NotNull Comparator<K> comparator) {
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            K midVal = keyGetter.apply(list.get(mid));
            int cmp = comparator.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    static class BindingInfo {
        public final NodeFieldInfo field;
        public final Object value;
        public final XTreeNodeBase astNode;

        public BindingInfo(@NotNull NodeFieldInfo field, @Nullable Object value, @NotNull XTreeNodeBase astNode) {
            this.field = field;
            this.value = value;
            this.astNode = astNode;
        }
    }

    public static class SyntaxModelLookupResult {
        public final AbstractSyntaxNode node;
        final BindingInfo binding;
        final XTreeNodeBase astNode;

        public SyntaxModelLookupResult(@NotNull AbstractSyntaxNode node, @Nullable BindingInfo binding) {
            this.node = node;
            this.binding = binding;
            this.astNode = binding == null ? node.astNode : binding.astNode;
        }

        @NotNull
        public Interval getInterval() {
            return this.astNode.getRealInterval();
        }

        @Nullable
        public String getEntityName() {
            return this.node.getName();
        }

        @Nullable
        public String getEntityFieldName() {
            return this.binding == null ? null : this.binding.field.getFieldName();
        }

        @NotNull
        public String getAstNodeFullName() {
            return this.astNode.getFullPathName();
        }

        @NotNull
        public String toString() {
            String element = this.binding == null ? this.getEntityName() : String.valueOf(this.getEntityFieldName()) + " of " + this.getEntityName();
            return "SyntaxModelLookupResult[" + element + " @" + this.getInterval() + "]";
        }
    }
}

