/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.DBPInformationProvider;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceFolder;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettings;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataSourceUtils {
    public static final String PARAM_ID = "id";
    public static final String PARAM_DRIVER = "driver";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_URL = "url";
    public static final String PARAM_HOST = "host";
    public static final String PARAM_PORT = "port";
    public static final String PARAM_SERVER = "server";
    public static final String PARAM_DATABASE = "database";
    public static final String PARAM_USER = "user";
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_SAVE_PASSWORD = "savePassword";
    private static final String PARAM_AUTH_MODEL = "auth";
    private static final String PARAM_SHOW_SYSTEM_OBJECTS = "showSystemObjects";
    private static final String PARAM_SHOW_UTILITY_OBJECTS = "showUtilityObjects";
    private static final String PARAM_SHOW_ONLY_ENTITIES = "showOnlyEntities";
    private static final String PARAM_HIDE_FOLDERS = "hideFolders";
    private static final String PARAM_HIDE_SCHEMAS = "hideSchemas";
    private static final String PARAM_MERGE_ENTITIES = "mergeEntities";
    private static final String PARAM_FOLDER = "folder";
    private static final String PARAM_AUTO_COMMIT = "autoCommit";
    private static final String PARAM_CREATE = "create";
    private static final String PARAM_SAVE = "save";
    private static final String PREFIX_HANDLER = "handler.";
    private static final String PREFIX_PROP = "prop.";
    private static final String PREFIX_AUTH_PROP = "authProp.";
    private static final Log log = Log.getLog(DataSourceUtils.class);

    public static DBPDataSourceContainer getDataSourceBySpec(@NotNull DBPProject project, @NotNull String connectionSpec, @Nullable GeneralUtils.IParameterHandler parameterHandler, boolean searchByParameters, boolean createNewDataSource) {
        String[] conParams;
        DBPDataSourceRegistry dsRegistry;
        String driverName = null;
        String url = null;
        String host = null;
        String port = null;
        String server = null;
        String database = null;
        String user = null;
        String password = null;
        String authModelId = null;
        boolean showSystemObjects = false;
        boolean showUtilityObjects = false;
        boolean showOnlyEntities = false;
        boolean hideFolders = false;
        boolean hideSchemas = false;
        boolean mergeEntities = false;
        boolean savePassword = true;
        boolean isTemporary = true;
        Boolean autoCommit = null;
        HashMap<String, String> conProperties = new HashMap<String, String>();
        HashMap<String, Map> handlerProps = new HashMap<String, Map>();
        HashMap<String, String> authProperties = new HashMap<String, String>();
        DBPDataSourceFolder folder = null;
        String dsId = null;
        String dsName = null;
        DBPDataSourceRegistry dBPDataSourceRegistry = dsRegistry = project == null ? null : project.getDataSourceRegistry();
        if (dsRegistry == null) {
            log.debug((Object)("No datasource registry for project '" + project.getName() + "'"));
            return null;
        }
        String[] stringArray = conParams = connectionSpec.split("\\|");
        int n = conParams.length;
        int n2 = 0;
        while (n2 < n) {
            block114: {
                String cp = stringArray[n2];
                int divPos = cp.indexOf(61);
                if (divPos == -1) break block114;
                String paramName = cp.substring(0, divPos);
                String paramValue = cp.substring(divPos + 1);
                switch (paramName) {
                    case "id": {
                        dsId = paramValue;
                        break;
                    }
                    case "driver": {
                        driverName = paramValue;
                        break;
                    }
                    case "name": {
                        dsName = paramValue;
                        break;
                    }
                    case "url": {
                        url = paramValue;
                        break;
                    }
                    case "host": {
                        host = paramValue;
                        break;
                    }
                    case "port": {
                        port = paramValue;
                        break;
                    }
                    case "server": {
                        server = paramValue;
                        break;
                    }
                    case "database": {
                        database = paramValue;
                        break;
                    }
                    case "user": {
                        user = paramValue;
                        break;
                    }
                    case "password": {
                        password = paramValue;
                        break;
                    }
                    case "auth": {
                        authModelId = paramValue;
                        break;
                    }
                    case "savePassword": {
                        savePassword = CommonUtils.toBoolean((Object)paramValue);
                        break;
                    }
                    case "showSystemObjects": {
                        showSystemObjects = CommonUtils.toBoolean((Object)paramValue);
                        break;
                    }
                    case "showUtilityObjects": {
                        showUtilityObjects = CommonUtils.toBoolean((Object)paramValue);
                        break;
                    }
                    case "showOnlyEntities": {
                        showOnlyEntities = CommonUtils.toBoolean((Object)paramValue);
                        break;
                    }
                    case "hideFolders": {
                        hideFolders = CommonUtils.toBoolean((Object)paramValue);
                        break;
                    }
                    case "hideSchemas": {
                        hideSchemas = CommonUtils.toBoolean((Object)paramValue);
                        break;
                    }
                    case "mergeEntities": {
                        mergeEntities = CommonUtils.toBoolean((Object)paramValue);
                        break;
                    }
                    case "folder": {
                        folder = dsRegistry.getFolder(paramValue);
                        break;
                    }
                    case "autoCommit": {
                        autoCommit = CommonUtils.toBoolean((Object)paramValue);
                        break;
                    }
                    case "create": {
                        createNewDataSource = CommonUtils.toBoolean((Object)paramValue);
                        if (parameterHandler == null) break;
                        parameterHandler.setParameter(paramName, paramValue);
                        break;
                    }
                    case "save": {
                        isTemporary = !CommonUtils.toBoolean((Object)paramValue);
                        break;
                    }
                    default: {
                        boolean handled = false;
                        if (paramName.length() > PREFIX_PROP.length() && paramName.startsWith(PREFIX_PROP)) {
                            paramName = paramName.substring(PREFIX_PROP.length());
                            conProperties.put(paramName, paramValue);
                            handled = true;
                        } else if (paramName.length() > PREFIX_AUTH_PROP.length() && paramName.startsWith(PREFIX_AUTH_PROP)) {
                            paramName = paramName.substring(PREFIX_AUTH_PROP.length());
                            authProperties.put(paramName, paramValue);
                            handled = true;
                        } else if (paramName.length() > PREFIX_HANDLER.length() && paramName.startsWith(PREFIX_HANDLER)) {
                            divPos = (paramName = paramName.substring(PREFIX_HANDLER.length())).indexOf(46);
                            if (divPos == -1) {
                                log.debug((Object)("Wrong handler parameter: '" + paramName + "'"));
                                break;
                            }
                            String handlerId = paramName.substring(0, divPos);
                            paramName = paramName.substring(divPos + 1);
                            Map handlerPopMap = handlerProps.computeIfAbsent(handlerId, k -> new HashMap());
                            handlerPopMap.put(paramName, paramValue);
                            handled = true;
                        } else if (parameterHandler != null) {
                            handled = parameterHandler.setParameter(paramName, paramValue);
                        }
                        if (handled) break;
                        log.debug((Object)("Unknown connection parameter '" + paramName + "'"));
                    }
                }
            }
            ++n2;
        }
        DBPDataSourceContainer dataSource = null;
        if (dsId != null) {
            dataSource = dsRegistry.getDataSource(dsId);
        }
        if (dsName != null) {
            dataSource = dsRegistry.findDataSourceByName(dsName);
        }
        if (dataSource != null) {
            DBPConnectionConfiguration connConfig = dataSource.getConnectionConfiguration();
            if (!CommonUtils.isEmpty(database)) {
                connConfig.setDatabaseName(database);
            }
            if (!CommonUtils.isEmpty(user)) {
                connConfig.setUserName(user);
            }
            if (!CommonUtils.isEmpty(password)) {
                connConfig.setUserPassword(password);
            }
            if (!CommonUtils.isEmpty(conProperties)) {
                connConfig.setProperties(conProperties);
            }
            if (!CommonUtils.isEmpty(authProperties)) {
                connConfig.setAuthProperties(authProperties);
            }
            if (!CommonUtils.isEmpty(authModelId)) {
                connConfig.setAuthModelId(authModelId);
            }
            return dataSource;
        }
        if (searchByParameters) {
            if (url != null) {
                for (DBPDataSourceContainer ds : dsRegistry.getDataSources()) {
                    if (!url.equals(ds.getConnectionConfiguration().getUrl()) || user != null && !user.equals(ds.getConnectionConfiguration().getUserName())) continue;
                    return ds;
                }
            } else {
                for (DBPDataSourceContainer ds : dsRegistry.getDataSources()) {
                    DBPConnectionConfiguration cfg = ds.getConnectionConfiguration();
                    if (server != null && !server.equals(cfg.getServerName()) || host != null && !host.equals(cfg.getHostName()) || port != null && !port.equals(cfg.getHostPort()) || database != null && !database.equals(cfg.getDatabaseName()) || user != null && !user.equals(cfg.getUserName())) continue;
                    boolean matched = true;
                    if (!conProperties.isEmpty()) {
                        for (Map.Entry prop : conProperties.entrySet()) {
                            if (CommonUtils.equalObjects((Object)cfg.getProperty((String)prop.getKey()), prop.getValue())) continue;
                            matched = false;
                            break;
                        }
                        if (!matched) continue;
                    }
                    if (!handlerProps.isEmpty()) {
                        for (Map.Entry handlerProp : handlerProps.entrySet()) {
                            DBWHandlerConfiguration handler = cfg.getHandler((String)handlerProp.getKey());
                            if (handler == null) {
                                matched = false;
                                break;
                            }
                            for (Map.Entry prop : ((Map)handlerProp.getValue()).entrySet()) {
                                if (CommonUtils.equalObjects((Object)handler.getProperty((String)prop.getKey()), prop.getValue())) continue;
                                matched = false;
                                break;
                            }
                            if (!matched) break;
                        }
                        if (!matched) continue;
                    }
                    return ds;
                }
            }
        }
        if (!createNewDataSource) {
            return null;
        }
        if (driverName == null) {
            log.error((Object)"Driver name not specified - can't create new datasource");
            return null;
        }
        DBPDriver driver = DBWorkbench.getPlatform().getDataSourceProviderRegistry().findDriver(driverName);
        if (driver == null) {
            log.error((Object)("Driver '" + driverName + "' not found"));
            return null;
        }
        if (dsName == null) {
            dsName = "Ext: " + driver.getName();
            if (database != null) {
                dsName = String.valueOf(dsName) + " - " + database;
            } else if (server != null) {
                dsName = String.valueOf(dsName) + " - " + server;
            }
        }
        DBPConnectionConfiguration connConfig = new DBPConnectionConfiguration();
        connConfig.setUrl(url);
        connConfig.setHostName(host);
        connConfig.setHostPort(port);
        connConfig.setServerName(server);
        connConfig.setDatabaseName(database);
        connConfig.setUserName(user);
        connConfig.setUserPassword(password);
        connConfig.setProperties(conProperties);
        if (!CommonUtils.isEmpty(authProperties)) {
            connConfig.setAuthProperties(authProperties);
        }
        if (!CommonUtils.isEmpty((String)authModelId)) {
            connConfig.setAuthModelId(authModelId);
        }
        if (autoCommit != null) {
            connConfig.getBootstrap().setDefaultAutoCommit(autoCommit);
        }
        DBPDataSourceContainer newDS = dsRegistry.createDataSource(driver, connConfig);
        newDS.setName(dsName);
        ((DataSourceDescriptor)newDS).setTemporary(isTemporary);
        if (savePassword) {
            newDS.setSavePassword(true);
        }
        if (folder != null) {
            newDS.setFolder(folder);
        }
        DataSourceNavigatorSettings navSettings = ((DataSourceDescriptor)newDS).getNavigatorSettings();
        navSettings.setShowSystemObjects(showSystemObjects);
        navSettings.setShowUtilityObjects(showUtilityObjects);
        navSettings.setShowOnlyEntities(showOnlyEntities);
        navSettings.setHideSchemas(hideSchemas);
        navSettings.setHideFolders(hideFolders);
        navSettings.setMergeEntities(mergeEntities);
        try {
            dsRegistry.addDataSource(newDS);
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return newDS;
    }

    @NotNull
    public static String getDataSourceAddressText(DBPDataSourceContainer dataSourceContainer) {
        String objectInformation;
        DBPDataSourceProvider dataSourceProvider;
        if (dataSourceContainer.getDriver().isCustomEndpointInformation() && (dataSourceProvider = dataSourceContainer.getDriver().getDataSourceProvider()) instanceof DBPInformationProvider && !CommonUtils.isEmpty((String)(objectInformation = ((DBPInformationProvider)dataSourceProvider).getObjectInformation((DBPObject)dataSourceContainer, "targetAddress")))) {
            return objectInformation;
        }
        DBPConnectionConfiguration cfg = dataSourceContainer.getConnectionConfiguration();
        if (cfg.getConfigurationType() == DBPDriverConfigurationType.MANUAL) {
            String hostText = DataSourceUtils.getTargetTunnelHostName(cfg);
            String hostPort = cfg.getHostPort();
            if (!CommonUtils.isEmpty((String)hostPort)) {
                return String.valueOf(hostText) + ":" + hostPort;
            }
            return hostText;
        }
        return cfg.getUrl();
    }

    @NotNull
    public static String getTargetTunnelHostName(DBPConnectionConfiguration cfg) {
        String hostText = cfg.getHostName();
        if (CommonUtils.isEmpty((String)hostText) || hostText.equals("localhost") || hostText.equals("127.0.0.1")) {
            for (DBWHandlerConfiguration hc : cfg.getHandlers()) {
                String tunnelHost;
                if (!hc.isEnabled() || hc.getType() != DBWHandlerType.TUNNEL || CommonUtils.isEmpty((String)(tunnelHost = hc.getStringProperty(PARAM_HOST)))) continue;
                hostText = tunnelHost;
                break;
            }
        }
        return CommonUtils.notEmpty((String)hostText);
    }

    public static boolean isFolderHasTemporaryDataSources(DataSourceFolder folder) {
        return folder.getDataSourceRegistry().getDataSources().stream().anyMatch(d -> d.getFolder() == folder && d.isTemporary());
    }
}

