/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;

public class SQLQueryParameter {
    public static final String VARIABLE_NAME_GROUP_NAME = "pn";
    private static final Pattern VARIABLE_PATTERN_SIMPLE = Pattern.compile("\\$\\{(?<pn>[a-z0-9_]+)\\}", 2);
    private static final Pattern VARIABLE_PATTERN_FULL = Pattern.compile("\\$P?!?\\{(?<pn>[a-z0-9_]+)\\}", 2);
    private final SQLSyntaxManager syntaxManager;
    private final int ordinalPosition;
    private final String name;
    private final String originalName;
    private String value;
    private boolean variableSet;
    private final int tokenOffset;
    private final int tokenLength;
    private SQLQueryParameter previous;

    public SQLQueryParameter(SQLSyntaxManager syntaxManager, int ordinalPosition, String name, String originalName) {
        this(syntaxManager, ordinalPosition, name, originalName, 0, 0);
    }

    public SQLQueryParameter(SQLSyntaxManager syntaxManager, int ordinalPosition, String name, String originalName, int tokenOffset, int tokenLength) {
        this.syntaxManager = syntaxManager;
        if (tokenOffset < 0) {
            throw new IndexOutOfBoundsException("Bad parameter offset: " + tokenOffset);
        }
        if (tokenLength < 0) {
            throw new IndexOutOfBoundsException("Bad parameter length: " + tokenLength);
        }
        this.ordinalPosition = ordinalPosition;
        this.name = name.trim();
        this.originalName = originalName;
        this.tokenOffset = tokenOffset;
        this.tokenLength = tokenLength;
    }

    public boolean isNamed() {
        return !String.valueOf(this.syntaxManager.getAnonymousParameterMark()).equals(this.name);
    }

    public int getTokenOffset() {
        return this.tokenOffset;
    }

    public int getTokenLength() {
        return this.tokenLength;
    }

    public SQLQueryParameter getPrevious() {
        return this.previous;
    }

    public void setPrevious(SQLQueryParameter previous) {
        this.previous = previous;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isVariableSet() {
        return this.variableSet;
    }

    public void setVariableSet(boolean variableSet) {
        this.variableSet = variableSet;
    }

    public String getVarName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.getVarName()) + "=" + this.value;
    }

    public static Pattern getVariablePattern() {
        if (SQLQueryParameter.supportsJasperSyntax()) {
            return VARIABLE_PATTERN_FULL;
        }
        return VARIABLE_PATTERN_SIMPLE;
    }

    public static boolean supportsJasperSyntax() {
        return true;
    }

    @NotNull
    public static String stripVariablePattern(String pattern) {
        if (SQLQueryParameter.supportsJasperSyntax()) {
            if (pattern.startsWith("$P{") && pattern.endsWith("}")) {
                return pattern.substring(3, pattern.length() - 1);
            }
            if (pattern.startsWith("$P!{") && pattern.endsWith("}")) {
                return pattern.substring(4, pattern.length() - 1);
            }
        }
        if (pattern.startsWith("${") && pattern.endsWith("}")) {
            return pattern.substring(2, pattern.length() - 1);
        }
        return pattern;
    }
}

