/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIMessages;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.utils.CommonUtils;

class DiagramCreateWizardPage
extends WizardPage {
    private EntityDiagram diagram;
    private DatabaseNavigatorTree contentTree;
    private IStructuredSelection entitySelection;
    @Nullable
    private DBPProject project;

    protected DiagramCreateWizardPage(EntityDiagram diagram, IStructuredSelection entitySelection, @Nullable DBPProject project) {
        super(ERDUIMessages.wizard_page_diagram_create_name);
        this.diagram = diagram;
        this.entitySelection = entitySelection;
        this.setTitle(ERDUIMessages.wizard_page_diagram_create_title);
        this.setDescription(ERDUIMessages.wizard_page_diagram_create_description);
        this.project = project;
    }

    public boolean isPageComplete() {
        boolean hasName;
        if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("database-developer")) {
            this.setErrorMessage("The user needs more permissions to create a new diagram.");
            return false;
        }
        boolean bl = hasName = !CommonUtils.isEmpty((String)this.diagram.getName());
        if (!hasName) {
            this.setErrorMessage("Set diagram name");
        } else {
            this.setErrorMessage(null);
        }
        if (this.getErrorMessage() != null) {
            return false;
        }
        return hasName;
    }

    public void createControl(Composite parent) {
        Composite placeholder = UIUtils.createPlaceholder((Composite)parent, (int)1);
        Group configGroup = UIUtils.createControlGroup((Composite)placeholder, (String)ERDUIMessages.wizard_page_diagram_create_group_settings, (int)2, (int)1808, (int)0);
        final Text projectNameText = UIUtils.createLabelText((Composite)configGroup, (String)"Name", null);
        projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DiagramCreateWizardPage.this.diagram.setName(projectNameText.getText());
                DiagramCreateWizardPage.this.updateState();
            }
        });
        Label contentLabel = UIUtils.createControlLabel((Composite)configGroup, (String)ERDUIMessages.wizard_page_diagram_create_label_init_content);
        GridData gd = new GridData(1);
        gd.horizontalSpan = 2;
        contentLabel.setLayoutData((Object)gd);
        DBNProject rootNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(this.project);
        if (rootNode == null) {
            this.setControl((Control)placeholder);
            return;
        }
        this.contentTree = new DatabaseNavigatorTree((Composite)configGroup, (DBNNode)rootNode.getDatabases(), 36);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 400;
        this.contentTree.setLayoutData((Object)gd);
        CheckboxTreeViewer viewer = (CheckboxTreeViewer)this.contentTree.getViewer();
        viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                return false;
            }

            public boolean isGrayed(Object element) {
                DBSObject object;
                return !(element instanceof DBNDatabaseNode) || element instanceof DBNDataSource || !((object = ((DBNDatabaseNode)element).getObject()) instanceof DBSTable);
            }
        });
        if (this.entitySelection != null) {
            viewer.setSelection((ISelection)this.entitySelection, true);
            viewer.setCheckedElements(this.entitySelection.toArray());
        }
        this.setControl((Control)placeholder);
    }

    private void updateState() {
        this.getContainer().updateButtons();
    }

    Collection<DBNNode> getInitialContent() {
        if (this.contentTree == null) {
            return Collections.emptyList();
        }
        ArrayList<DBNNode> nodes = new ArrayList<DBNNode>();
        Object[] objectArray = this.contentTree.getCheckboxViewer().getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            DBNNode node = (DBNNode)obj;
            nodes.add(node);
            ++n2;
        }
        return nodes;
    }
}

