/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.vertica.model.VerticaConstraint;
import org.jkiss.dbeaver.ext.vertica.model.VerticaDataSource;
import org.jkiss.dbeaver.ext.vertica.model.VerticaNode;
import org.jkiss.dbeaver.ext.vertica.model.VerticaObjectType;
import org.jkiss.dbeaver.ext.vertica.model.VerticaProjection;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSchema;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSequence;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructureAssistant;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public class VerticaStructureAssistant
extends JDBCStructureAssistant<JDBCExecutionContext> {
    private final VerticaDataSource dataSource;

    VerticaStructureAssistant(VerticaDataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, VerticaObjectType.VIEW, RelationalObjectType.TYPE_CONSTRAINT, RelationalObjectType.TYPE_TABLE_COLUMN, RelationalObjectType.TYPE_VIEW_COLUMN, VerticaObjectType.SEQUENCE, VerticaObjectType.PROJECTION, VerticaObjectType.NODE};
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, VerticaObjectType.VIEW};
    }

    protected void findObjectsByMask(@NotNull JDBCExecutionContext executionContext, @NotNull JDBCSession session, @NotNull DBSObjectType objectType, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> references) throws DBException, SQLException {
        boolean searchInComments;
        GenericSchema parentSchema = params.isGlobalSearch() ? null : (params.getParentObject() instanceof GenericSchema ? (GenericSchema)params.getParentObject() : null);
        boolean avoidCommentsReading = false;
        JDBCDataSource dataSource = (JDBCDataSource)executionContext.getDataSource();
        if (dataSource instanceof VerticaDataSource) {
            avoidCommentsReading = ((VerticaDataSource)dataSource).avoidCommentsReading();
        }
        boolean bl = searchInComments = !avoidCommentsReading && params.isSearchInComments();
        if (objectType == RelationalObjectType.TYPE_TABLE || objectType == RelationalObjectType.TYPE_VIEW) {
            this.findTablesAndViewsByMask(session, parentSchema, params, references, searchInComments);
        }
        if (objectType == VerticaObjectType.SEQUENCE) {
            this.findSequencesByMask(session, parentSchema, params, references, searchInComments);
        }
        if (objectType == RelationalObjectType.TYPE_CONSTRAINT) {
            this.findConstraintsByMask(session, parentSchema, params, references, searchInComments);
        }
        if (objectType == RelationalObjectType.TYPE_TABLE_COLUMN) {
            this.findTableColumnsByMask(session, parentSchema, params, references);
        }
        if (objectType == RelationalObjectType.TYPE_VIEW_COLUMN) {
            this.findViewColumnsByMask(session, parentSchema, params, references);
        }
        if (objectType == VerticaObjectType.PROJECTION) {
            this.findProjectionsByMask(session, parentSchema, params, references, searchInComments);
        }
        if (objectType == VerticaObjectType.NODE) {
            this.findNodesByMask(session, params, references, searchInComments);
        }
    }

    private void findTablesAndViewsByMask(@NotNull JDBCSession session, @Nullable GenericSchema parentSchema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> result, boolean searchInComments) throws SQLException {
        List<DBSObjectType> objectTypesList = Arrays.asList(params.getObjectTypes());
        StringBuilder objectTypeClause = new StringBuilder(100);
        boolean addTables = objectTypesList.contains(RelationalObjectType.TYPE_TABLE);
        if (addTables) {
            objectTypeClause.append("'TABLE','SYSTEM TABLE'");
        }
        if (objectTypesList.contains(RelationalObjectType.TYPE_VIEW)) {
            if (addTables) {
                objectTypeClause.append(",");
            }
            objectTypeClause.append("'VIEW'");
        }
        String sql = "SELECT schema_name, table_name, CASE WHEN table_type = 'SYSTEM TABLE' THEN 'SYSTEM_TABLE' ELSE table_type END, remarks\nFROM v_catalog.all_tables WHERE " + (searchInComments ? "(" : "") + "TABLE_NAME";
        sql = String.valueOf(sql) + (params.isCaseSensitive() ? " LIKE ?" : " ILIKE ?");
        if (searchInComments) {
            sql = String.valueOf(sql) + " OR remarks" + (params.isCaseSensitive() ? " LIKE ?" : " ILIKE ?") + ")";
        }
        if (parentSchema != null) {
            sql = String.valueOf(sql) + " AND SCHEMA_NAME = ?";
        }
        sql = String.valueOf(sql) + " AND table_type IN (" + objectTypeClause.toString() + ")";
        sql = String.valueOf(sql) + "\nORDER BY SCHEMA_NAME, TABLE_NAME LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var12_13 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            dbStat.setString(1, params.getMask());
            if (searchInComments) {
                dbStat.setString(2, params.getMask());
            }
            if (parentSchema != null) {
                dbStat.setString(searchInComments ? 3 : 2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var15_18 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    GenericSchema schema;
                    String schemaName = dbResult.getString(1);
                    final String objectName = dbResult.getString(2);
                    final String tableType = dbResult.getString(3);
                    String description = searchInComments ? dbResult.getString(4) : "";
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    final VerticaObjectType objectType = VerticaObjectType.valueOf(tableType);
                    result.add((DBSObjectReference)new AbstractObjectReference<GenericSchema>(objectName, schema, description, ((Object)((Object)objectType)).getClass(), (DBSObjectType)objectType){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            DBSObject object = objectType.findObject(monitor, (GenericObjectContainer)schema, objectName);
                            if (object == null) {
                                throw new DBException(String.valueOf(tableType) + " '" + objectName + "' not found in schema '" + schema.getName() + "'");
                            }
                            return object;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findSequencesByMask(@NotNull JDBCSession session, @Nullable GenericSchema parentSchema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> result, boolean searchInComments) throws SQLException {
        String sql = "SELECT s.sequence_schema, s.sequence_name" + (searchInComments ? ", c.\"comment\"" : "") + " FROM v_catalog.sequences s\n" + (searchInComments ? "LEFT JOIN v_catalog.comments c ON s.sequence_id = c.object_id\n" : "") + "WHERE " + (searchInComments ? "(" : "") + " s.sequence_name";
        sql = String.valueOf(sql) + (params.isCaseSensitive() ? " LIKE ?" : " ILIKE ?");
        if (searchInComments) {
            sql = String.valueOf(sql) + " OR c.\"comment\"" + (params.isCaseSensitive() ? " LIKE ?" : " ILIKE ?") + ")";
        }
        if (parentSchema != null) {
            sql = String.valueOf(sql) + " AND s.sequence_schema = ?";
        }
        sql = String.valueOf(sql) + "\nORDER BY s.sequence_schema, s.sequence_name LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            dbStat.setString(1, params.getMask());
            if (searchInComments) {
                dbStat.setString(2, params.getMask());
            }
            if (parentSchema != null) {
                dbStat.setString(searchInComments ? 3 : 2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    GenericSchema schema;
                    String schemaName = dbResult.getString(1);
                    final String objectName = dbResult.getString(2);
                    String description = searchInComments ? dbResult.getString(3) : "";
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference<GenericSchema>(objectName, schema, description, VerticaSequence.class, (DBSObjectType)VerticaObjectType.SEQUENCE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericSequence object = ((GenericSchema)this.getContainer()).getSequence(monitor, objectName);
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)VerticaStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            return object;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findConstraintsByMask(@NotNull JDBCSession session, GenericSchema parentSchema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> result, boolean searchInComments) throws SQLException {
        String sql = "SELECT s.schema_name, al.table_name, tc.constraint_name, tc.constraint_type" + (searchInComments ? ",c.\"comment\"" : "") + " FROM v_catalog.table_constraints tc\n" + "LEFT JOIN v_catalog.all_tables al ON al.table_id = tc.table_id\n" + "LEFT JOIN v_catalog.schemata s ON tc.constraint_schema_id = s.schema_id\n" + (searchInComments ? "LEFT JOIN v_catalog.comments c ON tc.constraint_id = c.object_id " : "") + " WHERE " + (searchInComments ? "(" : "") + "tc.constraint_name";
        sql = String.valueOf(sql) + (params.isCaseSensitive() ? " LIKE ?" : " ILIKE ?");
        if (searchInComments) {
            sql = String.valueOf(sql) + " OR c.\"comment\"" + (params.isCaseSensitive() ? " LIKE ?" : " ILIKE ?") + ")";
        }
        if (parentSchema != null) {
            sql = String.valueOf(sql) + " AND s.schema_name = ?";
        }
        sql = String.valueOf(sql) + "\nORDER BY s.schema_name, tc.constraint_name LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            dbStat.setString(1, params.getMask());
            if (searchInComments) {
                dbStat.setString(2, params.getMask());
            }
            if (parentSchema != null) {
                dbStat.setString(searchInComments ? 3 : 2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    GenericSchema schema;
                    String schemaName = dbResult.getString(1);
                    final String tableName = dbResult.getString(2);
                    final String objectName = dbResult.getString(3);
                    String constraintType = dbResult.getString(4);
                    String description = searchInComments ? dbResult.getString(5) : "";
                    final boolean isFK = constraintType.equals("f");
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference<GenericSchema>(objectName, schema, description, isFK ? GenericTableForeignKey.class : VerticaConstraint.class, RelationalObjectType.TYPE_CONSTRAINT){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericTableBase tableBase = ((GenericSchema)this.getContainer()).getTable(monitor, tableName);
                            if (tableBase == null) {
                                throw new DBException("Can't find constraint table '" + tableName + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)VerticaStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            Object constraint = isFK ? tableBase.getAssociation(monitor, objectName) : tableBase.getConstraint(monitor, objectName);
                            if (constraint == null) {
                                throw new DBException("Can't find constraint '" + objectName + "' in '" + DBUtils.getFullyQualifiedName((DBPDataSource)VerticaStructureAssistant.this.dataSource, (String[])new String[]{((GenericSchema)this.getContainer()).getName(), tableBase.getName()}) + "'");
                            }
                            return constraint;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findProjectionsByMask(@NotNull JDBCSession session, GenericSchema parentSchema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> result, boolean searchInComments) throws SQLException {
        String sql = "SELECT p.projection_schema, p.projection_name" + (searchInComments ? ",c.\"comment\"" : "") + " FROM v_catalog.projections p\n" + (searchInComments ? "LEFT JOIN v_catalog.comments c ON p.projection_id = c.object_id\n" : "") + "WHERE " + (searchInComments ? "(" : "") + "p.projection_name";
        sql = String.valueOf(sql) + (params.isCaseSensitive() ? " LIKE ?" : " ILIKE ?");
        if (searchInComments) {
            sql = String.valueOf(sql) + " OR c.\"comment\"" + (params.isCaseSensitive() ? " LIKE ?" : " ILIKE ?") + ")";
        }
        if (parentSchema != null) {
            sql = String.valueOf(sql) + " AND p.projection_schema = ?";
        }
        sql = String.valueOf(sql) + "\nORDER BY p.projection_schema, p.projection_name LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            dbStat.setString(1, params.getMask());
            if (searchInComments) {
                dbStat.setString(2, params.getMask());
            }
            if (parentSchema != null) {
                dbStat.setString(searchInComments ? 3 : 2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    String schemaName = dbResult.getString(1);
                    final String objectName = dbResult.getString(2);
                    String description = searchInComments ? dbResult.getString(3) : "";
                    VerticaSchema schema = (VerticaSchema)(parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName));
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference<VerticaSchema>(objectName, schema, description, VerticaProjection.class, (DBSObjectType)VerticaObjectType.PROJECTION){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            VerticaProjection object = ((VerticaSchema)this.getContainer()).getProjection(monitor, objectName);
                            if (object == null) {
                                throw new DBException("Can't find object '" + objectName + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)VerticaStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            return object;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findNodesByMask(@NotNull JDBCSession session, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> result, boolean searchInComments) throws SQLException {
        String sql = "SELECT n.node_name" + (searchInComments ? ", c.\"comment\"" : "") + " FROM v_catalog.nodes n \n" + (searchInComments ? "LEFT JOIN v_catalog.comments c ON n.node_id = c.object_id\n" : "") + "WHERE n.node_name";
        sql = String.valueOf(sql) + (params.isCaseSensitive() ? " LIKE ?" : " ILIKE ?");
        if (searchInComments) {
            sql = String.valueOf(sql) + " OR c.\"comment\"" + (params.isCaseSensitive() ? " LIKE ?" : " ILIKE ?");
        }
        sql = String.valueOf(sql) + "\nORDER BY n.node_name LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            dbStat.setString(1, params.getMask());
            if (searchInComments) {
                dbStat.setString(2, params.getMask());
            }
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    final String objectName = dbResult.getString(1);
                    String description = searchInComments ? dbResult.getString(2) : "";
                    result.add((DBSObjectReference)new AbstractObjectReference<VerticaDataSource>(objectName, this.dataSource, description, VerticaNode.class, (DBSObjectType)VerticaObjectType.NODE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            VerticaNode object = ((VerticaDataSource)this.getContainer()).getClusterNode(monitor, objectName);
                            if (object == null) {
                                throw new DBException("Can't find object '" + objectName + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)VerticaStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            return object;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findTableColumnsByMask(JDBCSession session, GenericSchema parentSchema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> result) throws SQLException {
        String stmt = "SELECT table_schema, table_name, column_name FROM v_catalog.columns WHERE column_name";
        stmt = String.valueOf(stmt) + (params.isCaseSensitive() ? " LIKE ?" : " ILIKE ?");
        if (parentSchema != null) {
            stmt = String.valueOf(stmt) + " AND SCHEMA_NAME = ?";
        }
        stmt = String.valueOf(stmt) + " ORDER BY table_schema, table_name, column_name LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(stmt);){
            dbStat.setString(1, params.getMask());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    GenericSchema schema;
                    String schemaName = dbResult.getString(1);
                    final String tableName = dbResult.getString(2);
                    final String columnName = dbResult.getString(3);
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference<GenericObjectContainer>(columnName, (GenericObjectContainer)schema, null, GenericTableColumn.class, RelationalObjectType.TYPE_TABLE_COLUMN){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericTableBase object = ((GenericObjectContainer)this.getContainer()).getTable(monitor, tableName);
                            if (object == null) {
                                throw new DBException("Can't find column table '" + tableName + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)VerticaStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            GenericTableColumn column = object.getAttribute(monitor, columnName);
                            if (column == null) {
                                throw new DBException("Column '" + columnName + "' not found in table '" + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return column;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findViewColumnsByMask(JDBCSession session, GenericSchema parentSchema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> result) throws SQLException {
        String stmt = "SELECT table_schema, table_name, column_name from v_catalog.view_columns WHERE column_name";
        stmt = String.valueOf(stmt) + (params.isCaseSensitive() ? " LIKE ?" : " ILIKE ?");
        if (parentSchema != null) {
            stmt = String.valueOf(stmt) + " AND SCHEMA_NAME = ?";
        }
        stmt = String.valueOf(stmt) + " ORDER BY table_schema, table_name, column_name LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(stmt);){
            dbStat.setString(1, params.getMask());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    GenericSchema schema;
                    String schemaName = dbResult.getString(1);
                    final String tableName = dbResult.getString(2);
                    final String columnName = dbResult.getString(3);
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference<GenericObjectContainer>(columnName, (GenericObjectContainer)schema, null, GenericTableColumn.class, RelationalObjectType.TYPE_VIEW_COLUMN){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericTableBase object = ((GenericObjectContainer)this.getContainer()).getTable(monitor, tableName);
                            if (object == null) {
                                throw new DBException("Can't find column view '" + tableName + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)VerticaStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            GenericTableColumn column = object.getAttribute(monitor, columnName);
                            if (column == null) {
                                throw new DBException("Column '" + columnName + "' not found in table '" + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return column;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public boolean supportsSearchInCommentsFor(@NotNull DBSObjectType objectType) {
        return objectType != RelationalObjectType.TYPE_TABLE_COLUMN && objectType != RelationalObjectType.TYPE_VIEW_COLUMN;
    }
}

