/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.h2.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericPrimaryKeyManager;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.h2.model.H2Constraint;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.struct.AbstractTable;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class H2ConstraintManager
extends GenericPrimaryKeyManager {
    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        GenericUniqueKey key = (GenericUniqueKey)command.getObject();
        GenericStructContainer container = ((GenericTableBase)key.getParentObject()).getParentObject();
        if (key.getConstraintType() == DBSEntityConstraintType.CHECK && key instanceof H2Constraint && container != null) {
            H2Constraint constraint = (H2Constraint)key;
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create check constraint", "ALTER TABLE " + ((GenericTableBase)constraint.getParentObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ADD CONSTRAINT " + DBUtils.getFullyQualifiedName((DBPDataSource)constraint.getDataSource(), (String[])new String[]{container.getName(), constraint.getName()}) + " CHECK (" + constraint.getCheckConstraintDefinition() + ") NOCHECK"));
        } else {
            super.addObjectCreateActions(monitor, executionContext, actions, command, options);
        }
    }

    public StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, GenericTableBase owner, DBECommandAbstract<GenericUniqueKey> command, Map<String, Object> options) {
        GenericUniqueKey constraint = (GenericUniqueKey)command.getObject();
        if (!constraint.isPersisted() && constraint.getConstraintType() == DBSEntityConstraintType.CHECK) {
            StringBuilder decl = new StringBuilder(40);
            decl.append(this.getAddConstraintTypeClause((AbstractTableConstraint)constraint));
            this.appendConstraintDefinition(decl, command);
            if (!CommonUtils.isEmpty((CharSequence)decl)) {
                return decl;
            }
        }
        return super.getNestedDeclaration(monitor, (AbstractTable)owner, command, options);
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<GenericUniqueKey, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) throws DBException {
        GenericUniqueKey constraint = (GenericUniqueKey)command.getObject();
        GenericStructContainer container = ((GenericTableBase)constraint.getParentObject()).getParentObject();
        if (container != null && command.getProperties().containsKey("description")) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Alter constraint description", "COMMENT ON CONSTRAINT " + DBUtils.getFullyQualifiedName((DBPDataSource)constraint.getDataSource(), (String[])new String[]{container.getName(), constraint.getName()}) + " IS " + SQLUtils.quoteString((DBSObject)constraint, (String)CommonUtils.notEmpty((String)constraint.getDescription()))));
        }
    }

    protected void appendConstraintDefinition(StringBuilder decl, DBECommandAbstract<GenericUniqueKey> command) {
        if (((GenericUniqueKey)command.getObject()).getConstraintType() == DBSEntityConstraintType.CHECK) {
            decl.append("(").append(((H2Constraint)command.getObject()).getCheckConstraintDefinition()).append(")");
        } else {
            super.appendConstraintDefinition(decl, command);
        }
    }
}

