/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObjectPrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureKind;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRolePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class PostgreCommandGrantPrivilege
extends DBECommandAbstract<PostgrePrivilegeOwner> {
    private final boolean grant;
    private final PostgrePrivilege privilege;
    private final Set<PostgrePrivilegeType> privilegeTypes;
    private final DBSObject privilegeOwner;

    public PostgreCommandGrantPrivilege(@NotNull PostgrePrivilegeOwner user, boolean grant, @NotNull DBSObject privilegeOwner, @NotNull PostgrePrivilege privilege, @Nullable PostgrePrivilegeType[] privilegeTypes) {
        super((DBPObject)user, grant ? "Grant" : "Revoke");
        this.grant = grant;
        this.privilege = privilege;
        this.privilegeTypes = new HashSet<PostgrePrivilegeType>();
        this.privilegeOwner = privilegeOwner;
        if (privilegeTypes != null) {
            this.privilegeTypes.addAll(Arrays.asList(privilegeTypes));
        } else {
            PostgrePrivilegeType[] postgrePrivilegeTypeArray = ((PostgrePrivilegeOwner)this.getObject()).getDataSource().getSupportedPrivilegeTypes();
            int n = postgrePrivilegeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PostgrePrivilegeType type = postgrePrivilegeTypeArray[n2];
                if (type.supportsType(privilegeOwner.getClass())) {
                    this.privilegeTypes.add(type);
                }
                ++n2;
            }
        }
    }

    @NotNull
    public DBEPersistAction[] getPersistActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, Map<String, Object> options) {
        String objectType;
        String objectName;
        String roleName;
        if (this.privilegeTypes.isEmpty()) {
            return new DBEPersistAction[0];
        }
        boolean withGrantOption = false;
        StringJoiner privName = new StringJoiner(", ");
        if (this.hasAllPrivilegeTypes()) {
            privName.add(PostgrePrivilegeType.ALL.name());
        } else {
            for (PostgrePrivilegeType pn : this.privilegeTypes) {
                privName.add(pn.name());
                withGrantOption |= CommonUtils.isBitSet((int)this.privilege.getPermission(pn), (int)2);
            }
        }
        PostgrePrivilegeOwner object = (PostgrePrivilegeOwner)this.getObject();
        if (object instanceof PostgreRole) {
            roleName = DBUtils.getQuotedIdentifier((DBSObject)object);
            objectName = this.privilegeOwner instanceof PostgreProcedure ? ((PostgreProcedure)this.privilegeOwner).getFullQualifiedSignature() : ((PostgreRolePrivilege)this.privilege).getFullObjectName();
        } else {
            PostgreObjectPrivilege permission = (PostgreObjectPrivilege)this.privilege;
            if (permission.getGrantee() != null) {
                roleName = permission.getGrantee();
                if (!roleName.toLowerCase(Locale.ENGLISH).startsWith("group ")) {
                    roleName = DBUtils.getQuotedIdentifier((DBPDataSource)object.getDataSource(), (String)roleName);
                }
            } else {
                roleName = "";
            }
            objectName = PostgreUtils.getObjectUniqueName(object);
        }
        if (this.privilege instanceof PostgreRolePrivilege) {
            if (this.privilegeOwner instanceof PostgreProcedure && ((PostgreProcedure)this.privilegeOwner).getKind() == PostgreProcedureKind.p) {
                ((PostgreRolePrivilege)this.privilege).setKind(PostgrePrivilegeGrant.Kind.PROCEDURE);
            }
            objectType = ((PostgreRolePrivilege)this.privilege).getKind().name();
        } else {
            objectType = PostgreUtils.getObjectTypeName(object);
        }
        String grantedCols = "";
        String grantedTypedObject = "";
        if (object instanceof PostgreTableColumn) {
            grantedCols = "(" + DBUtils.getQuotedIdentifier((DBSObject)object) + ")";
            grantedTypedObject = ((PostgreTableBase)((PostgreTableColumn)object).getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL);
        } else {
            grantedTypedObject = String.valueOf(objectType) + " " + objectName;
        }
        String grantScript = String.valueOf(this.grant ? "GRANT " : "REVOKE ") + privName + grantedCols + " ON " + grantedTypedObject + (this.grant ? " TO " : " FROM ") + roleName;
        if (this.grant && withGrantOption) {
            grantScript = String.valueOf(grantScript) + " WITH GRANT OPTION";
        }
        return new DBEPersistAction[]{new SQLDatabasePersistAction(this.grant ? "Grant" : "Revoke", grantScript)};
    }

    @Nullable
    public DBECommand<?> merge(DBECommand<?> prevCommand, Map<Object, Object> userParams) {
        String grantCommandId = this.makeUniqueName("grant");
        String revokeCommandId = this.makeUniqueName("revoke");
        String mergedCommandId = String.valueOf(this.makeUniqueName("merged")) + "#" + ((Object)((Object)this)).hashCode();
        userParams.putIfAbsent(this.grant ? grantCommandId : revokeCommandId, (Object)this);
        PostgreCommandGrantPrivilege grantCommand = (PostgreCommandGrantPrivilege)((Object)userParams.get(grantCommandId));
        PostgreCommandGrantPrivilege revokeCommand = (PostgreCommandGrantPrivilege)((Object)userParams.get(revokeCommandId));
        if (!userParams.containsKey(mergedCommandId)) {
            userParams.put(mergedCommandId, true);
            this.mergePrivilegeTypes(grantCommand != null ? grantCommand.privilegeTypes : Collections.emptySet(), revokeCommand != null ? revokeCommand.privilegeTypes : Collections.emptySet(), new ArrayList<PostgrePrivilegeType>(this.privilegeTypes), this.grant);
        }
        return this.grant ? grantCommand : revokeCommand;
    }

    private void mergePrivilegeTypes(@NotNull Set<PostgrePrivilegeType> granted, @NotNull Set<PostgrePrivilegeType> revoked, @NotNull Collection<PostgrePrivilegeType> modified, boolean grant) {
        if (grant) {
            granted.removeAll(modified);
            modified.removeIf(revoked::remove);
            granted.addAll(modified);
        } else {
            revoked.removeAll(modified);
            modified.removeIf(granted::remove);
            revoked.addAll(modified);
        }
    }

    private boolean hasAllPrivilegeTypes() {
        PostgrePrivilegeType[] postgrePrivilegeTypeArray = ((PostgrePrivilegeOwner)this.getObject()).getDataSource().getSupportedPrivilegeTypes();
        int n = postgrePrivilegeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PostgrePrivilegeType type = postgrePrivilegeTypeArray[n2];
            if (type.supportsType(this.privilegeOwner.getClass()) && !this.privilegeTypes.contains((Object)type)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @NotNull
    private String makeUniqueName(@NotNull String name) {
        return String.valueOf(name) + "#" + this.privilege.hashCode() + "#" + this.privilegeOwner.hashCode();
    }
}

