/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePhysical;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;
import org.jkiss.utils.CommonUtils;

public class OracleTablePartition
extends OracleTablePhysical
implements DBSTablePartition,
DBPImageProvider {
    private static final Log log = Log.getLog(OracleTablePartition.class);
    private static final String CAT_PARTITIONING = "Partitioning";
    private OracleTablePhysical parent;
    private OracleTablePartition partitionParent;
    private int position;
    private String highValue;
    private boolean usable;
    private long sampleSize;
    private Timestamp lastAnalyzed;
    private List<OracleTablePartition> subPartitions;

    OracleTablePartition(@NotNull OracleTablePhysical parent, @NotNull String name, @NotNull ResultSet dbResult, @Nullable OracleTablePartition partitionParent) {
        super(parent.getSchema(), dbResult, name);
        this.parent = parent;
        this.partitionParent = partitionParent;
        this.highValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"HIGH_VALUE");
        this.position = partitionParent != null ? JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"SUBPARTITION_POSITION") : JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PARTITION_POSITION");
        this.usable = "USABLE".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS"));
        this.sampleSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"SAMPLE_SIZE");
        this.lastAnalyzed = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_ANALYZED");
    }

    @Property(viewable=true, order=10)
    public int getPosition() {
        return this.position;
    }

    @Property(viewable=true, order=11)
    public boolean isUsable() {
        return this.usable;
    }

    @Property(viewable=true, order=30)
    public String getHighValue() {
        return this.highValue;
    }

    @Property(viewable=true, order=41)
    public long getSampleSize() {
        return this.sampleSize;
    }

    @Property(viewable=true, order=42)
    public Timestamp getLastAnalyzed() {
        return this.lastAnalyzed;
    }

    @Association
    public List<OracleTablePartition> getSubPartitions(DBRProgressMonitor monitor) throws DBException {
        if (this.partitionParent != null) {
            return Collections.emptyList();
        }
        if (this.subPartitions == null) {
            this.readSubPartitions(monitor);
        }
        return this.subPartitions;
    }

    /*
     * Exception decompiling
     */
    private List<OracleTablePartition> readSubPartitions(@NotNull DBRProgressMonitor monitor) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public DBPImage getObjectImage() {
        return DBIcon.TREE_PARTITION;
    }

    @Override
    public OracleTableBase.TableAdditionalInfo getAdditionalInfo() {
        return new OracleTableBase.TableAdditionalInfo();
    }

    @Override
    protected String getTableTypeName() {
        return "TABLE PARTITION";
    }

    public boolean isView() {
        return false;
    }

    protected boolean needAliasInSelect(@Nullable DBDDataFilter dataFilter, @Nullable DBDPseudoAttribute rowIdAttribute, @NotNull DBPDataSource dataSource) {
        return false;
    }

    @NotNull
    protected String getTableName() {
        return this.parent.getFullyQualifiedName(DBPEvaluationContext.DML);
    }

    protected void appendExtraSelectParameters(@NotNull StringBuilder query) {
        query.append(" ").append(this.partitionParent != null ? "SUB" : "").append("PARTITION (").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append(")");
    }

    public static class PartitionInfoBase {
        private PartitionType partitionType;
        private PartitionType subpartitionType;
        private String partitionInterval;
        private long partitionCount;
        private Object partitionTablespace;

        @Property(category="Partitioning", order=120)
        public PartitionType getPartitionType() {
            return this.partitionType;
        }

        @Property(category="Partitioning", order=121)
        public PartitionType getSubpartitionType() {
            return this.subpartitionType;
        }

        @Property(category="Partitioning", order=122)
        public String getPartitionInterval() {
            return this.partitionInterval;
        }

        @Property(category="Partitioning", order=123)
        public long getPartitionCount() {
            return this.partitionCount;
        }

        @Property(category="Partitioning", order=124)
        public Object getPartitionTablespace() {
            return this.partitionTablespace;
        }

        public PartitionInfoBase(DBRProgressMonitor monitor, OracleDataSource dataSource, ResultSet dbResult) {
            this.partitionType = (PartitionType)CommonUtils.valueOf(PartitionType.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"PARTITIONING_TYPE"));
            this.subpartitionType = (PartitionType)CommonUtils.valueOf(PartitionType.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"SUBPARTITIONING_TYPE"));
            String partitionTablespaceName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"DEF_TABLESPACE_NAME");
            this.partitionInterval = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"INTERVAL");
            this.partitionCount = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"PARTITION_COUNT");
            if (dataSource.isAdmin() && CommonUtils.isNotEmpty((String)partitionTablespaceName)) {
                try {
                    this.partitionTablespace = dataSource.tablespaceCache.getObject(monitor, (DBSObject)dataSource, partitionTablespaceName);
                }
                catch (DBException e) {
                    log.debug((Object)("Can not find tablespace " + partitionTablespaceName), (Throwable)e);
                }
            }
        }
    }

    public static enum PartitionType {
        NONE,
        RANGE,
        HASH,
        SYSTEM,
        LIST;

    }
}

