/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model.session;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.internal.OracleMessages;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.session.OracleServerExecutePlan;
import org.jkiss.dbeaver.ext.oracle.model.session.OracleServerLongOp;
import org.jkiss.dbeaver.ext.oracle.model.session.OracleServerSession;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.admin.sessions.AbstractServerSessionDetails;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionDetails;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionDetailsProvider;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManagerSQL;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.utils.CommonUtils;

public class OracleServerSessionManager
implements DBAServerSessionManager<OracleServerSession>,
DBAServerSessionManagerSQL,
DBAServerSessionDetailsProvider {
    public static final String PROP_KILL_SESSION = "killSession";
    public static final String PROP_IMMEDIATE = "immediate";
    public static final String OPTION_SHOW_BACKGROUND = "showBackground";
    public static final String OPTION_SHOW_INACTIVE = "showInactive";
    private final OracleDataSource dataSource;

    public OracleServerSessionManager(OracleDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * Loose catch block
     */
    public Collection<OracleServerSession> getSessions(DBCSession session, Map<String, Object> options) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(this.generateSessionReadQuery(options));){
                ArrayList<OracleServerSession> arrayList;
                JDBCResultSet dbResult;
                Throwable throwable2;
                block22: {
                    throwable2 = null;
                    Object var7_11 = null;
                    dbResult = dbStat.executeQuery();
                    ArrayList<OracleServerSession> sessions = new ArrayList<OracleServerSession>();
                    while (dbResult.next()) {
                        sessions.add(new OracleServerSession((ResultSet)dbResult));
                    }
                    arrayList = sessions;
                    if (dbResult == null) break block22;
                    dbResult.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, session.getDataSource());
        }
    }

    public void alterSession(DBCSession session, OracleServerSession sessionType, Map<String, Object> options) throws DBException {
        boolean toKill = Boolean.TRUE.equals(options.get(PROP_KILL_SESSION));
        boolean immediate = Boolean.TRUE.equals(options.get(PROP_IMMEDIATE));
        try {
            StringBuilder sql = new StringBuilder("ALTER SYSTEM ");
            if (toKill) {
                sql.append("KILL SESSION ");
            } else {
                sql.append("DISCONNECT SESSION ");
            }
            sql.append("'").append(sessionType.getSid()).append(',').append(sessionType.getSerial());
            if (sessionType.getInstId() != 0L && sessionType.getInstId() != 1L) {
                sql.append(",@").append(sessionType.getInstId());
            }
            sql.append("'");
            if (immediate) {
                sql.append(" IMMEDIATE");
            } else if (!toKill) {
                sql.append(" POST_TRANSACTION");
            }
            Throwable throwable = null;
            Object var8_10 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(sql.toString());){
                dbStat.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, session.getDataSource());
        }
    }

    public List<DBAServerSessionDetails> getSessionDetails() {
        ArrayList<DBAServerSessionDetails> extDetails = new ArrayList<DBAServerSessionDetails>();
        extDetails.add((DBAServerSessionDetails)new AbstractServerSessionDetails(OracleMessages.oracle_server_session_manager_details_name, OracleMessages.oracle_server_session_manager_details_description, (DBPImage)DBIcon.TYPE_DATETIME){

            /*
             * Loose catch block
             */
            public List<OracleServerLongOp> getSessionDetails(DBCSession session, DBAServerSession serverSession) throws DBException {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement("SELECT * FROM GV$SESSION_LONGOPS WHERE INST_ID=? AND SID=? AND SERIAL#=?");){
                        ArrayList<OracleServerLongOp> arrayList;
                        JDBCResultSet dbResult;
                        Throwable throwable2;
                        block22: {
                            dbStat.setLong(1, ((OracleServerSession)serverSession).getInstId());
                            dbStat.setLong(2, ((OracleServerSession)serverSession).getSid());
                            dbStat.setLong(3, ((OracleServerSession)serverSession).getSerial());
                            throwable2 = null;
                            Object var7_11 = null;
                            dbResult = dbStat.executeQuery();
                            ArrayList<OracleServerLongOp> longOps = new ArrayList<OracleServerLongOp>();
                            while (dbResult.next()) {
                                longOps.add(new OracleServerLongOp((ResultSet)dbResult));
                            }
                            arrayList = longOps;
                            if (dbResult == null) break block22;
                            dbResult.close();
                        }
                        return arrayList;
                        {
                            catch (Throwable throwable3) {
                                try {
                                    if (dbResult != null) {
                                        dbResult.close();
                                    }
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable4;
                                    } else if (throwable2 != throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    throw throwable2;
                                }
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e, session.getDataSource());
                }
            }

            public Class<? extends DBPObject> getDetailsType() {
                return OracleServerLongOp.class;
            }
        });
        extDetails.add((DBAServerSessionDetails)new AbstractServerSessionDetails(OracleMessages.oracle_server_session_manager_display_exec_plan_name, OracleMessages.oracle_server_session_manager_display_exec_plan_description, (DBPImage)DBIcon.TYPE_TEXT){

            /*
             * Loose catch block
             */
            public List<OracleServerExecutePlan> getSessionDetails(DBCSession session, DBAServerSession serverSession) throws DBException {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement("SELECT PLAN_TABLE_OUTPUT FROM TABLE(dbms_xplan.display_cursor(sql_id => ?, cursor_child_no => ?))");){
                        ArrayList<OracleServerExecutePlan> arrayList;
                        JDBCResultSet dbResult;
                        Throwable throwable2;
                        block22: {
                            dbStat.setString(1, ((OracleServerSession)serverSession).getSqlId());
                            dbStat.setLong(2, ((OracleServerSession)serverSession).getSqlChildNumber());
                            throwable2 = null;
                            Object var7_11 = null;
                            dbResult = dbStat.executeQuery();
                            ArrayList<OracleServerExecutePlan> planItems = new ArrayList<OracleServerExecutePlan>();
                            while (dbResult.next()) {
                                planItems.add(new OracleServerExecutePlan((ResultSet)dbResult));
                            }
                            arrayList = planItems;
                            if (dbResult == null) break block22;
                            dbResult.close();
                        }
                        return arrayList;
                        {
                            catch (Throwable throwable3) {
                                try {
                                    if (dbResult != null) {
                                        dbResult.close();
                                    }
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable4;
                                    } else if (throwable2 != throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    throw throwable2;
                                }
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e, session.getDataSource());
                }
            }

            public Class<? extends DBPObject> getDetailsType() {
                return OracleServerExecutePlan.class;
            }
        });
        return extDetails;
    }

    public boolean canGenerateSessionReadQuery() {
        return true;
    }

    public String generateSessionReadQuery(Map<String, Object> options) {
        boolean atLeastV11 = this.dataSource.isAtLeastV11();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT s.*, ");
        if (atLeastV11) {
            sql.append("sq.SQL_FULLTEXT, ");
        } else {
            sql.append("sq.SQL_TEXT AS SQL_FULLTEXT, ");
        }
        sql.append("io.*\nFROM GV$SESSION s, gv$sql sq, gv$sess_io io\nWHERE s.sql_address = sq.address(+)\n AND s.sql_hash_value = sq.hash_value(+) AND s.sid = io.sid(+) AND s.inst_id = io.inst_id(+)");
        if (atLeastV11) {
            sql.append(" AND s.sql_child_number = sq.child_number (+)");
        }
        if (!CommonUtils.getOption(options, (String)OPTION_SHOW_BACKGROUND)) {
            sql.append(" AND s.TYPE = 'USER'");
        }
        if (!CommonUtils.getOption(options, (String)OPTION_SHOW_INACTIVE)) {
            sql.append(" AND s.STATUS <> 'INACTIVE'");
        }
        return sql.toString();
    }
}

