/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.colors;

import org.eclipse.jface.action.Action;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;

abstract class ColorAction
extends Action {
    private ResultSetViewer resultSetViewer;

    protected ColorAction(ResultSetViewer resultSetViewer, String name) {
        super(name);
        this.resultSetViewer = resultSetViewer;
    }

    @NotNull
    DBVEntity getColorsVirtualEntity() throws IllegalStateException {
        DBSDataContainer dataContainer = this.resultSetViewer.getDataContainer();
        if (dataContainer == null) {
            throw new IllegalStateException("No data container");
        }
        return DBVUtils.getVirtualEntity((DBSDataContainer)dataContainer, (boolean)true);
    }

    void updateColors(DBVEntity entity) {
        this.updateColors(entity, true);
    }

    void updateColors(DBVEntity entity, boolean refresh) {
        this.resultSetViewer.getModel().updateColorMapping(true);
        entity.persistConfiguration();
        if (refresh) {
            this.resultSetViewer.redrawData(false, false);
        }
    }
}

