/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentAbstract;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class JDBCContentChars
extends JDBCContentAbstract
implements DBDContentStorage,
DBDContentCached {
    private String originalData;
    protected String data;

    public JDBCContentChars(DBCExecutionContext executionContext, String data) {
        super(executionContext);
        this.data = this.originalData = data;
    }

    public JDBCContentChars(JDBCContentChars copyFrom) {
        super(copyFrom);
        this.originalData = copyFrom.originalData;
        this.data = copyFrom.data;
    }

    public InputStream getContentStream() throws IOException {
        if (this.data == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(this.data.getBytes(this.getCharset()));
    }

    public Reader getContentReader() throws IOException {
        if (this.data == null) {
            return new StringReader("");
        }
        return new StringReader(this.data);
    }

    public long getContentLength() {
        if (this.data == null) {
            return 0L;
        }
        return this.data.length();
    }

    @NotNull
    public String getContentType() {
        return "text/plain";
    }

    public DBDContentStorage getContents(DBRProgressMonitor monitor) throws DBCException {
        return this;
    }

    public boolean updateContents(DBRProgressMonitor monitor, DBDContentStorage storage) throws DBException {
        if (storage == null) {
            this.data = null;
        } else {
            try {
                Reader reader = storage.getContentReader();
                try {
                    StringWriter sw = new StringWriter((int)storage.getContentLength());
                    ContentUtils.copyStreams((Reader)reader, (long)storage.getContentLength(), (Writer)sw, (DBRProgressMonitor)monitor);
                    this.data = sw.toString();
                }
                finally {
                    ContentUtils.close((Closeable)reader);
                }
            }
            catch (IOException e) {
                throw new DBCException("IO error while reading content", (Throwable)e);
            }
        }
        this.modified = true;
        return false;
    }

    public void resetContents() {
        this.data = this.originalData;
        this.modified = false;
    }

    public String getCharset() {
        return DBValueFormatting.getDefaultBinaryFileEncoding((DBPDataSource)this.executionContext.getDataSource());
    }

    public JDBCContentChars cloneStorage(DBRProgressMonitor monitor) {
        return this.cloneValue(monitor);
    }

    @Override
    public void bindParameter(JDBCSession session, JDBCPreparedStatement preparedStatement, DBSTypedObject columnType, int paramIndex) throws DBCException {
        try {
            if (this.data != null) {
                preparedStatement.setString(paramIndex, this.data);
            } else {
                preparedStatement.setNull(paramIndex, columnType.getTypeID());
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
    }

    public Object getRawValue() {
        return this.data;
    }

    public boolean isNull() {
        return this.data == null;
    }

    public void release() {
        this.data = this.originalData;
    }

    public boolean equals(Object obj) {
        return obj instanceof JDBCContentChars && CommonUtils.equalObjects((Object)this.data, (Object)((JDBCContentChars)((Object)obj)).data);
    }

    public int hashCode() {
        return this.data == null ? 0 : this.data.hashCode();
    }

    public String getDisplayString(DBDDisplayFormat format) {
        return this.data;
    }

    public JDBCContentChars cloneValue(DBRProgressMonitor monitor) {
        return new JDBCContentChars(this);
    }

    public Object getCachedValue() {
        return this.data;
    }
}

