/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDFormatSettingsExt;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.meta.DBSerializable;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.tools.transfer.DTConstants;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferEventProcessor;
import org.jkiss.dbeaver.tools.transfer.internal.DTActivator;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferEventProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.serialize.DTObjectSerializer;
import org.jkiss.dbeaver.tools.transfer.serialize.SerializerContext;
import org.jkiss.dbeaver.tools.transfer.stream.IAppendableDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IDocumentDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StatOutputStream;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.stream.StreamMappingContainer;
import org.jkiss.dbeaver.tools.transfer.stream.StreamMappingType;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.Base64;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.jkiss.utils.io.ByteOrderMark;

@DBSerializable(value="streamTransferConsumer")
public class StreamTransferConsumer
implements IDataTransferConsumer<StreamConsumerSettings, IStreamDataExporter> {
    private static final Log log = Log.getLog(StreamTransferConsumer.class);
    private static final String LOB_DIRECTORY_NAME = "files";
    private static final String PROP_FORMAT = "format";
    public static final String NODE_ID = "streamTransferConsumer";
    public static final String VARIABLE_DATASOURCE = "datasource";
    public static final String VARIABLE_CATALOG = "catalog";
    public static final String VARIABLE_SCHEMA = "schema";
    public static final String VARIABLE_TABLE = "table";
    public static final String VARIABLE_TIMESTAMP = "timestamp";
    public static final String VARIABLE_INDEX = "index";
    public static final String VARIABLE_DATE = "date";
    public static final String VARIABLE_PROJECT = "project";
    public static final String VARIABLE_CONN_TYPE = "connectionType";
    public static final String VARIABLE_FILE = "file";
    public static final String VARIABLE_SCRIPT_FILE = "scriptFilename";
    public static final String VARIABLE_YEAR = "year";
    public static final String VARIABLE_MONTH = "month";
    public static final String VARIABLE_DAY = "day";
    public static final String VARIABLE_HOUR = "hour";
    public static final String VARIABLE_MINUTE = "minute";
    public static final String[][] VARIABLES = new String[][]{{"datasource", "source database datasource"}, {"catalog", "source database catalog"}, {"schema", "source database schema"}, {"table", "source database table"}, {"index", "index of current file (if split is used)"}, {"project", "source database project"}, {"connectionType", "source database connection type"}, {"file", "output file path"}, {"scriptFilename", "source script filename"}, {"timestamp", "current timestamp"}, {"date", "current date"}, {"year", "current year"}, {"month", "current month"}, {"day", "current day"}, {"hour", "current hour"}, {"minute", "current minute"}};
    public static final int OUT_FILE_BUFFER_SIZE = 100000;
    private IStreamDataExporter processor;
    private StreamConsumerSettings settings;
    private StreamConsumerSettings.ConsumerRuntimeParameters runtimeParameters;
    private DBSDataContainer dataContainer;
    private OutputStream outputStream;
    private ZipOutputStream zipStream;
    private PrintWriter writer;
    private int multiFileNumber;
    private long bytesWritten = 0L;
    private DBDAttributeBinding[] columnMetas;
    private DBDAttributeBinding[] columnBindings;
    private File lobDirectory;
    private long lobCount;
    private File outputFile;
    private StreamExportSite exportSite;
    private Map<String, Object> processorProperties;
    private StringWriter outputBuffer;
    private boolean initialized = false;
    private boolean firstRow = true;
    private IDataTransferConsumer.TransferParameters parameters;
    private final List<File> outputFiles = new ArrayList<File>();
    private StatOutputStream statStream;

    protected long getBytesWritten() {
        return this.statStream == null ? 0L : this.statStream.getBytesWritten();
    }

    public void fetchStart(DBCSession session, DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
        if (!this.initialized) {
            this.initExporter(session);
        }
        this.columnMetas = DBUtils.getAttributeBindings((DBCSession)session, (DBSDataContainer)this.dataContainer, (DBCResultSetMetaData)resultSet.getMeta());
        this.columnBindings = this.processor instanceof IDocumentDataExporter ? DBUtils.injectAndFilterAttributeBindings((DBPDataSource)session.getDataSource(), (DBSDataContainer)this.dataContainer, (DBDAttributeBinding[])this.columnMetas, (boolean)true) : DBUtils.makeLeafAttributeBindings((DBCSession)session, (DBSDataContainer)this.dataContainer, (DBCResultSet)resultSet);
        StreamMappingContainer mapping = this.settings.getDataMapping(this.dataContainer);
        if (mapping != null && mapping.isComplete()) {
            this.columnBindings = (DBDAttributeBinding[])Arrays.stream(this.columnBindings).filter(attr -> {
                StreamMappingAttribute attribute = mapping.getAttribute((DBSAttributeBase)attr);
                return attribute == null || attribute.getMappingType() == StreamMappingType.export;
            }).toArray(DBDAttributeBinding[]::new);
        }
        if (!this.initialized) {
            this.exportHeaderInFile(session);
        }
        this.initialized = true;
    }

    public void fetchRow(DBCSession session, DBCResultSet resultSet) throws DBCException {
        try {
            if (this.settings.isSplitOutFiles() && !this.parameters.isBinary && !this.firstRow) {
                this.writer.flush();
                if (this.bytesWritten >= this.settings.getMaxOutFileSize()) {
                    this.exportFooterInFile(session.getProgressMonitor());
                    this.createNewOutFile();
                    this.exportHeaderInFile(session);
                }
            }
            Object[] srcRow = StreamTransferConsumer.fetchRow(session, resultSet, this.columnMetas);
            Object[] targetRow = new Object[this.columnBindings.length];
            int i = 0;
            while (i < this.columnBindings.length) {
                DBDAttributeBinding column = this.columnBindings[i];
                Object value = DBUtils.getAttributeValue((DBDAttributeBinding)column, (DBDAttributeBinding[])this.columnMetas, (Object[])srcRow);
                if (value instanceof DBDContent && !ContentUtils.isTextContent((DBDContent)((DBDContent)value))) {
                    switch (this.settings.getLobExtractType()) {
                        case SKIP: {
                            value = null;
                            break;
                        }
                        case INLINE: {
                            break;
                        }
                        case FILES: {
                            if (this.settings.isOutputClipboard()) break;
                            value = this.saveContentToFile(session.getProgressMonitor(), (DBDContent)value);
                        }
                    }
                }
                targetRow[i] = value;
                ++i;
            }
            this.processor.exportRow(session, resultSet, targetRow);
            this.firstRow = false;
        }
        catch (IOException e) {
            throw new DBCException("IO error", (Throwable)e);
        }
        catch (Throwable e) {
            throw new DBCException("Error while exporting table row", e);
        }
    }

    private void exportHeaderInFile(@NotNull DBCSession session) throws DBCException {
        try {
            this.processor.exportHeader(session);
        }
        catch (DBException e) {
            log.warn((Object)"Error while exporting table header", (Throwable)e);
        }
        catch (IOException e) {
            throw new DBCException("IO error", (Throwable)e);
        }
    }

    private void exportFooterInFile(@NotNull DBRProgressMonitor monitor) {
        if (this.processor != null) {
            try {
                this.processor.exportFooter(monitor);
            }
            catch (Exception e) {
                log.warn((Object)"Error while exporting table footer", (Throwable)e);
            }
        }
    }

    public void fetchEnd(DBCSession session, DBCResultSet resultSet) throws DBCException {
    }

    public void close() {
        this.columnBindings = null;
    }

    private boolean resolveOverwriteBlobFileConflict(@NotNull String fileName) {
        StreamConsumerSettings.BlobFileConflictBehavior behavior = this.runtimeParameters.blobFileConflictBehavior;
        if (behavior == StreamConsumerSettings.BlobFileConflictBehavior.ASK) {
            List<String> forAllLabels = this.settings.isUseSingleFile() ? List.of(DTMessages.data_transfer_file_conflict_behavior_apply_to_all) : List.of(DTMessages.data_transfer_file_conflict_behavior_apply_to_all, DTMessages.data_transfer_file_conflict_behavior_apply_to_all_for_current_object);
            DBPPlatformUI.UserChoiceResponse response = DBWorkbench.getPlatformUI().showUserChoice(DTMessages.data_transfer_blob_file_conflict_title, NLS.bind((String)DTMessages.data_transfer_file_conflict_ask_message, (Object)fileName), List.of(StreamConsumerSettings.BlobFileConflictBehavior.PATCHNAME.title, StreamConsumerSettings.BlobFileConflictBehavior.OVERWRITE.title, DTMessages.data_transfer_file_conflict_cancel), forAllLabels, this.runtimeParameters.blobFileConflictPreviousChoice, 1);
            if (response.choiceIndex < 0) {
                throw new RuntimeException("Blob file name conflict behavior is not specified while " + fileName + " already exists");
            }
            if (response.choiceIndex > 1) {
                throw new RuntimeException("User cancel during existing file resolution for blob " + fileName);
            }
            behavior = (new StreamConsumerSettings.BlobFileConflictBehavior[]{StreamConsumerSettings.BlobFileConflictBehavior.PATCHNAME, StreamConsumerSettings.BlobFileConflictBehavior.OVERWRITE})[response.choiceIndex];
            this.runtimeParameters.blobFileConflictPreviousChoice = response.choiceIndex;
            if (response.forAllChoiceIndex != null) {
                this.runtimeParameters.blobFileConflictBehavior = behavior;
                boolean bl = this.runtimeParameters.dontDropBlobFileConflictBehavior = response.forAllChoiceIndex == 0;
            }
        }
        return behavior == StreamConsumerSettings.BlobFileConflictBehavior.OVERWRITE;
    }

    private File saveContentToFile(DBRProgressMonitor monitor, DBDContent content) throws IOException, DBCException {
        DBDContentStorage contents = content.getContents(monitor);
        if (DBUtils.isNullValue((Object)contents)) {
            return null;
        }
        if (this.lobDirectory == null) {
            this.lobDirectory = new File(this.getOutputFolder(), LOB_DIRECTORY_NAME);
            if (!this.lobDirectory.exists() && !this.lobDirectory.mkdir()) {
                throw new IOException("Can't create directory for CONTENT files: " + this.lobDirectory.getAbsolutePath());
            }
        }
        ++this.lobCount;
        Boolean extractImages = (Boolean)this.processorProperties.get("extractImages");
        String fileExt = extractImages != null && extractImages != false ? ".jpg" : ".data";
        File lobFile = this.makeLobFileName(null, fileExt);
        if (lobFile.isFile() && !this.resolveOverwriteBlobFileConflict(lobFile.getName())) {
            lobFile = this.makeLobFileName("-" + System.currentTimeMillis(), fileExt);
        }
        Throwable throwable = null;
        Object var8_9 = null;
        try (InputStream cs = contents.getContentStream();){
            ContentUtils.saveContentToFile((InputStream)cs, (File)lobFile, (DBRProgressMonitor)monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return lobFile;
    }

    private File makeLobFileName(String suffix, String fileExt) {
        String name = String.valueOf(this.outputFile.getName()) + "-" + this.lobCount;
        if (CommonUtils.isNotEmpty((String)suffix)) {
            name = String.valueOf(name) + suffix;
        }
        return new File(this.lobDirectory, String.valueOf(name) + fileExt);
    }

    private void initExporter(DBCSession session) throws DBCException {
        if (this.settings.getFormatterProfile() != null && session instanceof DBDFormatSettingsExt) {
            ((DBDFormatSettingsExt)session).setDataFormatterProfile(this.settings.getFormatterProfile());
        }
        this.exportSite = new StreamExportSite();
        boolean outputClipboard = this.settings.isOutputClipboard();
        if (this.parameters.isBinary || !outputClipboard) {
            this.outputFile = this.makeOutputFile();
            this.outputFiles.add(this.outputFile);
        } else {
            this.outputFile = null;
        }
        try {
            if (outputClipboard) {
                this.outputBuffer = new StringWriter(2048);
                this.writer = new PrintWriter((Writer)this.outputBuffer, true);
            } else {
                this.openOutputStreams();
            }
        }
        catch (IOException e) {
            this.closeExporter();
            throw new DBCException("Data transfer IO error", (Throwable)e);
        }
        try {
            this.processor.init(this.exportSite);
        }
        catch (DBException e) {
            throw new DBCException("Can't initialize data exporter", (Throwable)e);
        }
    }

    private void closeExporter() {
        if (this.exportSite != null) {
            try {
                this.exportSite.flush();
            }
            catch (IOException e) {
                log.debug((Object)e);
            }
        }
        if (this.processor != null) {
            try {
                this.processor.dispose();
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
            this.processor = null;
        }
        this.closeOutputStreams();
    }

    private StreamConsumerSettings.DataFileConflictBehavior prepareDataFileConflictBehavior(String fileName) {
        StreamConsumerSettings.DataFileConflictBehavior behavior = this.runtimeParameters.dataFileConflictBehavior;
        if (behavior == StreamConsumerSettings.DataFileConflictBehavior.ASK) {
            List<Object> forAllLabels = this.settings.isUseSingleFile() ? List.of() : List.of(DTMessages.data_transfer_file_conflict_behavior_apply_to_all);
            DBPPlatformUI.UserChoiceResponse response = DBWorkbench.getPlatformUI().showUserChoice(DTMessages.data_transfer_file_conflict_ask_title, NLS.bind((String)DTMessages.data_transfer_file_conflict_ask_message, (Object)fileName), Arrays.asList(this.processor instanceof IAppendableDataExporter ? StreamConsumerSettings.DataFileConflictBehavior.APPEND.title : null, StreamConsumerSettings.DataFileConflictBehavior.PATCHNAME.title, StreamConsumerSettings.DataFileConflictBehavior.OVERWRITE.title, DTMessages.data_transfer_file_conflict_cancel), forAllLabels, this.runtimeParameters.dataFileConflictPreviousChoice, 2);
            if (response.choiceIndex > 2) {
                throw new RuntimeException("User cancel during existing file resolution for data " + fileName);
            }
            if (response.choiceIndex < 0) {
                throw new RuntimeException("Data file name conflict behavior is not specified while " + fileName + " already exists");
            }
            behavior = (new StreamConsumerSettings.DataFileConflictBehavior[]{StreamConsumerSettings.DataFileConflictBehavior.APPEND, StreamConsumerSettings.DataFileConflictBehavior.PATCHNAME, StreamConsumerSettings.DataFileConflictBehavior.OVERWRITE})[response.choiceIndex];
            this.runtimeParameters.dataFileConflictPreviousChoice = response.choiceIndex;
            if (response.forAllChoiceIndex != null || this.settings.isUseSingleFile()) {
                this.runtimeParameters.dataFileConflictBehavior = behavior;
            }
        }
        if (this.settings.isUseSingleFile() && this.parameters.orderNumber > 0) {
            behavior = StreamConsumerSettings.DataFileConflictBehavior.APPEND;
        }
        if (behavior == StreamConsumerSettings.DataFileConflictBehavior.APPEND) {
            if (this.processor instanceof IAppendableDataExporter) {
                try {
                    ((IAppendableDataExporter)this.processor).importData(this.exportSite);
                }
                catch (DBException e) {
                    log.warn((Object)"Error importing existing data for appending, data loss might occur", (Throwable)e);
                }
                if (((IAppendableDataExporter)this.processor).shouldTruncateOutputFileBeforeExport()) {
                    behavior = StreamConsumerSettings.DataFileConflictBehavior.OVERWRITE;
                }
            } else {
                behavior = StreamConsumerSettings.DataFileConflictBehavior.PATCHNAME;
            }
        }
        return behavior;
    }

    private void openOutputStreams() throws IOException {
        boolean truncate;
        block12: {
            block11: {
                if (!this.outputFile.isFile()) break block11;
                StreamConsumerSettings.DataFileConflictBehavior behavior = this.prepareDataFileConflictBehavior(this.outputFile.getName());
                switch (behavior) {
                    case APPEND: {
                        truncate = false;
                        break block12;
                    }
                    case PATCHNAME: {
                        truncate = false;
                        this.outputFile = this.makeOutputFile("-" + System.currentTimeMillis());
                        break block12;
                    }
                    case OVERWRITE: {
                        truncate = true;
                        break block12;
                    }
                    default: {
                        throw new RuntimeException("Unexpected data file conflict behavior " + (Object)((Object)behavior));
                    }
                }
            }
            truncate = true;
        }
        this.outputStream = new BufferedOutputStream(new FileOutputStream(this.outputFile, !truncate), 100000);
        this.statStream = new StatOutputStream(this.outputStream);
        this.outputStream = this.statStream;
        if (this.settings.isCompressResults()) {
            this.zipStream = new ZipOutputStream(this.outputStream);
            this.zipStream.putNextEntry(new ZipEntry(this.getOutputFileName()));
            this.outputStream = this.zipStream;
        }
        if (this.settings.isSplitOutFiles()) {
            this.outputStream = new OutputStreamStatProxy(this.outputStream);
        }
        if (!this.parameters.isBinary && this.settings.isOutputEncodingBOM()) {
            try {
                ByteOrderMark bom = ByteOrderMark.fromCharset((String)this.settings.getOutputEncoding());
                this.outputStream.write(bom.getBytes());
                this.outputStream.flush();
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)"Error writing byte order mask", (Throwable)e);
            }
        }
        if (!this.parameters.isBinary) {
            this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, this.settings.getOutputEncoding()), true);
        }
    }

    private void closeOutputStreams() {
        if (this.writer != null) {
            this.writer.flush();
        }
        if (this.zipStream != null) {
            try {
                this.zipStream.closeEntry();
            }
            catch (IOException e) {
                log.debug((Object)e);
            }
            try {
                this.zipStream.finish();
            }
            catch (IOException e) {
                log.debug((Object)e);
            }
            this.zipStream = null;
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (IOException e) {
                log.debug((Object)e);
            }
            ContentUtils.close((Closeable)this.outputStream);
            this.outputStream = null;
        }
    }

    private void createNewOutFile() throws IOException {
        this.closeOutputStreams();
        this.bytesWritten = 0L;
        ++this.multiFileNumber;
        this.outputFile = this.makeOutputFile();
        this.outputFiles.add(this.outputFile);
        this.openOutputStreams();
    }

    @Override
    public void initTransfer(@NotNull DBSObject sourceObject, @NotNull StreamConsumerSettings settings, @NotNull IDataTransferConsumer.TransferParameters parameters, @NotNull IStreamDataExporter processor, @NotNull Map<String, Object> processorProperties) {
        this.dataContainer = (DBSDataContainer)sourceObject;
        this.parameters = parameters;
        this.processor = processor;
        this.settings = settings;
        this.processorProperties = processorProperties;
        if (this.runtimeParameters == null) {
            this.runtimeParameters = settings.prepareRuntimeParameters();
        } else {
            this.runtimeParameters.initForConsumer();
        }
    }

    @Override
    public void setRuntimeParameters(Object runtimeParameters) {
        if (!(runtimeParameters instanceof StreamConsumerSettings.ConsumerRuntimeParameters)) {
            throw new IllegalStateException("Unsupported stream transfer consumer runtime parameters " + runtimeParameters);
        }
        this.runtimeParameters = (StreamConsumerSettings.ConsumerRuntimeParameters)runtimeParameters;
    }

    @Override
    public void startTransfer(DBRProgressMonitor monitor) {
    }

    @Override
    public void finishTransfer(DBRProgressMonitor monitor, boolean last) {
        this.finishTransfer(monitor, null, last);
    }

    @Override
    public void finishTransfer(@NotNull DBRProgressMonitor monitor, @Nullable Exception exception, @Nullable DBTTask task, boolean last) {
        if (!last && exception == null) {
            this.exportFooterInFile(monitor);
            this.closeExporter();
            return;
        }
        if (!this.parameters.isBinary && this.settings.isOutputClipboard() && exception == null && this.outputBuffer != null) {
            String strContents = this.outputBuffer.toString();
            DBWorkbench.getPlatformUI().copyTextToClipboard(strContents, this.parameters.isHTML);
            this.outputBuffer = null;
        }
        DataTransferRegistry registry = DataTransferRegistry.getInstance();
        for (Map.Entry<String, Map<String, Object>> entry : this.settings.getEventProcessors().entrySet()) {
            DataTransferEventProcessorDescriptor descriptor = registry.getEventProcessorById(entry.getKey());
            if (descriptor == null) {
                log.debug((Object)("Can't find event processor '" + entry.getKey() + "'"));
                continue;
            }
            try {
                IDataTransferEventProcessor<StreamTransferConsumer> processor = descriptor.create();
                if (exception == null) {
                    processor.processEvent(monitor, IDataTransferEventProcessor.Event.FINISH, this, task, entry.getValue());
                    continue;
                }
                processor.processError(monitor, exception, this, task, entry.getValue());
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Transfer event processor", "Error executing data transfer event processor '" + entry.getKey() + "'", (Throwable)e);
                log.error((Object)("Error executing event processor '" + entry.getKey() + "'"), (Throwable)e);
            }
        }
    }

    @Override
    public Object getTargetObject() {
        return null;
    }

    @Override
    @Nullable
    public Object getTargetObjectContainer() {
        return null;
    }

    @Override
    public String getObjectName() {
        return this.settings.isOutputClipboard() ? "Clipboard" : this.makeOutputFile().getName();
    }

    @Override
    public DBPImage getObjectIcon() {
        return null;
    }

    @Override
    public String getObjectContainerName() {
        return this.settings.isOutputClipboard() ? "Clipboard" : this.makeOutputFile().getParentFile().getAbsolutePath();
    }

    @Override
    public DBPImage getObjectContainerIcon() {
        return this.settings.isOutputClipboard() ? DBIcon.TYPE_TEXT : DBIcon.TREE_FOLDER;
    }

    @Override
    public boolean isConfigurationComplete() {
        return true;
    }

    public boolean isBeforeFirstRow() {
        return this.firstRow;
    }

    @NotNull
    public String getOutputFolder() {
        return this.translatePattern(this.settings.getOutputFolder(), null);
    }

    @NotNull
    public List<File> getOutputFiles() {
        return this.outputFiles;
    }

    @NotNull
    public String getOutputFileName() {
        return this.getOutputFileName(null);
    }

    @NotNull
    private String getOutputFileName(@Nullable String suffix) {
        Object extension = this.processorProperties == null ? null : this.processorProperties.get("extension");
        String fileName = (String)CommonUtils.notNull((Object)this.runtimeParameters.outputFileNameToReuse, (Object)this.translatePattern(this.settings.getOutputFilePattern(), null).trim());
        if (CommonUtils.isNotEmpty((String)suffix)) {
            fileName = String.valueOf(fileName) + suffix;
        }
        if (this.settings.isUseSingleFile() && suffix != null) {
            this.runtimeParameters.outputFileNameToReuse = fileName;
        }
        if (this.multiFileNumber > 0) {
            fileName = String.valueOf(fileName) + "_" + (this.multiFileNumber + 1);
        }
        if (extension != null) {
            return String.valueOf(fileName) + "." + extension;
        }
        return fileName;
    }

    @NotNull
    public File makeOutputFile() {
        return this.makeOutputFile(null);
    }

    @NotNull
    private File makeOutputFile(@Nullable String suffix) {
        File file = this.makeOutputFile(suffix, this.getOutputFolder());
        if (!file.exists()) {
            try {
                File file2;
                block16: {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    FileOutputStream ignored = new FileOutputStream(file);
                    try {
                        file2 = file;
                        if (ignored == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                if (ignored != null) {
                                    ignored.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException iOException) {
                            File file3 = this.makeOutputFile(suffix, StreamTransferConsumer.getFallbackOutputFolder());
                            return file3;
                        }
                    }
                    ignored.close();
                }
                return file2;
            }
            finally {
                file.delete();
            }
        }
        return file;
    }

    @NotNull
    private File makeOutputFile(@Nullable String suffix, @NotNull String outputFolder) {
        File dir = new File(outputFolder);
        if (!dir.exists() && !dir.mkdirs()) {
            log.error((Object)("Can't create output directory '" + dir.getAbsolutePath() + "'"));
        }
        String fileName = this.getOutputFileName(suffix);
        if (this.settings.isCompressResults()) {
            fileName = String.valueOf(fileName) + ".zip";
        }
        return new File(dir, fileName);
    }

    public String translatePattern(String pattern, File targetFile) {
        Date ts = this.parameters.startTimestamp != null ? this.parameters.startTimestamp : new Date();
        return GeneralUtils.replaceVariables((String)pattern, name -> {
            SQLQueryContainer container;
            switch (name) {
                case "datasource": {
                    if (this.settings.isUseSingleFile()) {
                        return "";
                    }
                    return StreamTransferConsumer.stripObjectName(this.dataContainer.getDataSource().getContainer().getName());
                }
                case "catalog": {
                    if (this.settings.isUseSingleFile()) {
                        return "";
                    }
                    DBSCatalog catalog = (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)this.dataContainer);
                    return catalog == null ? "" : StreamTransferConsumer.stripObjectName(catalog.getName());
                }
                case "schema": {
                    if (this.settings.isUseSingleFile()) {
                        return "";
                    }
                    DBSSchema schema = (DBSSchema)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)this.dataContainer);
                    if (schema != null) {
                        return StreamTransferConsumer.stripObjectName(schema.getName());
                    }
                    DBSCatalog catalog = (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)this.dataContainer);
                    return catalog == null ? "" : StreamTransferConsumer.stripObjectName(catalog.getName());
                }
                case "table": {
                    String tableName;
                    if (this.settings.isUseSingleFile()) {
                        return "export";
                    }
                    if (this.dataContainer == null) {
                        return null;
                    }
                    if (this.dataContainer instanceof SQLQueryContainer) {
                        tableName = DTUtils.getTableNameFromQueryContainer(this.dataContainer.getDataSource(), (SQLQueryContainer)this.dataContainer);
                        if (CommonUtils.isEmpty((String)tableName)) {
                            tableName = DTUtils.getTargetContainersNameFromQuery((SQLQueryContainer)this.dataContainer);
                        }
                    } else {
                        tableName = DTUtils.getTableName(this.dataContainer.getDataSource(), (DBPNamedObject)this.dataContainer, true);
                    }
                    if (CommonUtils.isEmpty((String)tableName)) {
                        tableName = this.parameters.orderNumber > 0 ? "export_" + this.parameters.orderNumber : "export";
                    }
                    return StreamTransferConsumer.stripObjectName(tableName);
                }
                case "timestamp": {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat(this.settings.getOutputTimestampPattern());
                        return sdf.format(ts);
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                        return "BAD_TIMESTAMP";
                    }
                }
                case "date": {
                    return RuntimeUtils.getCurrentDate();
                }
                case "year": {
                    return new SimpleDateFormat("yyyy").format(ts);
                }
                case "month": {
                    return new SimpleDateFormat("MM").format(ts);
                }
                case "day": {
                    return new SimpleDateFormat("dd").format(ts);
                }
                case "hour": {
                    return new SimpleDateFormat("HH").format(ts);
                }
                case "minute": {
                    return new SimpleDateFormat("mm").format(ts);
                }
                case "index": {
                    return String.valueOf(this.parameters.orderNumber + 1);
                }
                case "project": {
                    if (this.dataContainer == null) {
                        return null;
                    }
                    DBPProject project = DBUtils.getObjectOwnerProject((DBSObject)this.dataContainer);
                    return project == null ? "" : project.getName();
                }
                case "file": {
                    return targetFile == null ? "" : targetFile.getAbsolutePath();
                }
                case "scriptFilename": {
                    File file2;
                    container = (SQLQueryContainer)DBUtils.getAdapter(SQLQueryContainer.class, (Object)this.dataContainer);
                    if (container == null || (file2 = container.getScriptContext().getSourceFile()) == null) break;
                    String filename = file2.getName();
                    if (filename.indexOf(46) >= 0) {
                        filename = filename.substring(0, filename.lastIndexOf(46));
                    }
                    return filename;
                }
                case "connectionType": {
                    if (this.dataContainer == null) {
                        return null;
                    }
                    return this.dataContainer.getDataSource().getContainer().getConnectionConfiguration().getConnectionType().getId();
                }
            }
            container = (SQLQueryContainer)DBUtils.getAdapter(SQLQueryContainer.class, (Object)this.dataContainer);
            if (container != null) {
                return CommonUtils.toString(container.getQueryParameters().get(name));
            }
            return null;
        });
    }

    private static String stripObjectName(String name) {
        StringBuilder result = new StringBuilder();
        boolean lastUnd = false;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                result.append(c);
                lastUnd = false;
            } else if (c == '_' || !lastUnd) {
                result.append('_');
                lastUnd = true;
            }
            if (result.length() >= 64) break;
            ++i;
        }
        return result.toString();
    }

    @Override
    public DBSObject getDatabaseObject() {
        return null;
    }

    @Override
    public DBPDataSourceContainer getDataSourceContainer() {
        return null;
    }

    @Override
    @Nullable
    public DBPProject getProject() {
        return null;
    }

    public static Object[] fetchRow(DBCSession session, DBCResultSet resultSet, DBDAttributeBinding[] attributes) throws DBCException {
        int columnCount = attributes.length;
        Object[] row = new Object[columnCount];
        int i = 0;
        while (i < columnCount) {
            DBDAttributeBinding attribute = attributes[i];
            DBCAttributeMetaData metaAttr = attribute.getMetaAttribute();
            if (metaAttr != null) {
                try {
                    row[i] = attribute.getValueHandler().fetchValueObject(session, resultSet, (DBSTypedObject)metaAttr, attribute.getOrdinalPosition());
                }
                catch (Exception e) {
                    log.debug((Object)("Error fetching '" + metaAttr.getName() + "' value: " + e.getMessage()));
                }
            }
            ++i;
        }
        return row;
    }

    @NotNull
    public StreamConsumerSettings getSettings() {
        return this.settings;
    }

    @NotNull
    private static String getFallbackOutputFolder() {
        DBPPreferenceStore prefs = DTActivator.getDefault().getPreferences();
        String value = prefs.getString("fallbackOutputDirectory");
        if (CommonUtils.isEmpty((String)value)) {
            return DTConstants.DEFAULT_FALLBACK_OUTPUT_DIRECTORY;
        }
        return value;
    }

    public static class ObjectSerializer
    implements DTObjectSerializer<DBTTask, StreamTransferConsumer> {
        @Override
        public void serializeObject(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask context, @NotNull StreamTransferConsumer object, @NotNull Map<String, Object> state) {
        }

        @Override
        public StreamTransferConsumer deserializeObject(@NotNull DBRRunnableContext runnableContext, @NotNull SerializerContext serializeContext, @NotNull DBTTask objectContext, @NotNull Map<String, Object> state) {
            return new StreamTransferConsumer();
        }
    }

    private class OutputStreamStatProxy
    extends OutputStream {
        private final OutputStream out;

        OutputStreamStatProxy(OutputStream outputStream) {
            this.out = outputStream;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++StreamTransferConsumer.this.bytesWritten;
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
            this.out.write(b);
            StreamTransferConsumer.this.bytesWritten += (long)b.length;
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            StreamTransferConsumer.this.bytesWritten += (long)len;
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    private class StreamExportSite
    implements IStreamDataExporterSite {
        private StreamExportSite() {
        }

        @Override
        public DBPNamedObject getSource() {
            return StreamTransferConsumer.this.dataContainer;
        }

        @Override
        public DBDDisplayFormat getExportFormat() {
            Object formatProp = StreamTransferConsumer.this.processorProperties.get(StreamTransferConsumer.PROP_FORMAT);
            if (formatProp != null) {
                return DBDDisplayFormat.valueOf((String)formatProp.toString().toUpperCase(Locale.ENGLISH));
            }
            return StreamTransferConsumer.this.settings.getValueFormat();
        }

        @Override
        public Map<String, Object> getProperties() {
            return StreamTransferConsumer.this.processorProperties;
        }

        @Override
        public DBDAttributeBinding[] getAttributes() {
            return StreamTransferConsumer.this.columnBindings;
        }

        @Override
        public OutputStream getOutputStream() {
            return StreamTransferConsumer.this.outputStream;
        }

        @Override
        @Nullable
        public File getOutputFile() {
            return StreamTransferConsumer.this.outputFile;
        }

        @Override
        public PrintWriter getWriter() {
            return StreamTransferConsumer.this.writer;
        }

        @Override
        public void flush() throws IOException {
            if (StreamTransferConsumer.this.writer != null) {
                StreamTransferConsumer.this.writer.flush();
            }
            if (StreamTransferConsumer.this.outputStream != null) {
                StreamTransferConsumer.this.outputStream.flush();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void writeBinaryData(@NotNull DBDContentStorage cs) throws IOException {
            if (StreamTransferConsumer.this.parameters.isBinary) {
                Throwable throwable = null;
                Object var3_6 = null;
                try (InputStream stream = cs.getContentStream();){
                    IOUtils.copyStream((InputStream)stream, (OutputStream)StreamTransferConsumer.this.exportSite.getOutputStream());
                    return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    } else {
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            Throwable throwable = null;
            Object var3_8 = null;
            try (InputStream stream = cs.getContentStream();){
                StreamTransferConsumer.this.exportSite.flush();
                DBPDataSource dataSource = StreamTransferConsumer.this.dataContainer.getDataSource();
                switch (StreamTransferConsumer.this.settings.getLobEncoding()) {
                    case BASE64: {
                        Base64.encode((InputStream)stream, (long)cs.getContentLength(), (Writer)StreamTransferConsumer.this.writer);
                        return;
                    }
                    case HEX: {
                        StreamTransferConsumer.this.writer.write("0x");
                        byte[] buffer = new byte[5000];
                        while (true) {
                            int count;
                            if ((count = stream.read(buffer)) <= 0) {
                                return;
                            }
                            GeneralUtils.writeBytesAsHex((Writer)StreamTransferConsumer.this.writer, (byte[])buffer, (int)0, (int)count);
                        }
                    }
                    case NATIVE: {
                        if (dataSource != null) {
                            ByteArrayOutputStream buffer = new ByteArrayOutputStream((int)cs.getContentLength());
                            IOUtils.copyStream((InputStream)stream, (OutputStream)buffer);
                            byte[] bytes = buffer.toByteArray();
                            String binaryString = dataSource.getSQLDialect().getNativeBinaryFormatter().toString(bytes, 0, bytes.length);
                            StreamTransferConsumer.this.writer.write(binaryString);
                            return;
                        }
                    }
                    default: {
                        Throwable throwable3 = null;
                        Object var7_19 = null;
                        try (InputStreamReader reader = new InputStreamReader(stream, cs.getCharset());){
                            IOUtils.copyText((Reader)reader, (Writer)StreamTransferConsumer.this.writer);
                            return;
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                                throw throwable3;
                            } else {
                                if (throwable3 == throwable4) throw throwable3;
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                } else {
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }

        @Override
        @NotNull
        public String getOutputEncoding() {
            return StreamTransferConsumer.this.settings == null ? StandardCharsets.UTF_8.displayName() : StreamTransferConsumer.this.settings.getOutputEncoding();
        }
    }
}

