/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.connection;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public interface DBPDriverLibrary {
    @NotNull
    public String getDisplayName();

    public String getId();

    @Nullable
    public String getVersion();

    @NotNull
    public DBIcon getIcon();

    @NotNull
    public FileType getType();

    @NotNull
    public String getPath();

    @Nullable
    public String getDescription();

    public boolean isOptional();

    public boolean isCustom();

    public boolean isDisabled();

    public void setDisabled(boolean var1);

    public boolean isDownloadable();

    @Nullable
    public String getExternalURL(DBRProgressMonitor var1);

    @Nullable
    public Path getLocalFile();

    public boolean matchesCurrentPlatform();

    @Nullable
    public Collection<? extends DBPDriverLibrary> getDependencies(@NotNull DBRProgressMonitor var1) throws IOException;

    public void downloadLibraryFile(@NotNull DBRProgressMonitor var1, boolean var2, String var3) throws IOException, InterruptedException;

    @NotNull
    public Collection<String> getAvailableVersions(DBRProgressMonitor var1) throws IOException;

    public String getPreferredVersion();

    public void setPreferredVersion(String var1);

    public void resetVersion();

    public boolean isSecureDownload(DBRProgressMonitor var1);

    public static enum FileType {
        jar,
        lib,
        executable,
        license;


        public static FileType getFileTypeByFileName(String fileName) {
            return fileName.endsWith(".jar") || fileName.endsWith(".zip") ? jar : lib;
        }
    }
}

