/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime.features;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.runtime.features.DBRFeatureRegistry;

public final class DBRFeature {
    static final DBRFeature ROOT = new DBRFeature("Root", "Root Feature");
    private final DBRFeature parentFeature;
    private String id;
    private final String name;
    private final String description;
    private final String helpURL;
    private final boolean isAbstract;
    private final String commandId;

    private DBRFeature(@NotNull String id, @NotNull String name) {
        this.parentFeature = null;
        this.id = id;
        this.name = name;
        this.description = null;
        this.helpURL = null;
        this.isAbstract = true;
        this.commandId = null;
    }

    private DBRFeature(@NotNull DBRFeature parentFeature, @NotNull String name, String description, String helpURL, boolean isAbstract, String commandId) {
        this.parentFeature = parentFeature;
        this.name = name;
        this.description = description;
        this.helpURL = helpURL;
        this.isAbstract = isAbstract;
        this.commandId = commandId;
    }

    private DBRFeature(@NotNull DBRFeature parentFeature, @NotNull String name) {
        this(parentFeature, name, null, null, false, null);
    }

    public static DBRFeature createCategory(@NotNull String name, String description) {
        return DBRFeature.createCategory(ROOT, name, description);
    }

    public static DBRFeature createCategory(@NotNull DBRFeature parentFeature, @NotNull String name, @Nullable String description) {
        return new DBRFeature(parentFeature, name, description, null, true, null);
    }

    public static DBRFeature createFeature(@NotNull DBRFeature parentFeature, @NotNull String name) {
        return new DBRFeature(parentFeature, name);
    }

    public static DBRFeature createCommandFeature(@NotNull DBRFeature parentFeature, @NotNull String commandId) {
        return new DBRFeature(parentFeature, commandId, null, null, false, commandId);
    }

    public DBRFeature getParentFeature() {
        return this.parentFeature;
    }

    public String getId() {
        return this.id == null ? this.name : this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public void use() {
        this.use(null);
    }

    public void use(Map<String, Object> parameters) {
        DBRFeatureRegistry.useFeature(this, parameters);
    }

    public String toString() {
        return String.valueOf(this.id) + " (" + this.name + ")";
    }
}

