/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;

public class DatabaseEditorAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{DBSObject.class, DBSDataContainer.class, DBSDataManipulator.class, DBPDataSourceContainer.class, DBSDataContainer.class, DBPDataSourceContainer.class};

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        DBSObject object;
        DBNDatabaseNode node;
        IEditorInput editorInput;
        if (adapterType == DBPDataSourceContainer.class) {
            if (adaptableObject instanceof DBPDataSourceContainerProvider) {
                return adapterType.cast(((DBPDataSourceContainerProvider)adaptableObject).getDataSourceContainer());
            }
            if (adaptableObject instanceof IEditorPart) {
                adaptableObject = ((IEditorPart)adaptableObject).getEditorInput();
            }
            if (adaptableObject instanceof DBPDataSourceContainer) {
                return adapterType.cast(adaptableObject);
            }
            if (adaptableObject instanceof DBPDataSourceContainerProvider) {
                return adapterType.cast(((DBPDataSourceContainerProvider)adaptableObject).getDataSourceContainer());
            }
            if (adaptableObject instanceof IEditorInput) {
                return adapterType.cast(EditorUtils.getInputDataSource((IEditorInput)adaptableObject));
            }
            return null;
        }
        if (DBPObject.class.isAssignableFrom(adapterType) && adaptableObject instanceof IEditorPart && (editorInput = ((IEditorPart)adaptableObject).getEditorInput()) instanceof IDatabaseEditorInput && (node = ((IDatabaseEditorInput)editorInput).getNavigatorNode()) != null && (object = ((DBSWrapper)node).getObject()) != null && adapterType.isAssignableFrom(object.getClass())) {
            return adapterType.cast(object);
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }
}

