/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.statistics;

import java.io.IOException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.preferences.BundlePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.statistics.FeatureStatisticsCollector;
import org.osgi.framework.BundleContext;

public class UIStatisticsActivator
extends AbstractUIPlugin {
    private static final Log log = Log.getLog(UIStatisticsActivator.class);
    public static final String PLUGIN_ID = "org.jkiss.dbeaver.ui.statistics";
    public static final String PREF_FEATURE_TRACKING_ENABLED = "feature.tracking.enabled";
    public static final String PREF_STATISTICS_PREVIEW_ENABLED = "feature.statistics.preview.enabled";
    public static final String PREF_SKIP_DATA_SHARE_CONFIRMATION = "feature.tracking.skipConfirmation";
    private static UIStatisticsActivator plugin;
    private DBPPreferenceStore preferences;
    private static FeatureStatisticsCollector tracker;

    public static boolean isTrackingEnabled() {
        return UIStatisticsActivator.getDefault().getPreferences().getBoolean(PREF_FEATURE_TRACKING_ENABLED);
    }

    public static void setTrackingEnabled(boolean enabled) {
        if (enabled == UIStatisticsActivator.isTrackingEnabled()) {
            return;
        }
        UIStatisticsActivator.setPreferenceValue(PREF_FEATURE_TRACKING_ENABLED, enabled);
        if (tracker != null) {
            if (enabled) {
                tracker.startMonitor();
            } else {
                tracker.stopMonitor();
            }
        }
    }

    public static boolean isDetailsPreviewEnabled() {
        return UIStatisticsActivator.getDefault().getPreferences().getBoolean(PREF_STATISTICS_PREVIEW_ENABLED);
    }

    public static void setDetailsPreviewEnabled(boolean enabled) {
        UIStatisticsActivator.setPreferenceValue(PREF_STATISTICS_PREVIEW_ENABLED, enabled);
    }

    public static boolean isSkipDataShareConfirmation() {
        return UIStatisticsActivator.getDefault().getPreferences().getBoolean(PREF_SKIP_DATA_SHARE_CONFIRMATION);
    }

    public static void setSkipDataShareConfirmation(boolean skip) {
        UIStatisticsActivator.setPreferenceValue(PREF_SKIP_DATA_SHARE_CONFIRMATION, skip);
    }

    private static void setPreferenceValue(String key, boolean value) {
        DBPPreferenceStore preferenceStore = UIStatisticsActivator.getDefault().getPreferences();
        preferenceStore.setValue(key, value);
        try {
            preferenceStore.save();
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.preferences = new BundlePreferenceStore(this.getBundle());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static UIStatisticsActivator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return UIStatisticsActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public DBPPreferenceStore getPreferences() {
        return this.preferences;
    }
}

