/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Map;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;

public class GaussSchreiberTransverseMercator
extends Projection {
    public static final Identifier GSTMERC = new Identifier("IGNF", "REUN47GAUSSL", "Gauss Schreiber Transverse Mercator (aka Gauss Laborde R\u00e9union", "GSTMERC");
    protected final double lon0 = this.getCentralMeridian();
    protected final double latc;
    protected final double c;
    protected final double n1;
    protected final double n2;
    protected final double xs;
    protected final double ys;

    public GaussSchreiberTransverseMercator(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(GSTMERC, ellipsoid, parameters);
        double lat0 = this.getLatitudeOfOrigin();
        double FE = this.getFalseEasting();
        double FN = this.getFalseNorthing();
        double k0 = this.getScaleFactor();
        double e2 = ellipsoid.getSquareEccentricity();
        this.n1 = Math.sqrt(1.0 + e2 / (1.0 - e2) * Math.pow(Math.cos(lat0), 4.0));
        this.latc = Math.asin(Math.sin(lat0) / this.n1);
        this.c = Ellipsoid.SPHERE.isometricLatitude(this.latc) - this.n1 * ellipsoid.isometricLatitude(lat0);
        this.n2 = k0 * ellipsoid.getSemiMajorAxis() * Math.sqrt(1.0 - e2) / (1.0 - e2 * Math.sin(lat0) * Math.sin(lat0));
        this.xs = FE;
        this.ys = FN - this.n2 * this.latc;
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.PSEUDOCYLINDRICAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.APHYLACTIC;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.TRANSVERSE;
    }

    @Override
    public double[] transform(double[] coord) {
        double Lambda = this.n1 * (coord[1] - this.lon0);
        double isoLats = this.c + this.n1 * this.ellipsoid.isometricLatitude(coord[0]);
        coord[0] = this.xs + this.n2 * Ellipsoid.SPHERE.isometricLatitude(Math.asin(Math.sin(Lambda) / Math.cosh(isoLats)));
        coord[1] = this.ys + this.n2 * Math.atan(Math.sinh(isoLats) / Math.cos(Lambda));
        return coord;
    }

    @Override
    public Projection inverse() {
        return new GaussSchreiberTransverseMercator(this.ellipsoid, this.parameters){

            @Override
            public double[] transform(double[] coord) {
                double Lambda = Math.atan(Math.sinh((coord[0] - this.xs) / this.n2) / Math.cos((coord[1] - this.ys) / this.n2));
                double isoLats = Ellipsoid.SPHERE.isometricLatitude(Math.asin(Math.sin((coord[1] - this.ys) / this.n2) / Math.cosh((coord[0] - this.xs) / this.n2)));
                coord[0] = this.ellipsoid.latitude((isoLats - this.c) / this.n1);
                coord[1] = this.lon0 + Lambda / this.n1;
                return coord;
            }

            @Override
            public Projection inverse() {
                return GaussSchreiberTransverseMercator.this;
            }

            @Override
            public boolean isDirect() {
                return false;
            }

            @Override
            public String toString() {
                return GaussSchreiberTransverseMercator.this.toString() + " inverse";
            }
        };
    }
}

