# Generated by Django 2.2.18 on 2021-03-24 21:48
from django.db import migrations, models
import logging

logger = logging.getLogger(__name__)


def move_fqdn_to_host(apps, schema_editor):
    Endpoint_model = apps.get_model('dojo', 'Endpoint')
    for endpoint in Endpoint_model.objects.filter(fqdn__isnull=False):
        logger.info('In Endpoint {} (id={}), host "{}" will be replaced by fqdn "{}" because fqdn field will be'
            ' removed.'.format(str(endpoint), endpoint.pk, endpoint.host, endpoint.fqdn))
        endpoint.host = endpoint.fqdn
        endpoint.save()


class Migration(migrations.Migration):
    dependencies = [
        ('dojo', '0103_report_notification'),
    ]

    operations = [
        migrations.RunPython(move_fqdn_to_host),
        migrations.AlterModelOptions(
            name='endpoint',
            options={'ordering': ['product', 'host', 'protocol', 'port', 'userinfo', 'path', 'query', 'fragment']},
        ),
        migrations.AddField(
            model_name='endpoint',
            name='userinfo',
            field=models.CharField(blank=True, help_text="User info as 'alice', 'bob', etc.", max_length=500,
                                   null=True),
        ),
        migrations.AlterField(
            model_name='endpoint',
            name='host',
            field=models.CharField(blank=True,
                                   help_text="The host name or IP address. It must not include the port number. "
                                             "For example '127.0.0.1', 'localhost', 'yourdomain.com'.",
                                   max_length=500, null=True),
        ),
        migrations.AlterField(
            model_name='endpoint',
            name='protocol',
            field=models.CharField(blank=True,
                                   help_text="The communication protocol/scheme such as 'http', 'ftp', 'dns', etc.",
                                   max_length=10, null=True),
        ),
        migrations.AlterField(
            model_name='endpoint',
            name='path',
            field=models.CharField(blank=True, help_text="The location of the resource, it must not start with a '/'. "
                                                         "For example endpoint/420/edit", max_length=500, null=True),
        ),
        migrations.RemoveField(
            model_name='endpoint',
            name='fqdn',
        ),
        migrations.RemoveField(
            model_name='system_settings',
            name='display_endpoint_uri',
        ),
    ]
