/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.List;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.examples.signature.CreateSignatureBase;
import org.apache.pdfbox.examples.signature.SigUtils;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.ExternalSigningSupport;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.util.Hex;
import org.apache.pdfbox.util.Matrix;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

public class CreateVisibleSignature2
extends CreateSignatureBase {
    private SignatureOptions signatureOptions;
    private boolean lateExternalSigning = false;
    private File imageFile;

    public CreateVisibleSignature2(KeyStore keyStore, char[] cArray) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, CertificateException {
        super(keyStore, cArray);
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(File file) {
        this.imageFile = file;
    }

    public boolean isLateExternalSigning() {
        return this.lateExternalSigning;
    }

    public void setLateExternalSigning(boolean bl) {
        this.lateExternalSigning = bl;
    }

    public void signPDF(File file, File file2, Rectangle2D rectangle2D, String string) throws IOException {
        this.signPDF(file, file2, rectangle2D, string, null);
    }

    public void signPDF(File file, File file2, Rectangle2D rectangle2D, String string, String string2) throws IOException {
        if (file == null || !file.exists()) {
            throw new IOException("Document for signing does not exist");
        }
        this.setTsaUrl(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        PDDocument pDDocument = PDDocument.load((File)file);
        int n = SigUtils.getMDPPermission(pDDocument);
        if (n == 1) {
            throw new IllegalStateException("No changes to the document are permitted due to DocMDP transform parameters dictionary");
        }
        PDSignature pDSignature = null;
        PDAcroForm pDAcroForm = pDDocument.getDocumentCatalog().getAcroForm();
        PDRectangle pDRectangle = null;
        if (pDAcroForm != null && (pDSignature = this.findExistingSignature(pDAcroForm, string2)) != null) {
            pDRectangle = ((PDAnnotationWidget)pDAcroForm.getField(string2).getWidgets().get(0)).getRectangle();
        }
        if (pDSignature == null) {
            pDSignature = new PDSignature();
        }
        if (pDRectangle == null) {
            pDRectangle = this.createSignatureRectangle(pDDocument, rectangle2D);
        }
        if (pDDocument.getVersion() >= 1.5f && n == 0) {
            SigUtils.setMDPPermission(pDDocument, pDSignature, 2);
        }
        if (pDAcroForm != null && pDAcroForm.getNeedAppearances()) {
            if (pDAcroForm.getFields().isEmpty()) {
                pDAcroForm.getCOSObject().removeItem(COSName.NEED_APPEARANCES);
            } else {
                System.out.println("/NeedAppearances is set, signature may be ignored by Adobe Reader");
            }
        }
        pDSignature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        pDSignature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
        pDSignature.setName("Name");
        pDSignature.setLocation("Location");
        pDSignature.setReason("Reason");
        pDSignature.setSignDate(Calendar.getInstance());
        CreateVisibleSignature2 createVisibleSignature2 = this.isExternalSigning() ? null : this;
        this.signatureOptions = new SignatureOptions();
        this.signatureOptions.setVisualSignature(this.createVisualSignatureTemplate(pDDocument, 0, pDRectangle, pDSignature));
        this.signatureOptions.setPage(0);
        pDDocument.addSignature(pDSignature, (SignatureInterface)createVisibleSignature2, this.signatureOptions);
        if (this.isExternalSigning()) {
            System.out.println("Signing externally " + file2.getName());
            ExternalSigningSupport externalSigningSupport = pDDocument.saveIncrementalForExternalSigning((OutputStream)fileOutputStream);
            byte[] byArray = this.sign(externalSigningSupport.getContent());
            if (this.isLateExternalSigning()) {
                externalSigningSupport.setSignature(new byte[0]);
                int n2 = pDSignature.getByteRange()[1] + 1;
                RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
                randomAccessFile.seek(n2);
                randomAccessFile.write(Hex.getBytes((byte[])byArray));
                randomAccessFile.close();
            } else {
                externalSigningSupport.setSignature(byArray);
            }
        } else {
            pDDocument.saveIncremental((OutputStream)fileOutputStream);
        }
        pDDocument.close();
        IOUtils.closeQuietly((Closeable)this.signatureOptions);
    }

    private PDRectangle createSignatureRectangle(PDDocument pDDocument, Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        PDPage pDPage = pDDocument.getPage(0);
        PDRectangle pDRectangle = pDPage.getCropBox();
        PDRectangle pDRectangle2 = new PDRectangle();
        switch (pDPage.getRotation()) {
            case 90: {
                pDRectangle2.setLowerLeftY(f);
                pDRectangle2.setUpperRightY(f + f3);
                pDRectangle2.setLowerLeftX(f2);
                pDRectangle2.setUpperRightX(f2 + f4);
                break;
            }
            case 180: {
                pDRectangle2.setUpperRightX(pDRectangle.getWidth() - f);
                pDRectangle2.setLowerLeftX(pDRectangle.getWidth() - f - f3);
                pDRectangle2.setLowerLeftY(f2);
                pDRectangle2.setUpperRightY(f2 + f4);
                break;
            }
            case 270: {
                pDRectangle2.setLowerLeftY(pDRectangle.getHeight() - f - f3);
                pDRectangle2.setUpperRightY(pDRectangle.getHeight() - f);
                pDRectangle2.setLowerLeftX(pDRectangle.getWidth() - f2 - f4);
                pDRectangle2.setUpperRightX(pDRectangle.getWidth() - f2);
                break;
            }
            default: {
                pDRectangle2.setLowerLeftX(f);
                pDRectangle2.setUpperRightX(f + f3);
                pDRectangle2.setLowerLeftY(pDRectangle.getHeight() - f2 - f4);
                pDRectangle2.setUpperRightY(pDRectangle.getHeight() - f2);
            }
        }
        return pDRectangle2;
    }

    private InputStream createVisualSignatureTemplate(PDDocument pDDocument, int n, PDRectangle pDRectangle, PDSignature pDSignature) throws IOException {
        PDDocument pDDocument2 = new PDDocument();
        PDPage pDPage = new PDPage(pDDocument.getPage(n).getMediaBox());
        pDDocument2.addPage(pDPage);
        PDAcroForm pDAcroForm = new PDAcroForm(pDDocument2);
        pDDocument2.getDocumentCatalog().setAcroForm(pDAcroForm);
        PDSignatureField pDSignatureField = new PDSignatureField(pDAcroForm);
        PDAnnotationWidget pDAnnotationWidget = (PDAnnotationWidget)pDSignatureField.getWidgets().get(0);
        List list = pDAcroForm.getFields();
        pDAcroForm.setSignaturesExist(true);
        pDAcroForm.setAppendOnly(true);
        pDAcroForm.getCOSObject().setDirect(true);
        list.add(pDSignatureField);
        pDAnnotationWidget.setRectangle(pDRectangle);
        PDStream pDStream = new PDStream(pDDocument2);
        PDFormXObject pDFormXObject = new PDFormXObject(pDStream);
        PDResources pDResources = new PDResources();
        pDFormXObject.setResources(pDResources);
        pDFormXObject.setFormType(1);
        PDRectangle pDRectangle2 = new PDRectangle(pDRectangle.getWidth(), pDRectangle.getHeight());
        float f = pDRectangle2.getHeight();
        Matrix matrix = null;
        switch (pDDocument.getPage(n).getRotation()) {
            case 90: {
                pDFormXObject.setMatrix(AffineTransform.getQuadrantRotateInstance(1));
                matrix = Matrix.getScaleInstance((float)(pDRectangle2.getWidth() / pDRectangle2.getHeight()), (float)(pDRectangle2.getHeight() / pDRectangle2.getWidth()));
                f = pDRectangle2.getWidth();
                break;
            }
            case 180: {
                pDFormXObject.setMatrix(AffineTransform.getQuadrantRotateInstance(2));
                break;
            }
            case 270: {
                pDFormXObject.setMatrix(AffineTransform.getQuadrantRotateInstance(3));
                matrix = Matrix.getScaleInstance((float)(pDRectangle2.getWidth() / pDRectangle2.getHeight()), (float)(pDRectangle2.getHeight() / pDRectangle2.getWidth()));
                f = pDRectangle2.getWidth();
                break;
            }
        }
        pDFormXObject.setBBox(pDRectangle2);
        PDType1Font pDType1Font = PDType1Font.HELVETICA_BOLD;
        PDAppearanceDictionary pDAppearanceDictionary = new PDAppearanceDictionary();
        pDAppearanceDictionary.getCOSObject().setDirect(true);
        PDAppearanceStream pDAppearanceStream = new PDAppearanceStream(pDFormXObject.getCOSObject());
        pDAppearanceDictionary.setNormalAppearance(pDAppearanceStream);
        pDAnnotationWidget.setAppearance(pDAppearanceDictionary);
        PDPageContentStream pDPageContentStream = new PDPageContentStream(pDDocument2, pDAppearanceStream);
        if (matrix != null) {
            pDPageContentStream.transform(matrix);
        }
        pDPageContentStream.setNonStrokingColor(Color.yellow);
        pDPageContentStream.addRect(-5000.0f, -5000.0f, 10000.0f, 10000.0f);
        pDPageContentStream.fill();
        pDPageContentStream.saveGraphicsState();
        pDPageContentStream.transform(Matrix.getScaleInstance((float)0.25f, (float)0.25f));
        PDImageXObject pDImageXObject = PDImageXObject.createFromFileByExtension((File)this.imageFile, (PDDocument)pDDocument2);
        pDPageContentStream.drawImage(pDImageXObject, 0.0f, 0.0f);
        pDPageContentStream.restoreGraphicsState();
        float f2 = 10.0f;
        float f3 = f2 * 1.5f;
        pDPageContentStream.beginText();
        pDPageContentStream.setFont((PDFont)pDType1Font, f2);
        pDPageContentStream.setNonStrokingColor(Color.black);
        pDPageContentStream.newLineAtOffset(f2, f - f3);
        pDPageContentStream.setLeading(f3);
        X509Certificate x509Certificate = (X509Certificate)this.getCertificateChain()[0];
        X500Name x500Name = new X500Name(x509Certificate.getSubjectX500Principal().getName());
        RDN rDN = x500Name.getRDNs(BCStyle.CN)[0];
        String string = IETFUtils.valueToString((ASN1Encodable)rDN.getFirst().getValue());
        String string2 = pDSignature.getSignDate().getTime().toString();
        String string3 = pDSignature.getReason();
        pDPageContentStream.showText("Signer: " + string);
        pDPageContentStream.newLine();
        pDPageContentStream.showText(string2);
        pDPageContentStream.newLine();
        pDPageContentStream.showText("Reason: " + string3);
        pDPageContentStream.endText();
        pDPageContentStream.close();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        pDDocument2.save((OutputStream)byteArrayOutputStream);
        pDDocument2.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private PDSignature findExistingSignature(PDAcroForm pDAcroForm, String string) {
        PDSignatureField pDSignatureField;
        PDSignature pDSignature = null;
        if (pDAcroForm != null && (pDSignatureField = (PDSignatureField)pDAcroForm.getField(string)) != null) {
            pDSignature = pDSignatureField.getSignature();
            if (pDSignature == null) {
                pDSignature = new PDSignature();
                pDSignatureField.getCOSObject().setItem(COSName.V, (COSObjectable)pDSignature);
            } else {
                throw new IllegalStateException("The signature field " + string + " is already signed.");
            }
        }
        return pDSignature;
    }

    public static void main(String[] stringArray) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (stringArray.length < 4) {
            CreateVisibleSignature2.usage();
            System.exit(1);
        }
        String string = null;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-tsa")) {
                if (++i >= stringArray.length) {
                    CreateVisibleSignature2.usage();
                    System.exit(1);
                }
                string = stringArray[i];
            }
            if (!stringArray[i].equals("-e")) continue;
            bl = true;
        }
        File file = new File(stringArray[0]);
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        char[] cArray = stringArray[1].toCharArray();
        keyStore.load(new FileInputStream(file), cArray);
        File file2 = new File(stringArray[2]);
        CreateVisibleSignature2 createVisibleSignature2 = new CreateVisibleSignature2(keyStore, (char[])cArray.clone());
        createVisibleSignature2.setImageFile(new File(stringArray[3]));
        String string2 = file2.getName();
        String string3 = string2.substring(0, string2.lastIndexOf(46));
        File file3 = new File(file2.getParent(), string3 + "_signed.pdf");
        createVisibleSignature2.setExternalSigning(bl);
        Rectangle2D.Float float_ = new Rectangle2D.Float(100.0f, 200.0f, 150.0f, 50.0f);
        createVisibleSignature2.signPDF(file2, file3, float_, string, "Signature1");
    }

    private static void usage() {
        System.err.println("Usage: java " + CreateVisibleSignature2.class.getName() + " <pkcs12-keystore-file> <pin> <input-pdf> <sign-image>\noptions:\n  -tsa <url>    sign timestamp using the given TSA server\n  -e            sign using external signature creation scenario");
    }
}

