/*
 * Decompiled with CFR 0.152.
 */
package xades4j.production;

import com.google.inject.Inject;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import xades4j.XAdES4jException;
import xades4j.production.BasicSignatureOptions;
import xades4j.production.PropertiesDataObjectsGenerator;
import xades4j.production.SignedDataObjectsProcessor;
import xades4j.production.SignerT;
import xades4j.properties.SignedSignatureProperty;
import xades4j.properties.UnsignedSignatureProperty;
import xades4j.providers.AlgorithmsProviderEx;
import xades4j.providers.DataObjectPropertiesProvider;
import xades4j.providers.KeyingDataProvider;
import xades4j.providers.SignaturePropertiesProvider;
import xades4j.providers.ValidationData;
import xades4j.providers.ValidationDataException;
import xades4j.providers.ValidationDataProvider;
import xades4j.providers.X500NameStyleProvider;
import xades4j.utils.PropertiesUtils;
import xades4j.xml.marshalling.SignedPropertiesMarshaller;
import xades4j.xml.marshalling.UnsignedPropertiesMarshaller;
import xades4j.xml.marshalling.algorithms.AlgorithmsParametersMarshallingProvider;

class SignerC
extends SignerT {
    private final ValidationDataProvider validationDataProvider;

    @Inject
    protected SignerC(KeyingDataProvider keyingProvider, AlgorithmsProviderEx algorithmsProvider, BasicSignatureOptions basicSignatureOptions, SignedDataObjectsProcessor dataObjectDescsProcessor, SignaturePropertiesProvider signaturePropsProvider, ValidationDataProvider validationDataProvider, DataObjectPropertiesProvider dataObjPropsProvider, PropertiesDataObjectsGenerator propsDataObjectsGenerator, SignedPropertiesMarshaller signedPropsMarshaller, UnsignedPropertiesMarshaller unsignedPropsMarshaller, AlgorithmsParametersMarshallingProvider algorithmsParametersMarshaller, X500NameStyleProvider x500NameStyleProvider) {
        super(keyingProvider, algorithmsProvider, basicSignatureOptions, dataObjectDescsProcessor, signaturePropsProvider, dataObjPropsProvider, propsDataObjectsGenerator, signedPropsMarshaller, unsignedPropsMarshaller, algorithmsParametersMarshaller, x500NameStyleProvider);
        if (null == validationDataProvider) {
            throw new NullPointerException("ValidationDataProvider is null");
        }
        this.validationDataProvider = validationDataProvider;
    }

    @Override
    protected void getFormatSpecificSignatureProperties(Collection<SignedSignatureProperty> formatSpecificSignedSigProps, Collection<UnsignedSignatureProperty> formatSpecificUnsignedSigProps, List<X509Certificate> signingCertificateChain) throws XAdES4jException {
        super.getFormatSpecificSignatureProperties(formatSpecificSignedSigProps, formatSpecificUnsignedSigProps, signingCertificateChain);
        ValidationData vData = this.validationDataProvider.getValidationData(signingCertificateChain);
        if (null == vData) {
            throw new ValidationDataException("Validation data not provided");
        }
        PropertiesUtils.addXadesCProperties(formatSpecificUnsignedSigProps, vData);
    }
}

