/*
 * Decompiled with CFR 0.152.
 */
package xades4j.properties;

import java.util.Collection;
import xades4j.properties.DataObjectProperty;
import xades4j.properties.IdentifierType;
import xades4j.properties.ObjectIdentifier;
import xades4j.properties.SignedDataObjectProperty;
import xades4j.utils.CollectionUtils;

public class DataObjectFormatProperty
extends SignedDataObjectProperty {
    public static final String PROP_NAME = "DataObjectFormat";
    private final String mimeType;
    private final String encoding;
    private String description;
    private ObjectIdentifier identifier;
    private Collection<String> documentationUris;

    public DataObjectFormatProperty(String mimeType) {
        this(mimeType, null);
    }

    public DataObjectFormatProperty(String mimeType, String encoding) {
        super(DataObjectProperty.TargetMultiplicity.ONE);
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    public DataObjectFormatProperty() {
        this(null, null);
    }

    public DataObjectFormatProperty withIdentifier(ObjectIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public DataObjectFormatProperty withIdentifier(String identifier, IdentifierType identifierType) {
        return this.withIdentifier(new ObjectIdentifier(identifier, identifierType));
    }

    public DataObjectFormatProperty withIdentifier(String identifier) {
        return this.withIdentifier(new ObjectIdentifier(identifier));
    }

    public DataObjectFormatProperty withDescription(String description) {
        this.description = description;
        return this;
    }

    public DataObjectFormatProperty withDocumentationUri(String documentationUri) {
        if (null != documentationUri) {
            this.getOrCreateDocumentationUrisList().add(documentationUri);
        }
        return this;
    }

    public DataObjectFormatProperty withDocumentationUris(Collection<String> documentationUris) {
        if (null == documentationUris) {
            throw new NullPointerException("Uri list is null");
        }
        if (!documentationUris.isEmpty()) {
            this.getOrCreateDocumentationUrisList().addAll(documentationUris);
        }
        return this;
    }

    private Collection<String> getOrCreateDocumentationUrisList() {
        this.documentationUris = CollectionUtils.newIfNull(this.documentationUris, 2);
        return this.documentationUris;
    }

    public Collection<String> getDocumentationUris() {
        return CollectionUtils.emptyIfNull(this.documentationUris);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getDescription() {
        return this.description;
    }

    public ObjectIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getName() {
        return PROP_NAME;
    }
}

