/*
 * Decompiled with CFR 0.152.
 */
package xades4j.properties.data;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import xades4j.properties.data.AllDataObjsTimeStampData;
import xades4j.properties.data.ArchiveTimeStampData;
import xades4j.properties.data.BaseCertRefsDataStructureVerifier;
import xades4j.properties.data.BaseEncapsulatedPKIDataStructureVerifier;
import xades4j.properties.data.BaseXAdESTimeStampDataStructureVerifier;
import xades4j.properties.data.CertificateValuesData;
import xades4j.properties.data.CommitmentTypeData;
import xades4j.properties.data.CommitmentTypeDataStructureVerifier;
import xades4j.properties.data.CompleteCertificateRefsData;
import xades4j.properties.data.CompleteRevocationRefsData;
import xades4j.properties.data.CompleteRevocationRefsDataStructureVerifier;
import xades4j.properties.data.CustomPropertiesDataObjsStructureVerifier;
import xades4j.properties.data.DataObjectFormatData;
import xades4j.properties.data.DataObjectFormatDataStructureVerifier;
import xades4j.properties.data.GenericDOMData;
import xades4j.properties.data.GenericDOMDataStructureVerifier;
import xades4j.properties.data.IndividualDataObjsTimeStampData;
import xades4j.properties.data.IndividualDataObjsTimeStampDataStructureVerifier;
import xades4j.properties.data.PropDataStructVerifier;
import xades4j.properties.data.PropertyDataObject;
import xades4j.properties.data.PropertyDataObjectStructureVerifier;
import xades4j.properties.data.PropertyDataStructureException;
import xades4j.properties.data.PropertyDataStructureVerifierNotAvailableException;
import xades4j.properties.data.RevocationValuesData;
import xades4j.properties.data.SigAndDataObjsPropertiesData;
import xades4j.properties.data.SigAndRefsTimeStampData;
import xades4j.properties.data.SignaturePolicyData;
import xades4j.properties.data.SignaturePolicyDataStructureVerifier;
import xades4j.properties.data.SignatureProdPlaceData;
import xades4j.properties.data.SignatureProdPlaceDataStructureVerifier;
import xades4j.properties.data.SignatureTimeStampData;
import xades4j.properties.data.SignerRoleData;
import xades4j.properties.data.SignerRoleDataStructureVerifier;
import xades4j.properties.data.SigningCertificateData;
import xades4j.properties.data.SigningTimeData;
import xades4j.properties.data.SigningTimeDataStructureVerifier;
import xades4j.utils.DataGetterImpl;

public class PropertiesDataObjectsStructureVerifier {
    private static final Map<Class<? extends PropertyDataObject>, PropertyDataObjectStructureVerifier> structureVerifiers = new HashMap<Class<? extends PropertyDataObject>, PropertyDataObjectStructureVerifier>(10);
    private final Set<CustomPropertiesDataObjsStructureVerifier> customGlobalVerifiers;

    @Inject
    public PropertiesDataObjectsStructureVerifier(Set<CustomPropertiesDataObjsStructureVerifier> customVerifiers) {
        this.customGlobalVerifiers = customVerifiers;
    }

    public void verifiyPropertiesDataStructure(SigAndDataObjsPropertiesData propsData) throws PropertyDataStructureException {
        this.verifiyPropertiesDataStructure(propsData.getSigProps());
        this.verifiyPropertiesDataStructure(propsData.getDataObjProps());
    }

    public void verifiyPropertiesDataStructure(Collection<PropertyDataObject> propsData) throws PropertyDataStructureException {
        for (PropertyDataObject propData : propsData) {
            PropertiesDataObjectsStructureVerifier.getVerifier(propData).verifyStructure(propData);
        }
        if (this.customGlobalVerifiers.isEmpty()) {
            return;
        }
        DataGetterImpl<PropertyDataObject> dataGetter = new DataGetterImpl<PropertyDataObject>(propsData);
        for (CustomPropertiesDataObjsStructureVerifier customVer : this.customGlobalVerifiers) {
            customVer.verifiy(dataGetter);
        }
    }

    private static PropertyDataObjectStructureVerifier getVerifier(PropertyDataObject propData) throws PropertyDataStructureException {
        PropertyDataObjectStructureVerifier v = structureVerifiers.get(propData.getClass());
        if (v != null) {
            return v;
        }
        PropDataStructVerifier verifierAnnot = propData.getClass().getAnnotation(PropDataStructVerifier.class);
        if (null == verifierAnnot || null == verifierAnnot.value()) {
            throw new PropertyDataStructureVerifierNotAvailableException(propData.getClass().getSimpleName());
        }
        try {
            v = verifierAnnot.value().newInstance();
            structureVerifiers.put(propData.getClass(), v);
            return v;
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        throw new PropertyDataStructureException("cannot create data structure verifier", propData.getClass().getSimpleName());
    }

    static {
        structureVerifiers.put(CommitmentTypeData.class, new CommitmentTypeDataStructureVerifier());
        structureVerifiers.put(DataObjectFormatData.class, new DataObjectFormatDataStructureVerifier());
        structureVerifiers.put(IndividualDataObjsTimeStampData.class, new IndividualDataObjsTimeStampDataStructureVerifier());
        structureVerifiers.put(AllDataObjsTimeStampData.class, new BaseXAdESTimeStampDataStructureVerifier("AllDataObjectsTimeStamp"));
        structureVerifiers.put(SignatureProdPlaceData.class, new SignatureProdPlaceDataStructureVerifier());
        structureVerifiers.put(SigningCertificateData.class, new BaseCertRefsDataStructureVerifier("SigningCertificate"));
        structureVerifiers.put(SigningTimeData.class, new SigningTimeDataStructureVerifier());
        structureVerifiers.put(SignerRoleData.class, new SignerRoleDataStructureVerifier());
        structureVerifiers.put(SignaturePolicyData.class, new SignaturePolicyDataStructureVerifier());
        structureVerifiers.put(SignatureTimeStampData.class, new BaseXAdESTimeStampDataStructureVerifier("SignatureTimeStamp"));
        structureVerifiers.put(CompleteCertificateRefsData.class, new BaseCertRefsDataStructureVerifier("CompleteCertificateRefs"));
        structureVerifiers.put(CompleteRevocationRefsData.class, new CompleteRevocationRefsDataStructureVerifier());
        structureVerifiers.put(SigAndRefsTimeStampData.class, new BaseXAdESTimeStampDataStructureVerifier("SigAndRefsTimeStamp"));
        structureVerifiers.put(CertificateValuesData.class, new BaseEncapsulatedPKIDataStructureVerifier("CertificateValues"));
        structureVerifiers.put(RevocationValuesData.class, new BaseEncapsulatedPKIDataStructureVerifier("RevocationValues"));
        structureVerifiers.put(ArchiveTimeStampData.class, new BaseXAdESTimeStampDataStructureVerifier("xadesv141:ArchiveTimeStamp"));
        structureVerifiers.put(GenericDOMData.class, new GenericDOMDataStructureVerifier());
    }
}

