/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ValidationData {
    private final List<X509Certificate> certs;
    private final Collection<X509CRL> crls;

    public ValidationData(List<X509Certificate> certs, Collection<X509CRL> crls) {
        if (null == certs) {
            throw new NullPointerException("Null cert path");
        }
        if (certs.isEmpty()) {
            throw new IllegalArgumentException("Empty cert path");
        }
        this.certs = Collections.unmodifiableList(certs);
        this.crls = null == crls ? Collections.emptyList() : Collections.unmodifiableCollection(crls);
    }

    public ValidationData(List<X509Certificate> certs) {
        this(certs, null);
    }

    public List<X509Certificate> getCerts() {
        return this.certs;
    }

    public Collection<X509CRL> getCrls() {
        return this.crls;
    }
}

