/*
 * Decompiled with CFR 0.152.
 */
package xades4j.providers.impl;

import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import xades4j.XAdES4jException;
import xades4j.providers.CertificateValidationProvider;
import xades4j.providers.ValidationData;
import xades4j.providers.ValidationDataException;
import xades4j.providers.ValidationDataProvider;

public class ValidationDataFromCertValidationProvider
implements ValidationDataProvider {
    private final CertificateValidationProvider certificateValidationProvider;

    public ValidationDataFromCertValidationProvider(CertificateValidationProvider certificateValidationProvider) {
        this.certificateValidationProvider = certificateValidationProvider;
    }

    @Override
    public ValidationData getValidationData(List<X509Certificate> certChainFragment) throws ValidationDataException {
        try {
            X509CertSelector cs = new X509CertSelector();
            cs.setCertificate(certChainFragment.get(0));
            return this.certificateValidationProvider.validate(cs, new Date(), certChainFragment);
        }
        catch (XAdES4jException ex) {
            throw new ValidationDataException("Cannot validate certificate to obtain validation data", ex);
        }
    }
}

