/* $Id$ 
 * vim:tabstop=8:shiftwidth=8:filetype=cpp:textwidth=72:
 * DotVisitor: create a .dot graph representation of the abstract syntax
 * tree.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

namespace ast {

template <typename T>
void
DotVisitor::makeEdges(int fromId, T l)
{
	for (typename T::const_iterator i = l.begin(); i != l.end(); i++) {
		if (*i) {
			this->edges.push_back(
				DotVisitor::Edge(fromId, (*i)->number));
		} 
	}
}

template <typename T>
void
DotVisitor::makeEdges(int fromId, T l, const char* s)
{
	for (typename T::const_iterator i = l.begin(); i != l.end(); i++) {
		if (*i) {
			this->edges.push_back(
				DotVisitor::Edge(
					fromId, (*i)->number, s));
		} 
	}
}


}; /* namespace ast */
