/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo;

public class TrafoConstants {

	public static final boolean DEFAULT_DECOMPOSE_TABLES = false;
	public static final String DEFAULT_DESTINATION_ENCODING = "UTF-8";
	public static final String DEFAULT_EMPHASIS_ROLE_BOLD = "bold";
	public static final String DEFAULT_EMPHASIS_ROLE_ITALIC = "italic";
	public static final String DEFAULT_EMPHASIS_ROLE_UNDERLINE = "underline";
	public static final String DEFAULT_IMAGE_PATH = "./";
	public static final int DEFAULT_MAX_LINE_WIDTH = 75;
	public static final String DEFAULT_SOURCE_ENCODING = "UTF-8";
	public static final String DEFAULT_TABLE_STYLE = "all";

	// public static final String DEFAULT_SECTION_NUMBERING_PATTERN =
	// "(((\\d\\.)+)?\\d*\\.?\\p{Z}*).*";

	public static final String PARAM_ABSTRACT = "abstract";
	public static final String PARAM_ADD_INDEX = "add-index";
	public static final String PARAM_ATTRIBUTE_CLASS = "attribute-class";
	public static final String PARAM_AUTHOR_EMAIL = "author-email";
	public static final String PARAM_AUTHOR_FIRSTNAME = "author-firstname";
	public static final String PARAM_AUTHOR_SURNAME = "author-surname";
	public static final String PARAM_CHUNK_ELEMENTS = "chunk-elements";
	public static final String PARAM_COLLAPSE_PROTECTED_SPACE = "collapse-protected-space";
	public static final String PARAM_COPYRIGHT_HOLDER = "copyright-holder";
	public static final String PARAM_COPYRIGHT_YEAR = "copyright-year";
	public static final String PARAM_CORPORATION = "corporation";
	public static final String PARAM_CREATE_CONDITION_ATTRIBUTE = "create-condition-attribute";
	public static final String PARAM_CREATE_PROLOG = "create-prolog";
	public static final String PARAM_CREATE_REMAP_ATTRIBUTE = "create-remap-attribute";
	public static final String PARAM_CREATE_XREF_LABEL = "create-xref-label";
	public static final String PARAM_DECOMPOSE_TABLES = "decompose-tables";
	public static final String PARAM_DETECT_TRAPPED_BR = "detect-trapped-br";
	public static final String PARAM_DOCBOOK_VERSION = "docbook-version";
	public static final String PARAM_DOCUMENT_ELEMENT = "document-element";
	public static final String PARAM_DOCUMENTATION_ID = "documentation-id";
	public static final String PARAM_ENCODING = "encoding";
	public static final String PARAM_EXCLUDE = "exclude";
	public static final String PARAM_FILE = "file";
	public static final String PARAM_HYPHENATION_CHAR = "hyphenation-char";
	public static final String PARAM_IMAGE_PATH = "image-path";
	public static final String PARAM_IMAGEDATA_FORMATS = "image-data-formats";
	public static final String PARAM_ITEMIZED_ATTRIBUTE_CLASS = "itemized-attribute-class";
	public static final String PARAM_ITEMIZED_STRIP_PREFIX = "itemized-strip-prefix";
	public static final String PARAM_LANGUAGE = "language";
	public static final String PARAM_ORDERED_ATTRIBUTE_CLASS = "ordered-attribute-class";
	public static final String PARAM_ORDERED_STRIP_PREFIX = "ordered-strip-prefix";
	public static final String PARAM_RELEASE_INFO = "release-info";
	public static final String PARAM_SECTION_NUMBERING_PATTERN = "section-numbering-pattern";
	public static final String PARAM_TABLE_STYLE = "table-style";
	public static final String PARAM_TITLE = "title";
	public static final String PARAM_TITLE_NORMALIZE_SPACE = "title-normalize-space";
	public static final String PARAM_USE_ABSOLUTE_IMAGE_PATH = "use-absolute-image-path";
	
	public static final String SECTION_DITA = "DITA";
	public static final String SECTION_DOCBOOK = "DocBook";
	public static final String SECTION_HTML = "HTML";
	public static final String SECTION_IMPORT = "import";
	public static final String SECTION_INPUT = "input";
	public static final String SECTION_LIST_DETECTION = "list-detection";
	public static final String SECTION_MAIN = "main";
	public static final String SECTION_OUTPUT = "output";
	public static final String SECTION_SECTION_DETECTION = "section-detection";

	public static final String VAR_IMAGE_SUBPATH = "image-subpath";
}
