#ifndef FUNC_LESS_OR_EQUAL_H_
#define FUNC_LESS_OR_EQUAL_H_

#include "Infix.h"

namespace jags {
namespace base {

/**
 * @short Numeric comparison
 * <pre>
 * y <- a <= b
 * y = 1 if a <= b
 *     0 if a > b
 * </pre>
 */
class LessOrEqual:public Infix
{
public:
    LessOrEqual ();
    double evaluate(std::vector<double const *> const &args) const;
    /** Returns true */
    bool isDiscreteValued(std::vector<bool> const &mask) const;
};

}}

#endif /* FUNC_LESS_OR_EQUAL_H_ */
