/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2013-2014 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.sun.jersey.api.wadl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.BuildFileTest;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.containsString;

/**
 *  Test for {@link WadlGeneratorTask}.
 *
 * @author Jakub Podlesak (jakub.podlesak at oracle.com)
 */
public class WadlGeneratorTaskTest extends BuildFileTest {

    @Override
    protected void setUp() throws Exception {
        configureProject("target/test-classes/build.xml");
    }

    /**
     * Reproducer for JERSEY-1833. Invoke {@link WadlGeneratorTask} via ant test utility library
     * and verify no {@link NullPointerException} is thrown and generated WADL contains
     * expected elements.
     *
     * @throws IOException in case generated WADL could not be read.
     */
    public void testWadlGeneration() throws IOException {
        executeTarget("generate.wadl");
        final InputStream wadlStream = WadlGeneratorTaskTest.class.getResourceAsStream("/wadl.xml");
        String wadl = readWadl(wadlStream);
        // eventually remove the "nsX:" namespace prefix generated by MOXy
        wadl = wadl.replaceFirst("xmlns:ns\\d=\"http://jersey.java.net/\"", "xmlns:jersey=\"http://jersey.java.net/\"");
        assertThat(wadl, containsString("xmlns:jersey=\"http://jersey.java.net/\""));
        assertThat(wadl, containsString("getMe"));
    }

    /**
     * Convert content of given stream into a String value.
     *
     * @param wadlStream input stream to read.
     * @return content of the above stream as a String value.
     * @throws IOException in case the stream could not be read.
     */
    private String readWadl(final InputStream wadlStream) throws IOException {
        final byte[] buffer = new byte[1024];
        final StringBuilder sb = new StringBuilder();
        int read;
        while ((read = wadlStream.read(buffer, 0, 1024)) > 0) {
            sb.append(new String(buffer, 0, read));
        }
        return sb.toString();
    }
}