import { isJoplinChecklistItem } from '../listModel/JoplinListUtil';


const setup = function (editor) {
    const editorClickHandler = (event) => {
        if (!isJoplinChecklistItem(event.target)) return;

        // We only process the click if it's within the checkbox itself (and not the label).
        // That checkbox, based on
        // the current styling is in the negative margin, so offsetX is negative when clicking
        // on the checkbox itself, and positive when clicking on the label. This is strongly
        // dependent on how the checkbox is styled, so if the style is changed, this might need
        // to be updated too.
        // For the styling, see:
        // packages/renderer/MdToHtml/rules/checkbox.ts
        //
        // The previous solution was to use "pointer-event: none", which mostly work, however
        // it means that links are no longer clickable when they are within the checkbox label.
        if (event.offsetX >= 0) return;

        editor.execCommand('ToggleJoplinChecklistItem', false, { element: event.target });
    }
    editor.on('click', editorClickHandler);
};

export { setup };