/*
 * Copyright (c) AXA Group Operations Spain S.A.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

const { Stopwords } = require('@nlpjs/core');

class StopwordsEl extends Stopwords {
  constructor(container, words) {
    super(container);
    this.name = 'stopwords-el';
    this.dictionary = {};
    const list = words || [
      'μετα',
      'πανω',
      'ολα',
      'ξανα',
      'επίσης',
      'ειμαι',
      'ειναι',
      'ενα',
      'αλλο',
      'οποιο',
      'οποιοδηποτε',
      'οτιδηποτε',
      'οποιαδηποτε',
      'στο',
      'σαν',
      'στα',
      'γιατι',
      'ηταν',
      'πριν',
      'κατω',
      'αναμεσα',
      'αναμεσα',
      'αλλα',
      'μπορει',
      'δεν',
      'ηρθε',
      'ερθει',
      'και',
      'σου',
      'εισαι',
      'ειναι',
      'ισως',
      'εκανε',
      'κανε',
      'κανει',
      'κατα',
      'καθε',
      'λιγα',
      'για',
      'απο',
      'πιο',
      'παρε',
      'πηρε',
      'εχει',
      'ειχε',
      'αυτος',
      'αυτο',
      'αυτη',
      'ιδιος',
      'ιδια',
      'ιδιο',
      'πως',
      'αν',
      'μεσα',
      'κανε',
      'κανει',
      'πολλα',
      'εγω',
      'εμενα',
      'περισσοτερα',
      'περισσοτερο',
      'περισσοτεροι',
      'λιγοτερα',
      'λιγοτερος',
      'λιγοτεροι',
      'πολλα',
      'πολλες',
      'πολλοι',
      'πρεπει',
      'μου',
      'δικο',
      'της',
      'τη',
      'η',
      'το',
      'ο',
      'τα',
      'τις',
      'την',
      'τι',
      'εαυτος',
      'ποτε',
      'τωρα',
      'μονο',
      'τους',
      'αυτοι',
      'εξω',
      'ειπαν',
      'ειπε',
      'θα',
      'πουν',
      'δες',
      'ειδαν',
      'επρεπε',
      'οποτε',
      'μερικοι',
      'μερικος',
      'μερικα',
      'ακομα',
      'αυτων',
      'αυτον',
      'εκει',
      'αυτα',
      'υπο',
      'μεχρι',
      'πολυ',
      'λοιπον',
      'που',
      'οταν',
      'ποιος',
      'με',
      'εσυ',
      'εμεις',
      'κανεις',
      'κατι',
      'καποιος',
      'καποιο',
      'εσεις',
      'α',
      'β',
      'γ',
      'δ',
      'ε',
      'ζ',
      'η',
      'θ',
      'ι',
      'κ',
      'λ',
      'μ',
      'ν',
      'ξ',
      'ο',
      'π',
      'ρ',
      'σ',
      'τ',
      'υ',
      'φ',
      'χ',
      'ψ',
      'ω',
      'ς',
    ];
    this.build(list);
  }
}

module.exports = StopwordsEl;
