![NLPjs logo](../../screenshots/nlplogo.gif)

# @nlpjs/lang-en

[![](https://github.com/axa-group/nlp.js/actions/workflows/node.js.yml/badge.svg?branch=master)](https://github.com/axa-group/nlp.js/actions/workflows/node.js.yml)
[![Coverage Status](https://coveralls.io/repos/github/axa-group/nlp.js/badge.svg?branch=master)](https://coveralls.io/github/axa-group/nlp.js?branch=master)
[![NPM version](https://img.shields.io/npm/v/node-nlp.svg?style=flat)](https://www.npmjs.com/package/node-nlp)
[![NPM downloads](https://img.shields.io/npm/dm/node-nlp.svg?style=flat)](https://www.npmjs.com/package/node-nlp)

## TABLE OF CONTENTS

<!--ts-->

- [Installation](#installation)
- [Normalization](#normalization)
- [Tokenization](#tokenization)
- [Identify if a word is an english stopword](#identify-if-a-word-is-an-english-stopword)
- [Remove stopwords from an array of words](#remove-stopwords-from-an-array-of-words)
- [Change the stopwords dictionary](#change-the-stopwords-dictionary)
- [Stemming word by word](#stemming-word-by-word)
- [Stemming an array of words](#stemming-an-array-of-words)
- [Normalizing, Tokenizing and Stemming a sentence](#normalizing-tokenizing-and-stemming-a-sentence)
- [Remove stopwords when stemming a sentence](#remove-stopwords-when-stemming-a-sentence)
- [Sentiment Analysis](#sentiment-analysis)
- [Example of usage on a classifier](#example-of-usage-on-a-classifier)
- [Contributing](#contributing)
- [Contributors](#contributors)
- [Code of Conduct](#code-of-conduct)
- [Who is behind it](#who-is-behind-it)
- [License](#license.md)
  <!--te-->

## Installation

You can install @nlpjs/lang-en:

```bash
    npm install @nlpjs/lang-en
```

## Normalization

Normalization of a text converts it to lowercase and remove decorations of characters.

```javascript
const { NormalizerEn } = require('@nlpjs/lang-en');

const normalizer = new NormalizerEn();
const input = 'This shóuld be normalized';
const result = normalizer.normalize(input);
console.log(result);
// output: this should be normalized
```

## Tokenization

Tokenization splits a sentence into words.

```javascript
const { TokenizerEn } = require('@nlpjs/lang-en');

const tokenizer = new TokenizerEn();
const input = 'This isn\'t tokenized yet';
const result = tokenizer.tokenize(input);
console.log(result);
// output: [ 'This', 'is', 'not', 'tokenized', 'yet' ]
```

Tokenizer can also normalize the sentence before tokenizing, to do that provide a _true_ as second argument to the method _tokenize_

```javascript
const { TokenizerEn } = require('@nlpjs/lang-en');

const tokenizer = new TokenizerEn();
const input = 'This isn\'t tokenized yet';
const result = tokenizer.tokenize(input true);
console.log(result);
// output: [ 'this', 'is', 'not', 'tokenized', 'yet' ]
```

## Identify if a word is an english stopword

Using the class _StopwordsEn_ you can identify if a word is an stopword:

```javascript
const { StopwordsEn } = require('@nlpjs/lang-en');

const stopwords = new StopwordsEn();
console.log(stopwords.isStopword('is'));
// output: true
console.log(stopwords.isStopword('developer'));
// output: false
```

## Remove stopwords from an array of words

Using the class _StopwordsEn_ you can remove stopwords form an array of words:

```javascript
const { StopwordsEn } = require('@nlpjs/lang-en');

const stopwords = new StopwordsEn();
console.log(stopwords.removeStopwords(['who', 'is', 'your', 'develop']));
// output: ['develop']
```

## Change the stopwords dictionary
Using the class _StopwordsEn_ you can restart it dictionary and build it from another set of words:

```javascript
const { StopwordsEn } = require('@nlpjs/lang-en');

const stopwords = new StopwordsEn();
stopwords.dictionary = {};
stopwords.build(['is', 'your']);
console.log(stopwords.removeStopwords(['who', 'is', 'your', 'develop']));
// output: ['who', 'develop']
```

## Stemming word by word

An stemmer is an algorithm to calculate the _stem_ (root) of a word, removing affixes. 

You can stem one word using method _stemWord_:

```javascript
const { StemmerEn } = require('@nlpjs/lang-en');

const stemmer = new StemmerEn();
const input = 'developer';
console.log(stemmer.stemWord(input));
// output: develop
```

## Stemming an array of words

You can stem an array of words using method _stem_:

```javascript
const { StemmerEn } = require('@nlpjs/lang-en');

const stemmer = new StemmerEn();
const input = ['Who', 'is', 'your', 'developer'];
console.log(stemmer.stem(input));
// outuput: [ 'Who', 'is', 'your', 'develop' ]
```

## Normalizing, Tokenizing and Stemming a sentence

As you can see, stemmer does not do internal normalization, so words with uppercases will remain uppercased. 
Also, stemmer works with lowercased affixes, so _developer_ will be stemmed as _develop_ but _DEVELOPER_ will not be changed.

You can tokenize and stem a sentence, including normalization, with the method _tokenizeAndStem_:

```javascript
const { StemmerEn } = require('@nlpjs/lang-en');

const stemmer = new StemmerEn();
const input = 'Who is your DEVELOPER';
console.log(stemmer.tokenizeAndStem(input));
// output: [ 'who', 'is', 'your', 'develop' ]
```

## Remove stopwords when stemming a sentence

When calling _tokenizeAndStem_ method from the class _StemmerEn_, the second parameter is a boolean to set if the stemmer must keep the stopwords (true) or remove them (false). Before using it, the stopwords instance must be set into the stemmer:

```javascript
const { StemmerEn, StopwordsEn } = require('@nlpjs/lang-en');

const stemmer = new StemmerEn();
stemmer.stopwords = new StopwordsEn();
const input = 'who is your developer';
console.log(stemmer.tokenizeAndStem(input, false));
// output: ['develop']
```

## Sentiment Analysis

To use sentiment analysis you'll need to create a new _Container_ and use the plugin _LangEn_, because internally the _SentimentAnalyzer_ class try to retrieve the normalizer, tokenizer, stemmmer and sentiment dictionaries from the container.

```javascript
const { Container } = require('@nlpjs/core');
const { SentimentAnalyzer } = require('@nlpjs/sentiment');
const { LangEn } = require('@nlpjs/lang-en');

(async () => {
  const container = new Container();
  container.use(LangEn);
  const sentiment = new SentimentAnalyzer({ container });
  const result = await sentiment.process({ locale: 'en', text: 'I love cats'});
  console.log(result.sentiment);
})();
// output:
// {                              
//   score: 0.5,                  
//   numWords: 3,                 
//   numHits: 1,                  
//   average: 0.16666666666666666,
//   type: 'senticon',            
//   locale: 'en',                
//   vote: 'positive'             
// }                              
```

The output of the sentiment analysis includes:
- *score*: final score of the sentence. 
- *numWords*: total words of the sentence.
- *numHits*: total words of the sentence identified as having a sentiment score.
- *average*: score divided by numWords
- *type*: type of dictionary used, values can be afinn, senticon or pattern.
- *locale*: locale of the sentence
- *vote*: positive if score greater than 0, negative if score lower than 0, neutral if score equals 0.

## Example of usage on a classifier

```javascript
const { containerBootstrap } = require('@nlpjs/core');
const { Nlp } = require('@nlpjs/nlp');
const { LangEn } = require('@nlpjs/lang-en');

(async () => {
  const container = await containerBootstrap();
  container.use(Nlp);
  container.use(LangEn);
  const nlp = container.get('nlp');
  nlp.settings.autoSave = false;
  nlp.addLanguage('en');
  // Adds the utterances and intents for the NLP
  nlp.addDocument('en', 'goodbye for now', 'greetings.bye');
  nlp.addDocument('en', 'bye bye take care', 'greetings.bye');
  nlp.addDocument('en', 'okay see you later', 'greetings.bye');
  nlp.addDocument('en', 'bye for now', 'greetings.bye');
  nlp.addDocument('en', 'i must go', 'greetings.bye');
  nlp.addDocument('en', 'hello', 'greetings.hello');
  nlp.addDocument('en', 'hi', 'greetings.hello');
  nlp.addDocument('en', 'howdy', 'greetings.hello');
  
  // Train also the NLG
  nlp.addAnswer('en', 'greetings.bye', 'Till next time');
  nlp.addAnswer('en', 'greetings.bye', 'see you soon!');
  nlp.addAnswer('en', 'greetings.hello', 'Hey there!');
  nlp.addAnswer('en', 'greetings.hello', 'Greetings!');
  await nlp.train();
  const response = await nlp.process('en', 'I should go now');
  console.log(response);
})();
```

## Contributing

You can read the guide of how to contribute at [Contributing](../../CONTRIBUTING.md).

## Contributors

[![Contributors](https://contributors-img.firebaseapp.com/image?repo=axa-group/nlp.js)](https://github.com/axa-group/nlp.js/graphs/contributors)

Made with [contributors-img](https://contributors-img.firebaseapp.com).

## Code of Conduct

You can read the Code of Conduct at [Code of Conduct](../../CODE_OF_CONDUCT.md).

## Who is behind it`?`

This project is developed by AXA Group Operations Spain S.A.

If you need to contact us, you can do it at the email opensource@axa.com

## License

Copyright (c) AXA Group Operations Spain S.A.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
