/*
 * Copyright (c) AXA Group Operations Spain S.A.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

const { Stopwords } = require('@nlpjs/core');

class StopwordsNo extends Stopwords {
  constructor(container, words) {
    super(container);
    this.name = 'stopwords-no';
    this.dictionary = {};
    const list = words || [
      'og',
      'i',
      'jeg',
      'det',
      'at',
      'en',
      'et',
      'den',
      'til',
      'er',
      'som',
      'på',
      'de',
      'med',
      'han',
      'av',
      'ikke',
      'der',
      'så',
      'var',
      'meg',
      'seg',
      'men',
      'ett',
      'har',
      'om',
      'vi',
      'min',
      'mitt',
      'ha',
      'hadde',
      'hun',
      'nå',
      'over',
      'da',
      'ved',
      'fra',
      'du',
      'ut',
      'sin',
      'dem',
      'oss',
      'opp',
      'man',
      'kan',
      'hans',
      'hvor',
      'eller',
      'hva',
      'skal',
      'selv',
      'sjøl',
      'her',
      'alle',
      'vil',
      'bli',
      'ble',
      'blitt',
      'kunne',
      'inn',
      'når',
      'være',
      'kom',
      'noen',
      'noe',
      'ville',
      'dere',
      'som',
      'deres',
      'kun',
      'ja',
      'etter',
      'ned',
      'skulle',
      'denne',
      'for',
      'deg',
      'si',
      'sine',
      'sitt',
      'mot',
      'å',
      'meget',
      'hvorfor',
      'dette',
      'disse',
      'uten',
      'hvordan',
      'ingen',
      'din',
      'ditt',
      'blir',
      'samme',
      'hvilken',
      'hvilke',
      'sånn',
      'inni',
      'mellom',
      'vår',
      'hver',
      'hvem',
      'vors',
      'hvis',
      'både',
      'bare',
      'enn',
      'fordi',
      'før',
      'mange',
      'også',
      'slik',
      'vært',
      'være',
      'begge',
      'siden',
      'henne',
      'hennar',
      'hennes',
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '0',
      '_',
    ];
    this.build(list);
  }
}

module.exports = StopwordsNo;
