export default function _classApplyDescriptorUpdate(receiver, descriptor) {
    if (descriptor.set) {
        if (!("__destrWrapper" in descriptor)) {
            descriptor.__destrWrapper = {
                set value(v) {
                    descriptor.set.call(receiver, v);
                },
                get value() {
                    return descriptor.get.call(receiver);
                },
            };
        }
        return descriptor.__destrWrapper;
    } else {
        if (!descriptor.writable) {
            // This should only throw in strict mode, but class bodies are
            // always strict and private fields can only be used inside
            // class bodies.
            throw new TypeError("attempted to set read only private field");
        }
        return descriptor;
    }
}
