/**********************************************************************
 * Copyright (c) by Heiner Jostkleigrewe
 * This program is free software: you can redistribute it and/or modify it under the terms of the 
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,  but WITHOUT ANY WARRANTY; without 
 *  even the implied warranty of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See 
 *  the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program.  If not, 
 * see <http://www.gnu.org/licenses/>.
 * 
 * heiner@jverein.de
 * www.jverein.de
 **********************************************************************/
package de.jost_net.JVerein.gui.action;

import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;

import de.jost_net.JVerein.Einstellungen;
import de.jost_net.JVerein.rmi.Buchungsklasse;
import de.willuhn.datasource.rmi.DBService;
import de.willuhn.datasource.rmi.ResultSetExtractor;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.YesNoDialog;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;

/**
 * Lschen einer Buchungsklasse.
 */
public class BuchungsklasseDeleteAction implements Action
{
  @Override
  public void handleAction(Object context) throws ApplicationException
  {
    if (context == null || !(context instanceof Buchungsklasse))
    {
      throw new ApplicationException("Keine Buchungsklasse ausgewhlt");
    }
    try
    {
      Buchungsklasse b = (Buchungsklasse) context;
      if (b.isNewObject())
      {
        return;
      }
      // Prfen ob Buchungsklasse schon verwendet wird
      DBService service = Einstellungen.getDBService();
      String sql = "SELECT buchungsart.id from buchungsart "
          + "WHERE (buchungsklasse = ?) ";
      boolean benutzt = (boolean) service.execute(sql,
          new Object[] { b.getID() }, new ResultSetExtractor()
      {
        @Override
        public Object extract(ResultSet rs)
            throws RemoteException, SQLException
        {
          if (rs.next())
          {
            return true;
          }
          return false;
        }
      });
      if (benutzt)
      {
        throw new ApplicationException(
            "Die Buchungsklasse wird von einer Buchungsart benutzt und kann nicht gelscht werden");
      }
      
      service = Einstellungen.getDBService();
      sql = "SELECT konto.id from konto "
          + "WHERE (anlagenklasse = ?) ";
      benutzt = (boolean) service.execute(sql,
          new Object[] { b.getID() }, new ResultSetExtractor()
      {
        @Override
        public Object extract(ResultSet rs)
            throws RemoteException, SQLException
        {
          if (rs.next())
          {
            return true;
          }
          return false;
        }
      });
      if (benutzt)
      {
        throw new ApplicationException(
            "Die Buchungsklasse wird von einem Anlagenkonto benutzt und kann nicht gelscht werden");
      }
      
      YesNoDialog d = new YesNoDialog(YesNoDialog.POSITION_CENTER);
      d.setTitle("Buchungsklasse lschen");
      d.setText("Wollen Sie diese Buchungsklasse wirklich lschen?");
      try
      {
        Boolean choice = (Boolean) d.open();
        if (!choice.booleanValue())
          return;
      }
      catch (Exception e)
      {
        Logger.error("Fehler beim Lschen der Buchungsklasse", e);
        return;
      }

      b.delete();
      GUI.getStatusBar().setSuccessText("Buchungsklasse gelscht.");
    }
    catch (RemoteException e)
    {
      String fehler = "Fehler beim Lschen der Buchungsklasse.";
      GUI.getStatusBar().setErrorText(fehler);
      Logger.error(fehler, e);
    }
  }
}
