
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQRandomGenerator.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QRandomGenerator>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QRandomGenerator

//  Constructor QRandomGenerator::QRandomGenerator(quint32 seedValue)


static void _init_ctor_QRandomGenerator_1098 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("seedValue", true, "1");
  decl->add_arg<quint32 > (argspec_0);
  decl->set_return_new<QRandomGenerator> ();
}

static void _call_ctor_QRandomGenerator_1098 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  quint32 arg1 = args ? gsi::arg_reader<quint32 >() (args, heap) : gsi::arg_maker<quint32 >() (1, heap);
  ret.write<QRandomGenerator *> (new QRandomGenerator (arg1));
}


//  Constructor QRandomGenerator::QRandomGenerator(const QRandomGenerator &other)


static void _init_ctor_QRandomGenerator_2938 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QRandomGenerator & > (argspec_0);
  decl->set_return_new<QRandomGenerator> ();
}

static void _call_ctor_QRandomGenerator_2938 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRandomGenerator &arg1 = gsi::arg_reader<const QRandomGenerator & >() (args, heap);
  ret.write<QRandomGenerator *> (new QRandomGenerator (arg1));
}


// double QRandomGenerator::bounded(double highest)


static void _init_f_bounded_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("highest");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_bounded_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<double > ((double)((QRandomGenerator *)cls)->bounded (arg1));
}


// quint32 QRandomGenerator::bounded(quint32 highest)


static void _init_f_bounded_1098 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("highest");
  decl->add_arg<quint32 > (argspec_0);
  decl->set_return<quint32 > ();
}

static void _call_f_bounded_1098 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  quint32 arg1 = gsi::arg_reader<quint32 >() (args, heap);
  ret.write<quint32 > ((quint32)((QRandomGenerator *)cls)->bounded (arg1));
}


// quint32 QRandomGenerator::bounded(quint32 lowest, quint32 highest)


static void _init_f_bounded_2088 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lowest");
  decl->add_arg<quint32 > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("highest");
  decl->add_arg<quint32 > (argspec_1);
  decl->set_return<quint32 > ();
}

static void _call_f_bounded_2088 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  quint32 arg1 = gsi::arg_reader<quint32 >() (args, heap);
  quint32 arg2 = gsi::arg_reader<quint32 >() (args, heap);
  ret.write<quint32 > ((quint32)((QRandomGenerator *)cls)->bounded (arg1, arg2));
}


// int QRandomGenerator::bounded(int highest)


static void _init_f_bounded_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("highest");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_bounded_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QRandomGenerator *)cls)->bounded (arg1));
}


// int QRandomGenerator::bounded(int lowest, int highest)


static void _init_f_bounded_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lowest");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("highest");
  decl->add_arg<int > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_bounded_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QRandomGenerator *)cls)->bounded (arg1, arg2));
}


// quint64 QRandomGenerator::bounded(quint64 highest)


static void _init_f_bounded_1103 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("highest");
  decl->add_arg<quint64 > (argspec_0);
  decl->set_return<quint64 > ();
}

static void _call_f_bounded_1103 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  quint64 arg1 = gsi::arg_reader<quint64 >() (args, heap);
  ret.write<quint64 > ((quint64)((QRandomGenerator *)cls)->bounded (arg1));
}


// quint64 QRandomGenerator::bounded(quint64 lowest, quint64 highest)


static void _init_f_bounded_2098 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lowest");
  decl->add_arg<quint64 > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("highest");
  decl->add_arg<quint64 > (argspec_1);
  decl->set_return<quint64 > ();
}

static void _call_f_bounded_2098 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  quint64 arg1 = gsi::arg_reader<quint64 >() (args, heap);
  quint64 arg2 = gsi::arg_reader<quint64 >() (args, heap);
  ret.write<quint64 > ((quint64)((QRandomGenerator *)cls)->bounded (arg1, arg2));
}


// qint64 QRandomGenerator::bounded(qint64 highest)


static void _init_f_bounded_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("highest");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<qint64 > ();
}

static void _call_f_bounded_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ret.write<qint64 > ((qint64)((QRandomGenerator *)cls)->bounded (arg1));
}


// qint64 QRandomGenerator::bounded(qint64 lowest, qint64 highest)


static void _init_f_bounded_1864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lowest");
  decl->add_arg<qint64 > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("highest");
  decl->add_arg<qint64 > (argspec_1);
  decl->set_return<qint64 > ();
}

static void _call_f_bounded_1864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  qint64 arg2 = gsi::arg_reader<qint64 >() (args, heap);
  ret.write<qint64 > ((qint64)((QRandomGenerator *)cls)->bounded (arg1, arg2));
}


// qint64 QRandomGenerator::bounded(int lowest, qint64 highest)


static void _init_f_bounded_1645 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lowest");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("highest");
  decl->add_arg<qint64 > (argspec_1);
  decl->set_return<qint64 > ();
}

static void _call_f_bounded_1645 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  qint64 arg2 = gsi::arg_reader<qint64 >() (args, heap);
  ret.write<qint64 > ((qint64)((QRandomGenerator *)cls)->bounded (arg1, arg2));
}


// qint64 QRandomGenerator::bounded(qint64 lowest, int highest)


static void _init_f_bounded_1645u1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lowest");
  decl->add_arg<qint64 > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("highest");
  decl->add_arg<int > (argspec_1);
  decl->set_return<qint64 > ();
}

static void _call_f_bounded_1645u1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<qint64 > ((qint64)((QRandomGenerator *)cls)->bounded (arg1, arg2));
}


// quint64 QRandomGenerator::bounded(unsigned int lowest, quint64 highest)


static void _init_f_bounded_2767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lowest");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("highest");
  decl->add_arg<quint64 > (argspec_1);
  decl->set_return<quint64 > ();
}

static void _call_f_bounded_2767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = gsi::arg_reader<unsigned int >() (args, heap);
  quint64 arg2 = gsi::arg_reader<quint64 >() (args, heap);
  ret.write<quint64 > ((quint64)((QRandomGenerator *)cls)->bounded (arg1, arg2));
}


// quint64 QRandomGenerator::bounded(quint64 lowest, unsigned int highest)


static void _init_f_bounded_2767u1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lowest");
  decl->add_arg<quint64 > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("highest");
  decl->add_arg<unsigned int > (argspec_1);
  decl->set_return<quint64 > ();
}

static void _call_f_bounded_2767u1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  quint64 arg1 = gsi::arg_reader<quint64 >() (args, heap);
  unsigned int arg2 = gsi::arg_reader<unsigned int >() (args, heap);
  ret.write<quint64 > ((quint64)((QRandomGenerator *)cls)->bounded (arg1, arg2));
}


// void QRandomGenerator::discard(unsigned long long int z)


static void _init_f_discard_2924 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("z");
  decl->add_arg<unsigned long long int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_discard_2924 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned long long int arg1 = gsi::arg_reader<unsigned long long int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRandomGenerator *)cls)->discard (arg1);
}


// quint32 QRandomGenerator::generate()


static void _init_f_generate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quint32 > ();
}

static void _call_f_generate_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<quint32 > ((quint32)((QRandomGenerator *)cls)->generate ());
}


// void QRandomGenerator::generate(quint32 *begin, quint32 *end)


static void _init_f_generate_2460 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("begin");
  decl->add_arg<quint32 * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("end");
  decl->add_arg<quint32 * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_generate_2460 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  quint32 *arg1 = gsi::arg_reader<quint32 * >() (args, heap);
  quint32 *arg2 = gsi::arg_reader<quint32 * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRandomGenerator *)cls)->generate (arg1, arg2);
}


// quint64 QRandomGenerator::generate64()


static void _init_f_generate64_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quint64 > ();
}

static void _call_f_generate64_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<quint64 > ((quint64)((QRandomGenerator *)cls)->generate64 ());
}


// double QRandomGenerator::generateDouble()


static void _init_f_generateDouble_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_generateDouble_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRandomGenerator *)cls)->generateDouble ());
}


// quint32 QRandomGenerator::operator()()


static void _init_f_operator_func__0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quint32 > ();
}

static void _call_f_operator_func__0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<quint32 > ((quint32)((QRandomGenerator *)cls)->operator() ());
}


// QRandomGenerator &QRandomGenerator::operator=(const QRandomGenerator &other)


static void _init_f_operator_eq__2938 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QRandomGenerator & > (argspec_0);
  decl->set_return<QRandomGenerator & > ();
}

static void _call_f_operator_eq__2938 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRandomGenerator &arg1 = gsi::arg_reader<const QRandomGenerator & >() (args, heap);
  ret.write<QRandomGenerator & > ((QRandomGenerator &)((QRandomGenerator *)cls)->operator= (arg1));
}


// void QRandomGenerator::seed(quint32 s)


static void _init_f_seed_1098 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s", true, "1");
  decl->add_arg<quint32 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_seed_1098 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  quint32 arg1 = args ? gsi::arg_reader<quint32 >() (args, heap) : gsi::arg_maker<quint32 >() (1, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRandomGenerator *)cls)->seed (arg1);
}


// static QRandomGenerator *QRandomGenerator::global()


static void _init_f_global_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QRandomGenerator * > ();
}

static void _call_f_global_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRandomGenerator * > ((QRandomGenerator *)QRandomGenerator::global ());
}


// static quint32 QRandomGenerator::max()


static void _init_f_max_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<quint32 > ();
}

static void _call_f_max_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<quint32 > ((quint32)QRandomGenerator::max ());
}


// static quint32 QRandomGenerator::min()


static void _init_f_min_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<quint32 > ();
}

static void _call_f_min_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<quint32 > ((quint32)QRandomGenerator::min ());
}


// static QRandomGenerator QRandomGenerator::securelySeeded()


static void _init_f_securelySeeded_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QRandomGenerator > ();
}

static void _call_f_securelySeeded_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRandomGenerator > ((QRandomGenerator)QRandomGenerator::securelySeeded ());
}


// static QRandomGenerator *QRandomGenerator::system()


static void _init_f_system_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QRandomGenerator * > ();
}

static void _call_f_system_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRandomGenerator * > ((QRandomGenerator *)QRandomGenerator::system ());
}



namespace gsi
{

static gsi::Methods methods_QRandomGenerator () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRandomGenerator::QRandomGenerator(quint32 seedValue)\nThis method creates an object of class QRandomGenerator.", &_init_ctor_QRandomGenerator_1098, &_call_ctor_QRandomGenerator_1098);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRandomGenerator::QRandomGenerator(const QRandomGenerator &other)\nThis method creates an object of class QRandomGenerator.", &_init_ctor_QRandomGenerator_2938, &_call_ctor_QRandomGenerator_2938);
  methods += new qt_gsi::GenericMethod ("bounded", "@brief Method double QRandomGenerator::bounded(double highest)\n", false, &_init_f_bounded_1071, &_call_f_bounded_1071);
  methods += new qt_gsi::GenericMethod ("bounded", "@brief Method quint32 QRandomGenerator::bounded(quint32 highest)\n", false, &_init_f_bounded_1098, &_call_f_bounded_1098);
  methods += new qt_gsi::GenericMethod ("bounded", "@brief Method quint32 QRandomGenerator::bounded(quint32 lowest, quint32 highest)\n", false, &_init_f_bounded_2088, &_call_f_bounded_2088);
  methods += new qt_gsi::GenericMethod ("bounded", "@brief Method int QRandomGenerator::bounded(int highest)\n", false, &_init_f_bounded_767, &_call_f_bounded_767);
  methods += new qt_gsi::GenericMethod ("bounded", "@brief Method int QRandomGenerator::bounded(int lowest, int highest)\n", false, &_init_f_bounded_1426, &_call_f_bounded_1426);
  methods += new qt_gsi::GenericMethod ("bounded", "@brief Method quint64 QRandomGenerator::bounded(quint64 highest)\n", false, &_init_f_bounded_1103, &_call_f_bounded_1103);
  methods += new qt_gsi::GenericMethod ("bounded", "@brief Method quint64 QRandomGenerator::bounded(quint64 lowest, quint64 highest)\n", false, &_init_f_bounded_2098, &_call_f_bounded_2098);
  methods += new qt_gsi::GenericMethod ("bounded", "@brief Method qint64 QRandomGenerator::bounded(qint64 highest)\n", false, &_init_f_bounded_986, &_call_f_bounded_986);
  methods += new qt_gsi::GenericMethod ("bounded", "@brief Method qint64 QRandomGenerator::bounded(qint64 lowest, qint64 highest)\n", false, &_init_f_bounded_1864, &_call_f_bounded_1864);
  methods += new qt_gsi::GenericMethod ("bounded", "@brief Method qint64 QRandomGenerator::bounded(int lowest, qint64 highest)\n", false, &_init_f_bounded_1645, &_call_f_bounded_1645);
  methods += new qt_gsi::GenericMethod ("bounded", "@brief Method qint64 QRandomGenerator::bounded(qint64 lowest, int highest)\n", false, &_init_f_bounded_1645u1, &_call_f_bounded_1645u1);
  methods += new qt_gsi::GenericMethod ("bounded", "@brief Method quint64 QRandomGenerator::bounded(unsigned int lowest, quint64 highest)\n", false, &_init_f_bounded_2767, &_call_f_bounded_2767);
  methods += new qt_gsi::GenericMethod ("bounded", "@brief Method quint64 QRandomGenerator::bounded(quint64 lowest, unsigned int highest)\n", false, &_init_f_bounded_2767u1, &_call_f_bounded_2767u1);
  methods += new qt_gsi::GenericMethod ("discard", "@brief Method void QRandomGenerator::discard(unsigned long long int z)\n", false, &_init_f_discard_2924, &_call_f_discard_2924);
  methods += new qt_gsi::GenericMethod ("generate", "@brief Method quint32 QRandomGenerator::generate()\n", false, &_init_f_generate_0, &_call_f_generate_0);
  methods += new qt_gsi::GenericMethod ("generate", "@brief Method void QRandomGenerator::generate(quint32 *begin, quint32 *end)\n", false, &_init_f_generate_2460, &_call_f_generate_2460);
  methods += new qt_gsi::GenericMethod ("generate64", "@brief Method quint64 QRandomGenerator::generate64()\n", false, &_init_f_generate64_0, &_call_f_generate64_0);
  methods += new qt_gsi::GenericMethod ("generateDouble", "@brief Method double QRandomGenerator::generateDouble()\n", false, &_init_f_generateDouble_0, &_call_f_generateDouble_0);
  methods += new qt_gsi::GenericMethod ("()", "@brief Method quint32 QRandomGenerator::operator()()\n", false, &_init_f_operator_func__0, &_call_f_operator_func__0);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QRandomGenerator &QRandomGenerator::operator=(const QRandomGenerator &other)\n", false, &_init_f_operator_eq__2938, &_call_f_operator_eq__2938);
  methods += new qt_gsi::GenericMethod ("seed", "@brief Method void QRandomGenerator::seed(quint32 s)\n", false, &_init_f_seed_1098, &_call_f_seed_1098);
  methods += new qt_gsi::GenericStaticMethod ("global", "@brief Static method QRandomGenerator *QRandomGenerator::global()\nThis method is static and can be called without an instance.", &_init_f_global_0, &_call_f_global_0);
  methods += new qt_gsi::GenericStaticMethod ("max", "@brief Static method quint32 QRandomGenerator::max()\nThis method is static and can be called without an instance.", &_init_f_max_0, &_call_f_max_0);
  methods += new qt_gsi::GenericStaticMethod ("min", "@brief Static method quint32 QRandomGenerator::min()\nThis method is static and can be called without an instance.", &_init_f_min_0, &_call_f_min_0);
  methods += new qt_gsi::GenericStaticMethod ("securelySeeded", "@brief Static method QRandomGenerator QRandomGenerator::securelySeeded()\nThis method is static and can be called without an instance.", &_init_f_securelySeeded_0, &_call_f_securelySeeded_0);
  methods += new qt_gsi::GenericStaticMethod ("system", "@brief Static method QRandomGenerator *QRandomGenerator::system()\nThis method is static and can be called without an instance.", &_init_f_system_0, &_call_f_system_0);
  return methods;
}

gsi::Class<QRandomGenerator> decl_QRandomGenerator ("QtCore", "QRandomGenerator",
  methods_QRandomGenerator (),
  "@qt\n@brief Binding of QRandomGenerator");


GSI_QTCORE_PUBLIC gsi::Class<QRandomGenerator> &qtdecl_QRandomGenerator () { return decl_QRandomGenerator; }

}

