#ifndef RENDERAREA_H
#define RENDERAREA_H

#include <QtGui>
#include "Graph.h"

class MainWindow;

class RenderArea : public QWidget
{
    Q_OBJECT
public:
    explicit RenderArea(Graph* parent = 0);
    ~RenderArea();
    bool connectPoints;
    QRectF logicalRectange;

    void resizeEvent(QResizeEvent* event);
    void plot();

signals:

public slots:

private:
    MainWindow* mainWindow; // for convenience
    QImage image;
    QImage originalImage;
    QTransform transform;
    QRect selection;
    void paintEvent(QPaintEvent* event);
    void mousePressEvent(QMouseEvent* event);
    void mouseMoveEvent(QMouseEvent* event);
    void mouseReleaseEvent(QMouseEvent* event);
    QList<qreal> marks(qreal lowerBound, qreal upperBound, int minors = 1);
};

#endif // RENDERAREA_H
