/*
|  Copyright (C) 2009 Christophe Fergeau <cfergeau@mandriva.com>
|  Part of the gtkpod project.
| 
|  URL: http://www.gtkpod.org/
|  URL: http://gtkpod.sourceforge.net/
|
|  The code contained in this file is free software; you can redistribute
|  it and/or modify it under the terms of the GNU Lesser General Public
|  License as published by the Free Software Foundation; either version
|  2.1 of the License, or (at your option) any later version.
|
|  This file is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
|  Lesser General Public License for more details.
|
|  You should have received a copy of the GNU Lesser General Public
|  License along with this code; if not, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
|
|  iTunes and iPod are trademarks of Apple
|
|  This product is not supported/written/published by Apple!
|
|  $Id$
*/

#ifndef __ITDB_TZINFO_DATA_H__
#define __ITDB_TZINFO_DATA_H__

G_BEGIN_DECLS

struct _ItdbTimezone {
	const char *city_name;
	unsigned char city_index;
	const char *tz_name;
};
typedef struct _ItdbTimezone ItdbTimezone;

static const ItdbTimezone timezones[] = {
	{ "Doha", 0x87, "Asia/Qatar" },
	{ "SanJose", 0x18, "PST8PDT" },
	{ "Chicago", 0x02, "America/Chicago" },
	{ "Brasilia", 0x3a, "America/Sao_Paulo" },
	{ "Antananarivo", 0x81, "Indian/Antananarivo" },
	{ "WashingtonDC", 0x30, "EST5EDT" },
	{ "SanDiego", 0x08, "PST8PDT" },
	{ "Columbus", 0x20, "EST5EDT" },
	{ "Ndjamena", 0x64, "Africa/Ndjamena" },
	{ "London", 0x4f, "Europe/London" },
	{ "Bogota", 0x1e, "America/Bogota" },
	{ "Magadan", 0xb1, "Asia/Magadan" },
	{ "GeorgeTown", 0x33, "America/Guyana" },
	{ "CapeTown", 0x76, "Africa/Johannesburg" },
	{ "Austin", 0x10, "CST6CDT" },
	{ "Tokyo", 0xc2, "Asia/Tokyo" },
	{ "DesMoines", 0xc7, "CST6CDT" },
	{ "Winnipeg", 0x1c, "America/Winnipeg" },
	{ "Detroit", 0x21, "America/Detroit" },
	{ "Osaka", 0xbf, "Asia/Tokyo" },
	{ "Manila", 0xa1, "Asia/Manila" },
	{ "Kabul", 0xb8, "Asia/Kabul" },
	{ "Bangui", 0x56, "Africa/Bangui" },
	{ "Rome", 0x69, "Europe/Rome" },
	{ "Kolkata", 0xbb, "Asia/Kolkata" },
	{ "KnoxVille", 0x24, "EST5EDT" },
	{ "Portland", 0x07, "PST8PDT" },
	{ "Yekaterinburg", 0x99, "Asia/Yekaterinburg" },
	{ "Ottawa", 0x2a, "EST5EDT" },
	{ "Ankara", 0x72, "EET" },
	{ "Nairobi", 0x8d, "Africa/Nairobi" },
	{ "Montreal", 0x28, "America/Montreal" },
	{ "PhnomPenh", 0xcd, "Asia/Phnom_Penh" },
	{ "Tachkent", 0x98, "Asia/Samarkand" },
	{ "Kiev", 0x7c, "Europe/Kiev" },
	{ "Pyongyang", 0xc0, "Asia/Pyongyang" },
	{ "Jakarta", 0xca, "Asia/Jakarta" },
	{ "Munich", 0x63, "Europe/Berlin" },
	{ "Geneva", 0x5d, "Europe/Paris" },
	{ "MexicoCity", 0x15, "America/Mexico_City" },
	{ "Islamabad", 0x96, "Asia/Karachi" },
	{ "Cayenne", 0x3c, "America/Cayenne" },
	{ "Anchorage", 0x04, "America/Anchorage" },
	{ "Phoenix", 0x0e, "America/Phoenix" },
	{ "StJohns", 0x39, "America/St_Johns" },
	{ "Colombo", 0xba, "Asia/Colombo" },
	{ "Baghdad", 0x83, "Asia/Baghdad" },
	{ "AddisAbaba", 0x80, "Africa/Addis_Ababa" },
	{ "BuenosAires", 0x3b, "America/Argentina/Buenos_Aires" },
	{ "Toronto", 0x2f, "America/Toronto" },
	{ "Bamako", 0x47, "Africa/Bamako" },
	{ "Warsaw", 0x6e, "Europe/Warsaw" },
	{ "Seoul", 0xc1, "Asia/Seoul" },
	{ "Quito", 0x2e, "America/Guayaquil" },
	{ "Beijing", 0x9d, "Asia/Shanghai" },
	{ "Lagos", 0x5f, "Africa/Lagos" },
	{ "Boston", 0x1f, "EST5EDT" },
	{ "Caracas", 0x32, "America/Caracas" },
	{ "Lima", 0x25, "America/Lima" },
	{ "Istanbul", 0x79, "Europe/Istanbul" },
	{ "Zurich", 0x70, "Europe/Zurich" },
	{ "California", 0x01, "PST8PDT" },
	{ "Singapore", 0xa4, "Asia/Singapore" },
	{ "Seattle", 0x0a, "PST8PDT" },
	{ "Madrid", 0x62, "Europe/Madrid" },
	{ "Hobart", 0xad, "Australia/Hobart" },
	{ "Amman", 0x71, "Asia/Amman" },
	{ "Volgograd", 0x91, "Europe/Volgograd" },
	{ "Ljubljana", 0x60, "Europe/Paris" },
	{ "Zagreb", 0x6f, "Europe/Paris" },
	{ "Maputo", 0x7e, "Africa/Maputo" },
	{ "Sofia", 0x7f, "Europe/Sofia" },
	{ "Port-au-Prince", 0x2d, "America/Port-au-Prince" },
	{ "Omsk", 0x9a, "Asia/Omsk" },
	{ "RioDeJaneiro", 0x41, "Africa/Casablanca" },
	{ "Dhaka", 0x9b, "Asia/Dhaka" },
	{ "Freetown", 0x4d, "Africa/Freetown" },
	{ "StLouis", 0x1a, "CST6CDT" },
	{ "Luanda", 0x61, "Africa/Luanda" },
	{ "Philadelphia", 0x2c, "EST5EDT" },
	{ "Grytviken", 0x43, "Atlantic/South_Georgia" },
	{ "Jerusalem", 0x7a, "Asia/Jerusalem" },
	{ "Douala", 0x5c, "Africa/Douala" },
	{ "Hanoi", 0xc9, "Asia/Ho_Chi_Minh" },
	{ "Accra", 0x46, "Africa/Accra" },
	{ "NewDelhi", 0xbd, "Asia/Kolkata" },
	{ "Male", 0x97, "Indian/Maldives" },
	{ "LosAngeles", 0x06, "America/Los_Angeles" },
	{ "Conakry", 0x49, "Africa/Conakry" },
	{ "Santiago", 0x37, "America/Santiago" },
	{ "Sanaa", 0x8f, "Asia/Aden" },
	{ "SanSalvador", 0x19, "America/El_Salvador" },
	{ "Montevideo", 0x3d, "America/Montevideo" },
	{ "Damascus", 0x84, "Asia/Damascus" },
	{ "Belgrade", 0x57, "Europe/Belgrade" },
	{ "Indianapolis", 0x23, "America/Indiana/Indianapolis" },
	{ "Novosibirsk", 0x9c, "Asia/Novosibirsk" },
	{ "Riyadh", 0x8e, "Asia/Riyadh" },
	{ "Nouakchott", 0x51, "Africa/Nouakchott" },
	{ "Honolulu", 0x03, "Pacific/Honolulu" },
	{ "Moscow", 0x8c, "Europe/Moscow" },
	{ "DaresSalaam", 0x85, "Africa/Dar_es_Salaam" },
	{ "SanJuan", 0x36, "America/Argentina/San_Juan" },
	{ "Oslo", 0x65, "Europe/Oslo" },
	{ "NewYork", 0x29, "America/New_York" },
	{ "Tunis", 0x6c, "Africa/Tunis" },
	{ "Guam", 0xac, "Pacific/Guam" },
	{ "Regina", 0x17, "America/Regina" },
	{ "Nuuk", 0x3e, "America/Godthab" },
	{ "Mogadishu", 0x8b, "Africa/Mogadishu" },
	{ "TienTsin", 0xa6, "Asia/Shanghai" },
	{ "Panama", 0x2b, "America/Panama" },
	{ "Paramaribo", 0x3f, "America/Paramaribo" },
	{ "Atlanta", 0x1d, "EST5EDT" },
	{ "Shanghai", 0xa3, "Asia/Shanghai" },
	{ "Berlin", 0x58, "Europe/Berlin" },
	{ "Havana", 0x22, "America/Havana" },
	{ "Reykjavik", 0x53, "Atlantic/Reykjavik" },
	{ "KualaLumpur", 0xa0, "Asia/Kuala_Lumpur" },
	{ "Monrovia", 0x50, "Africa/Monrovia" },
	{ "Ouagadougou", 0x52, "Africa/Ouagadougou" },
	{ "Beirut", 0x73, "Asia/Beirut" },
	{ "Helsinki", 0x78, "Europe/Helsinki" },
	{ "Guatemala", 0x12, "America/Guatemala" },
	{ "Edinburgh", 0x4c, "Europe/London" },
	{ "Tehran", 0xb7, "Asia/Tehran" },
	{ "Victoria", 0x95, "" },
	{ "Dublin", 0x4b, "Europe/Dublin" },
	{ "Minneapolis", 0x16, "CST6CDT" },
	{ "Miami", 0x27, "EST5EDT" },
	{ "Anadyr", 0xb3, "Asia/Anadyr" },
	{ "Manama", 0x89, "Asia/Bahrain" },
	{ "Cupertino", 0x05, "PST8PDT" },
	{ "Halifax", 0x34, "America/Halifax" },
	{ "Vancouver", 0x0b, "America/Vancouver" },
	{ "PortLouis", 0x94, "Indian/Mauritius" },
	{ "Algiers", 0x54, "Africa/Algiers" },
	{ "Canton", 0x9e, "Asia/Shanghai" },
	{ "PagoPago", 0xb6, "Pacific/Pago_Pago" },
	{ "Djibouti", 0x86, "Africa/Djibouti" },
	{ "Wellington", 0xb4, "Pacific/Auckland" },
	{ "Sidney", 0xaf, "Australia/Melbourne" },
	{ "Bangkok", 0xc8, "Asia/Bangkok" },
	{ "LaPaz", 0x35, "America/La_Paz" },
	{ "Ulaanbaatar", 0xa7, "Asia/Ulaanbaatar" },
	{ "Cork", 0x45, "Europe/Dublin" },
	{ "Krasnoyarsk", 0xcb, "Asia/Krasnoyarsk" },
	{ "Asmara", 0x82, "Africa/Asmara" },
	{ "Taipei", 0xa5, "Asia/Taipei" },
	{ "Cardiff", 0x48, "Europe/London" },
	{ "Manchester", 0x26, "Europe/London" },
	{ "Rabat", 0x68, "Africa/Casablanca" },
	{ "Tripoli", 0x6b, "Africa/Tripoli" },
	{ "Recife", 0x40, "America/Recife" },
	{ "Bucharest", 0x74, "Europe/Bucharest" },
	{ "Tegucigalpa", 0x1b, "America/Tegucigalpa" },
	{ "Brussels", 0x59, "Europe/Brussels" },
	{ "Vladivostok", 0xb0, "Asia/Vladivostok" },
	{ "Dakar", 0x4a, "Africa/Dakar" },
	{ "SaltLakeCity", 0x0f, "MST7MDT" },
	{ "MumbaiBombay", 0xbc, "Asia/Kolkata" },
	{ "Canberra", 0xab, "Australia/Melbourne" },
	{ "Harare", 0x77, "Africa/Harare" },
	{ "Yakutsk", 0xc3, "Asia/Yakutsk" },
	{ "Denver", 0x0d, "America/Denver" },
	{ "Darwin", 0xa8, "Australia/Darwin" },
	{ "Adelaide", 0xa9, "Australia/Adelaide" },
	{ "Athens", 0xc4, "Europe/Athens" },
	{ "Dallas", 0x11, "CST6CDT" },
	{ "Muscat", 0x93, "Asia/Muscat" },
	{ "Paris", 0x66, "Europe/Paris" },
	{ "Noumea", 0xb2, "Pacific/Noumea" },
	{ "AbuDhabi", 0x92, "Asia/Dubai" },
	{ "Adak", 0xb5, "America/Adak" },
	{ "Prague", 0x67, "Europe/Prague" },
	{ "HongKong", 0x9f, "Asia/Hong_Kong" },
	{ "Melbourne", 0xae, "Australia/Melbourne" },
	{ "Kathmandu", 0xbe, "Asia/Kathmandu" },
	{ "SaintPetersburg", 0x90, "Europe/Moscow" },
	{ "Budapest", 0x5a, "Europe/Budapest" },
	{ "Mekka", 0x8a, "Asia/Riyadh" },
	{ "Amsterdam", 0x55, "Europe/Amsterdam" },
	{ "Vienna", 0x6d, "Europe/Vienna" },
	{ "SanFrancisco", 0x09, "PST8PDT" },
	{ "Calgary", 0x0c, "MST7MDT" },
	{ "Kampala", 0x88, "Africa/Kampala" },
	{ "Ponta Delgada", 0x44, "Atlantic/Azores" },
	{ "Brisbane", 0xaa, "Australia/Brisbane" },
	{ "SaoPaulo", 0x42, "America/Sao_Paulo" },
	{ "Copenhagen", 0x5b, "Europe/Copenhagen" },
	{ "Kinshasa", 0x5e, "Africa/Kinshasa" },
	{ "Rangoon", 0xc5, "Asia/Rangoon" },
	{ "HoChiMinh", 0xc6, "Asia/Ho_Chi_Minh" },
	{ "ChenaiMadras", 0xb9, "Asia/Kolkata" },
	{ "Memphis", 0x14, "CST6CDT" },
	{ "SantoDomingo", 0x38, "America/Santo_Domingo" },
	{ "Kuwait", 0xcc, "Asia/Kuwait" },
	{ "Lisbon", 0x4e, "Europe/Lisbon" },
	{ "Stockholm", 0x6a, "Europe/Stockholm" },
	{ "Asuncion", 0x31, "America/Asuncion" },
	{ "Lusaka", 0x7d, "Africa/Lusaka" },
	{ "Khartoum", 0x7b, "Africa/Khartoum" },
	{ "Cairo", 0x75, "Africa/Cairo" },
	{ "Perth", 0xa2, "Australia/Perth" },
	{ "Managua", 0x13, "America/Managua" },
	{ NULL, 0, NULL }
};

G_END_DECLS

#endif
