#====================================================================
#
#               Winim - Nim's Windows API Module
#                 (c) Copyright 2016-2021 Ward
#
#====================================================================

import winimbase
import windef
import winbase
#include <wininet.h>
type
  INTERNET_SCHEME* = int32
  LPINTERNET_SCHEME* = ptr int32
  InternetCookieState* = int32
  INTERNET_PORT* = WORD
  GROUPID* = LONGLONG
  HINTERNET* = LPVOID
  LPHINTERNET* = ptr HINTERNET
  LPINTERNET_PORT* = ptr INTERNET_PORT
  INTERNET_ASYNC_RESULT* {.pure.} = object
    dwResult*: DWORD_PTR
    dwError*: DWORD
  LPINTERNET_ASYNC_RESULT* = ptr INTERNET_ASYNC_RESULT
  INTERNET_DIAGNOSTIC_SOCKET_INFO* {.pure.} = object
    Socket*: DWORD_PTR
    SourcePort*: DWORD
    DestPort*: DWORD
    Flags*: DWORD
  LPINTERNET_DIAGNOSTIC_SOCKET_INFO* = ptr INTERNET_DIAGNOSTIC_SOCKET_INFO
  INTERNET_PROXY_INFO* {.pure.} = object
    dwAccessType*: DWORD
    lpszProxy*: LPCTSTR
    lpszProxyBypass*: LPCTSTR
  LPINTERNET_PROXY_INFO* = ptr INTERNET_PROXY_INFO
  INTERNET_PER_CONN_OPTIONA_Value* {.pure, union.} = object
    dwValue*: DWORD
    pszValue*: LPSTR
    ftValue*: FILETIME
  INTERNET_PER_CONN_OPTIONA* {.pure.} = object
    dwOption*: DWORD
    Value*: INTERNET_PER_CONN_OPTIONA_Value
  LPINTERNET_PER_CONN_OPTIONA* = ptr INTERNET_PER_CONN_OPTIONA
  INTERNET_PER_CONN_OPTIONW_Value* {.pure, union.} = object
    dwValue*: DWORD
    pszValue*: LPWSTR
    ftValue*: FILETIME
  INTERNET_PER_CONN_OPTIONW* {.pure.} = object
    dwOption*: DWORD
    Value*: INTERNET_PER_CONN_OPTIONW_Value
  LPINTERNET_PER_CONN_OPTIONW* = ptr INTERNET_PER_CONN_OPTIONW
  INTERNET_PER_CONN_OPTION_LISTA* {.pure.} = object
    dwSize*: DWORD
    pszConnection*: LPSTR
    dwOptionCount*: DWORD
    dwOptionError*: DWORD
    pOptions*: LPINTERNET_PER_CONN_OPTIONA
  LPINTERNET_PER_CONN_OPTION_LISTA* = ptr INTERNET_PER_CONN_OPTION_LISTA
  INTERNET_PER_CONN_OPTION_LISTW* {.pure.} = object
    dwSize*: DWORD
    pszConnection*: LPWSTR
    dwOptionCount*: DWORD
    dwOptionError*: DWORD
    pOptions*: LPINTERNET_PER_CONN_OPTIONW
  LPINTERNET_PER_CONN_OPTION_LISTW* = ptr INTERNET_PER_CONN_OPTION_LISTW
  INTERNET_VERSION_INFO* {.pure.} = object
    dwMajorVersion*: DWORD
    dwMinorVersion*: DWORD
  LPINTERNET_VERSION_INFO* = ptr INTERNET_VERSION_INFO
  HTTP_VERSION_INFO* {.pure.} = object
    dwMajorVersion*: DWORD
    dwMinorVersion*: DWORD
  LPHTTP_VERSION_INFO* = ptr HTTP_VERSION_INFO
  INTERNET_CONNECTED_INFO* {.pure.} = object
    dwConnectedState*: DWORD
    dwFlags*: DWORD
  LPINTERNET_CONNECTED_INFO* = ptr INTERNET_CONNECTED_INFO
  URL_COMPONENTSA* {.pure.} = object
    dwStructSize*: DWORD
    lpszScheme*: LPSTR
    dwSchemeLength*: DWORD
    nScheme*: INTERNET_SCHEME
    lpszHostName*: LPSTR
    dwHostNameLength*: DWORD
    nPort*: INTERNET_PORT
    lpszUserName*: LPSTR
    dwUserNameLength*: DWORD
    lpszPassword*: LPSTR
    dwPasswordLength*: DWORD
    lpszUrlPath*: LPSTR
    dwUrlPathLength*: DWORD
    lpszExtraInfo*: LPSTR
    dwExtraInfoLength*: DWORD
  LPURL_COMPONENTSA* = ptr URL_COMPONENTSA
  URL_COMPONENTSW* {.pure.} = object
    dwStructSize*: DWORD
    lpszScheme*: LPWSTR
    dwSchemeLength*: DWORD
    nScheme*: INTERNET_SCHEME
    lpszHostName*: LPWSTR
    dwHostNameLength*: DWORD
    nPort*: INTERNET_PORT
    lpszUserName*: LPWSTR
    dwUserNameLength*: DWORD
    lpszPassword*: LPWSTR
    dwPasswordLength*: DWORD
    lpszUrlPath*: LPWSTR
    dwUrlPathLength*: DWORD
    lpszExtraInfo*: LPWSTR
    dwExtraInfoLength*: DWORD
  LPURL_COMPONENTSW* = ptr URL_COMPONENTSW
  INTERNET_CERTIFICATE_INFO* {.pure.} = object
    ftExpiry*: FILETIME
    ftStart*: FILETIME
    lpszSubjectInfo*: LPTSTR
    lpszIssuerInfo*: LPTSTR
    lpszProtocolName*: LPTSTR
    lpszSignatureAlgName*: LPTSTR
    lpszEncryptionAlgName*: LPTSTR
    dwKeySize*: DWORD
  LPINTERNET_CERTIFICATE_INFO* = ptr INTERNET_CERTIFICATE_INFO
  INTERNET_BUFFERSA* {.pure.} = object
    dwStructSize*: DWORD
    Next*: ptr INTERNET_BUFFERSA
    lpcszHeader*: LPCSTR
    dwHeadersLength*: DWORD
    dwHeadersTotal*: DWORD
    lpvBuffer*: LPVOID
    dwBufferLength*: DWORD
    dwBufferTotal*: DWORD
    dwOffsetLow*: DWORD
    dwOffsetHigh*: DWORD
  LPINTERNET_BUFFERSA* = ptr INTERNET_BUFFERSA
  INTERNET_BUFFERSW* {.pure.} = object
    dwStructSize*: DWORD
    Next*: ptr INTERNET_BUFFERSW
    lpcszHeader*: LPCWSTR
    dwHeadersLength*: DWORD
    dwHeadersTotal*: DWORD
    lpvBuffer*: LPVOID
    dwBufferLength*: DWORD
    dwBufferTotal*: DWORD
    dwOffsetLow*: DWORD
    dwOffsetHigh*: DWORD
  LPINTERNET_BUFFERSW* = ptr INTERNET_BUFFERSW
  INTERNET_STATUS_CALLBACK* = proc (hInternet: HINTERNET, dwContext: DWORD_PTR, dwInternetStatus: DWORD, lpvStatusInformation: LPVOID, dwStatusInformationLength: DWORD): VOID {.stdcall.}
  LPINTERNET_STATUS_CALLBACK* = ptr INTERNET_STATUS_CALLBACK
const
  MAX_GOPHER_DISPLAY_TEXT* = 128
  MAX_GOPHER_SELECTOR_TEXT* = 256
  INTERNET_MAX_HOST_NAME_LENGTH* = 256
  MAX_GOPHER_HOST_NAME* = INTERNET_MAX_HOST_NAME_LENGTH
  INTERNET_MAX_PORT_NUMBER_LENGTH* = 5
  MAX_GOPHER_LOCATOR_LENGTH* = 1+MAX_GOPHER_DISPLAY_TEXT+1+MAX_GOPHER_SELECTOR_TEXT+1+MAX_GOPHER_HOST_NAME+1+INTERNET_MAX_PORT_NUMBER_LENGTH+1+1+2
type
  GOPHER_FIND_DATAA* {.pure.} = object
    DisplayString*: array[MAX_GOPHER_DISPLAY_TEXT + 1, CHAR]
    GopherType*: DWORD
    SizeLow*: DWORD
    SizeHigh*: DWORD
    LastModificationTime*: FILETIME
    Locator*: array[MAX_GOPHER_LOCATOR_LENGTH + 1, CHAR]
  LPGOPHER_FIND_DATAA* = ptr GOPHER_FIND_DATAA
  GOPHER_FIND_DATAW* {.pure.} = object
    DisplayString*: array[MAX_GOPHER_DISPLAY_TEXT + 1, WCHAR]
    GopherType*: DWORD
    SizeLow*: DWORD
    SizeHigh*: DWORD
    LastModificationTime*: FILETIME
    Locator*: array[MAX_GOPHER_LOCATOR_LENGTH + 1, WCHAR]
  LPGOPHER_FIND_DATAW* = ptr GOPHER_FIND_DATAW
  GOPHER_ADMIN_ATTRIBUTE_TYPE* {.pure.} = object
    Comment*: LPCTSTR
    EmailAddress*: LPCTSTR
  LPGOPHER_ADMIN_ATTRIBUTE_TYPE* = ptr GOPHER_ADMIN_ATTRIBUTE_TYPE
  GOPHER_MOD_DATE_ATTRIBUTE_TYPE* {.pure.} = object
    DateAndTime*: FILETIME
  LPGOPHER_MOD_DATE_ATTRIBUTE_TYPE* = ptr GOPHER_MOD_DATE_ATTRIBUTE_TYPE
  GOPHER_TTL_ATTRIBUTE_TYPE* {.pure.} = object
    Ttl*: DWORD
  LPGOPHER_TTL_ATTRIBUTE_TYPE* = ptr GOPHER_TTL_ATTRIBUTE_TYPE
  GOPHER_SCORE_ATTRIBUTE_TYPE* {.pure.} = object
    Score*: INT
  LPGOPHER_SCORE_ATTRIBUTE_TYPE* = ptr GOPHER_SCORE_ATTRIBUTE_TYPE
  GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE* {.pure.} = object
    LowerBound*: INT
    UpperBound*: INT
  LPGOPHER_SCORE_RANGE_ATTRIBUTE_TYPE* = ptr GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE
  GOPHER_SITE_ATTRIBUTE_TYPE* {.pure.} = object
    Site*: LPCTSTR
  LPGOPHER_SITE_ATTRIBUTE_TYPE* = ptr GOPHER_SITE_ATTRIBUTE_TYPE
  GOPHER_ORGANIZATION_ATTRIBUTE_TYPE* {.pure.} = object
    Organization*: LPCTSTR
  LPGOPHER_ORGANIZATION_ATTRIBUTE_TYPE* = ptr GOPHER_ORGANIZATION_ATTRIBUTE_TYPE
  GOPHER_LOCATION_ATTRIBUTE_TYPE* {.pure.} = object
    Location*: LPCTSTR
  LPGOPHER_LOCATION_ATTRIBUTE_TYPE* = ptr GOPHER_LOCATION_ATTRIBUTE_TYPE
  GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE* {.pure.} = object
    DegreesNorth*: INT
    MinutesNorth*: INT
    SecondsNorth*: INT
    DegreesEast*: INT
    MinutesEast*: INT
    SecondsEast*: INT
  LPGOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE* = ptr GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE
  GOPHER_TIMEZONE_ATTRIBUTE_TYPE* {.pure.} = object
    Zone*: INT
  LPGOPHER_TIMEZONE_ATTRIBUTE_TYPE* = ptr GOPHER_TIMEZONE_ATTRIBUTE_TYPE
  GOPHER_PROVIDER_ATTRIBUTE_TYPE* {.pure.} = object
    Provider*: LPCTSTR
  LPGOPHER_PROVIDER_ATTRIBUTE_TYPE* = ptr GOPHER_PROVIDER_ATTRIBUTE_TYPE
  GOPHER_VERSION_ATTRIBUTE_TYPE* {.pure.} = object
    Version*: LPCTSTR
  LPGOPHER_VERSION_ATTRIBUTE_TYPE* = ptr GOPHER_VERSION_ATTRIBUTE_TYPE
  GOPHER_ABSTRACT_ATTRIBUTE_TYPE* {.pure.} = object
    ShortAbstract*: LPCTSTR
    AbstractFile*: LPCTSTR
  LPGOPHER_ABSTRACT_ATTRIBUTE_TYPE* = ptr GOPHER_ABSTRACT_ATTRIBUTE_TYPE
  GOPHER_VIEW_ATTRIBUTE_TYPE* {.pure.} = object
    ContentType*: LPCTSTR
    Language*: LPCTSTR
    Size*: DWORD
  LPGOPHER_VIEW_ATTRIBUTE_TYPE* = ptr GOPHER_VIEW_ATTRIBUTE_TYPE
  GOPHER_VERONICA_ATTRIBUTE_TYPE* {.pure.} = object
    TreeWalk*: WINBOOL
  LPGOPHER_VERONICA_ATTRIBUTE_TYPE* = ptr GOPHER_VERONICA_ATTRIBUTE_TYPE
  GOPHER_ASK_ATTRIBUTE_TYPE* {.pure.} = object
    QuestionType*: LPCTSTR
    QuestionText*: LPCTSTR
  LPGOPHER_ASK_ATTRIBUTE_TYPE* = ptr GOPHER_ASK_ATTRIBUTE_TYPE
  GOPHER_UNKNOWN_ATTRIBUTE_TYPE* {.pure.} = object
    Text*: LPCTSTR
  LPGOPHER_UNKNOWN_ATTRIBUTE_TYPE* = ptr GOPHER_UNKNOWN_ATTRIBUTE_TYPE
  GOPHER_ATTRIBUTE_TYPE_AttributeType* {.pure, union.} = object
    Admin*: GOPHER_ADMIN_ATTRIBUTE_TYPE
    ModDate*: GOPHER_MOD_DATE_ATTRIBUTE_TYPE
    Ttl*: GOPHER_TTL_ATTRIBUTE_TYPE
    Score*: GOPHER_SCORE_ATTRIBUTE_TYPE
    ScoreRange*: GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE
    Site*: GOPHER_SITE_ATTRIBUTE_TYPE
    Organization*: GOPHER_ORGANIZATION_ATTRIBUTE_TYPE
    Location*: GOPHER_LOCATION_ATTRIBUTE_TYPE
    GeographicalLocation*: GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE
    TimeZone*: GOPHER_TIMEZONE_ATTRIBUTE_TYPE
    Provider*: GOPHER_PROVIDER_ATTRIBUTE_TYPE
    Version*: GOPHER_VERSION_ATTRIBUTE_TYPE
    Abstract*: GOPHER_ABSTRACT_ATTRIBUTE_TYPE
    View*: GOPHER_VIEW_ATTRIBUTE_TYPE
    Veronica*: GOPHER_VERONICA_ATTRIBUTE_TYPE
    Ask*: GOPHER_ASK_ATTRIBUTE_TYPE
    Unknown*: GOPHER_UNKNOWN_ATTRIBUTE_TYPE
  GOPHER_ATTRIBUTE_TYPE* {.pure.} = object
    CategoryId*: DWORD
    AttributeId*: DWORD
    AttributeType*: GOPHER_ATTRIBUTE_TYPE_AttributeType
  LPGOPHER_ATTRIBUTE_TYPE* = ptr GOPHER_ATTRIBUTE_TYPE
  INTERNET_CACHE_ENTRY_INFOA_UNION1* {.pure, union.} = object
    dwReserved*: DWORD
    dwExemptDelta*: DWORD
  INTERNET_CACHE_ENTRY_INFOA* {.pure.} = object
    dwStructSize*: DWORD
    lpszSourceUrlName*: LPSTR
    lpszLocalFileName*: LPSTR
    CacheEntryType*: DWORD
    dwUseCount*: DWORD
    dwHitRate*: DWORD
    dwSizeLow*: DWORD
    dwSizeHigh*: DWORD
    LastModifiedTime*: FILETIME
    ExpireTime*: FILETIME
    LastAccessTime*: FILETIME
    LastSyncTime*: FILETIME
    lpHeaderInfo*: LPSTR
    dwHeaderInfoSize*: DWORD
    lpszFileExtension*: LPSTR
    union1*: INTERNET_CACHE_ENTRY_INFOA_UNION1
  LPINTERNET_CACHE_ENTRY_INFOA* = ptr INTERNET_CACHE_ENTRY_INFOA
  INTERNET_CACHE_ENTRY_INFOW_UNION1* {.pure, union.} = object
    dwReserved*: DWORD
    dwExemptDelta*: DWORD
  INTERNET_CACHE_ENTRY_INFOW* {.pure.} = object
    dwStructSize*: DWORD
    lpszSourceUrlName*: LPWSTR
    lpszLocalFileName*: LPWSTR
    CacheEntryType*: DWORD
    dwUseCount*: DWORD
    dwHitRate*: DWORD
    dwSizeLow*: DWORD
    dwSizeHigh*: DWORD
    LastModifiedTime*: FILETIME
    ExpireTime*: FILETIME
    LastAccessTime*: FILETIME
    LastSyncTime*: FILETIME
    lpHeaderInfo*: LPWSTR
    dwHeaderInfoSize*: DWORD
    lpszFileExtension*: LPWSTR
    union1*: INTERNET_CACHE_ENTRY_INFOW_UNION1
  LPINTERNET_CACHE_ENTRY_INFOW* = ptr INTERNET_CACHE_ENTRY_INFOW
  INTERNET_CACHE_TIMESTAMPS* {.pure.} = object
    ftExpires*: FILETIME
    ftLastModified*: FILETIME
  LPINTERNET_CACHE_TIMESTAMPS* = ptr INTERNET_CACHE_TIMESTAMPS
const
  GROUP_OWNER_STORAGE_SIZE* = 4
  GROUPNAME_MAX_LENGTH* = 120
type
  INTERNET_CACHE_GROUP_INFOA* {.pure.} = object
    dwGroupSize*: DWORD
    dwGroupFlags*: DWORD
    dwGroupType*: DWORD
    dwDiskUsage*: DWORD
    dwDiskQuota*: DWORD
    dwOwnerStorage*: array[GROUP_OWNER_STORAGE_SIZE, DWORD]
    szGroupName*: array[GROUPNAME_MAX_LENGTH, CHAR]
  LPINTERNET_CACHE_GROUP_INFOA* = ptr INTERNET_CACHE_GROUP_INFOA
  INTERNET_CACHE_GROUP_INFOW* {.pure.} = object
    dwGroupSize*: DWORD
    dwGroupFlags*: DWORD
    dwGroupType*: DWORD
    dwDiskUsage*: DWORD
    dwDiskQuota*: DWORD
    dwOwnerStorage*: array[GROUP_OWNER_STORAGE_SIZE, DWORD]
    szGroupName*: array[GROUPNAME_MAX_LENGTH, WCHAR]
  LPINTERNET_CACHE_GROUP_INFOW* = ptr INTERNET_CACHE_GROUP_INFOW
  AUTO_PROXY_SCRIPT_BUFFER* {.pure.} = object
    dwStructSize*: DWORD
    lpszScriptBuffer*: LPSTR
    dwScriptBufferSize*: DWORD
  LPAUTO_PROXY_SCRIPT_BUFFER* = ptr AUTO_PROXY_SCRIPT_BUFFER
const
  INTERNET_INVALID_PORT_NUMBER* = 0
  INTERNET_DEFAULT_FTP_PORT* = 21
  INTERNET_DEFAULT_GOPHER_PORT* = 70
  INTERNET_DEFAULT_HTTP_PORT* = 80
  INTERNET_DEFAULT_HTTPS_PORT* = 443
  INTERNET_DEFAULT_SOCKS_PORT* = 1080
  INTERNET_MAX_USER_NAME_LENGTH* = 128
  INTERNET_MAX_PASSWORD_LENGTH* = 128
  INTERNET_MAX_PORT_NUMBER_VALUE* = 65535
  INTERNET_MAX_PATH_LENGTH* = 2048
  INTERNET_MAX_SCHEME_LENGTH* = 32
  INTERNET_KEEP_ALIVE_UNKNOWN* = DWORD(-1)
  INTERNET_KEEP_ALIVE_ENABLED* = 1
  INTERNET_KEEP_ALIVE_DISABLED* = 0
  INTERNET_REQFLAG_FROM_CACHE* = 0x00000001
  INTERNET_REQFLAG_ASYNC* = 0x00000002
  INTERNET_REQFLAG_VIA_PROXY* = 0x00000004
  INTERNET_REQFLAG_NO_HEADERS* = 0x00000008
  INTERNET_REQFLAG_PASSIVE* = 0x00000010
  INTERNET_REQFLAG_CACHE_WRITE_DISABLED* = 0x00000040
  INTERNET_REQFLAG_NET_TIMEOUT* = 0x00000080
  INTERNET_FLAG_RELOAD* = 0x80000000'i32
  INTERNET_FLAG_RAW_DATA* = 0x40000000
  INTERNET_FLAG_EXISTING_CONNECT* = 0x20000000
  INTERNET_FLAG_ASYNC* = 0x10000000
  INTERNET_FLAG_PASSIVE* = 0x08000000
  INTERNET_FLAG_NO_CACHE_WRITE* = 0x04000000
  INTERNET_FLAG_DONT_CACHE* = INTERNET_FLAG_NO_CACHE_WRITE
  INTERNET_FLAG_MAKE_PERSISTENT* = 0x02000000
  INTERNET_FLAG_FROM_CACHE* = 0x01000000
  INTERNET_FLAG_OFFLINE* = INTERNET_FLAG_FROM_CACHE
  INTERNET_FLAG_SECURE* = 0x00800000
  INTERNET_FLAG_KEEP_CONNECTION* = 0x00400000
  INTERNET_FLAG_NO_AUTO_REDIRECT* = 0x00200000
  INTERNET_FLAG_READ_PREFETCH* = 0x00100000
  INTERNET_FLAG_NO_COOKIES* = 0x00080000
  INTERNET_FLAG_NO_AUTH* = 0x00040000
  INTERNET_FLAG_RESTRICTED_ZONE* = 0x00020000
  INTERNET_FLAG_CACHE_IF_NET_FAIL* = 0x00010000
  INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP* = 0x00008000
  INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS* = 0x00004000
  INTERNET_FLAG_IGNORE_CERT_DATE_INVALID* = 0x00002000
  INTERNET_FLAG_IGNORE_CERT_CN_INVALID* = 0x00001000
  INTERNET_FLAG_RESYNCHRONIZE* = 0x00000800
  INTERNET_FLAG_HYPERLINK* = 0x00000400
  INTERNET_FLAG_NO_UI* = 0x00000200
  INTERNET_FLAG_PRAGMA_NOCACHE* = 0x00000100
  INTERNET_FLAG_CACHE_ASYNC* = 0x00000080
  INTERNET_FLAG_FORMS_SUBMIT* = 0x00000040
  INTERNET_FLAG_FWD_BACK* = 0x00000020
  INTERNET_FLAG_NEED_FILE* = 0x00000010
  INTERNET_FLAG_MUST_CACHE_REQUEST* = INTERNET_FLAG_NEED_FILE
  FTP_TRANSFER_TYPE_ASCII* = 0x00000001
  INTERNET_FLAG_TRANSFER_ASCII* = FTP_TRANSFER_TYPE_ASCII
  FTP_TRANSFER_TYPE_BINARY* = 0x00000002
  INTERNET_FLAG_TRANSFER_BINARY* = FTP_TRANSFER_TYPE_BINARY
  SECURITY_INTERNET_MASK* = INTERNET_FLAG_IGNORE_CERT_CN_INVALID or INTERNET_FLAG_IGNORE_CERT_DATE_INVALID or INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS or INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP
  INTERNET_FLAG_BGUPDATE* = 8
  INTERNET_FLAGS_MASK* = INTERNET_FLAG_RELOAD or INTERNET_FLAG_RAW_DATA or INTERNET_FLAG_EXISTING_CONNECT or INTERNET_FLAG_ASYNC or INTERNET_FLAG_PASSIVE or INTERNET_FLAG_NO_CACHE_WRITE or INTERNET_FLAG_MAKE_PERSISTENT or INTERNET_FLAG_FROM_CACHE or INTERNET_FLAG_SECURE or INTERNET_FLAG_KEEP_CONNECTION or INTERNET_FLAG_NO_AUTO_REDIRECT or INTERNET_FLAG_READ_PREFETCH or INTERNET_FLAG_NO_COOKIES or INTERNET_FLAG_NO_AUTH or INTERNET_FLAG_CACHE_IF_NET_FAIL or SECURITY_INTERNET_MASK or INTERNET_FLAG_RESYNCHRONIZE or INTERNET_FLAG_HYPERLINK or INTERNET_FLAG_NO_UI or INTERNET_FLAG_PRAGMA_NOCACHE or INTERNET_FLAG_CACHE_ASYNC or INTERNET_FLAG_FORMS_SUBMIT or INTERNET_FLAG_NEED_FILE or INTERNET_FLAG_RESTRICTED_ZONE or INTERNET_FLAG_TRANSFER_BINARY or INTERNET_FLAG_TRANSFER_ASCII or INTERNET_FLAG_FWD_BACK or INTERNET_FLAG_BGUPDATE
  INTERNET_ERROR_MASK_INSERT_CDROM* = 0x1
  INTERNET_ERROR_MASK_COMBINED_SEC_CERT* = 0x2
  INTERNET_ERROR_MASK_NEED_MSN_SSPI_PKG* = 0X4
  INTERNET_ERROR_MASK_LOGIN_FAILURE_DISPLAY_ENTITY_BODY* = 0x8
  INTERNET_OPTIONS_MASK* = not INTERNET_FLAGS_MASK
  WININET_API_FLAG_ASYNC* = 0x00000001
  WININET_API_FLAG_SYNC* = 0x00000004
  WININET_API_FLAG_USE_CONTEXT* = 0x00000008
  INTERNET_NO_CALLBACK* = 0
  INTERNET_SCHEME_PARTIAL* = -2
  INTERNET_SCHEME_UNKNOWN* = -1
  INTERNET_SCHEME_DEFAULT* = 0
  INTERNET_SCHEME_FTP* = 1
  INTERNET_SCHEME_GOPHER* = 2
  INTERNET_SCHEME_HTTP* = 3
  INTERNET_SCHEME_HTTPS* = 4
  INTERNET_SCHEME_FILE* = 5
  INTERNET_SCHEME_NEWS* = 6
  INTERNET_SCHEME_MAILTO* = 7
  INTERNET_SCHEME_SOCKS* = 8
  INTERNET_SCHEME_JAVASCRIPT* = 9
  INTERNET_SCHEME_VBSCRIPT* = 10
  INTERNET_SCHEME_RES* = 11
  INTERNET_SCHEME_FIRST* = INTERNET_SCHEME_FTP
  INTERNET_SCHEME_LAST* = INTERNET_SCHEME_RES
  IDSI_FLAG_KEEP_ALIVE* = 0x00000001
  IDSI_FLAG_SECURE* = 0x00000002
  IDSI_FLAG_PROXY* = 0x00000004
  IDSI_FLAG_TUNNEL* = 0x00000008
  INTERNET_PER_CONN_FLAGS* = 1
  INTERNET_PER_CONN_PROXY_SERVER* = 2
  INTERNET_PER_CONN_PROXY_BYPASS* = 3
  INTERNET_PER_CONN_AUTOCONFIG_URL* = 4
  INTERNET_PER_CONN_AUTODISCOVERY_FLAGS* = 5
  INTERNET_PER_CONN_AUTOCONFIG_SECONDARY_URL* = 6
  INTERNET_PER_CONN_AUTOCONFIG_RELOAD_DELAY_MINS* = 7
  INTERNET_PER_CONN_AUTOCONFIG_LAST_DETECT_TIME* = 8
  INTERNET_PER_CONN_AUTOCONFIG_LAST_DETECT_URL* = 9
  INTERNET_PER_CONN_FLAGS_UI* = 10
  PROXY_TYPE_DIRECT* = 0x00000001
  PROXY_TYPE_PROXY* = 0x00000002
  PROXY_TYPE_AUTO_PROXY_URL* = 0x00000004
  PROXY_TYPE_AUTO_DETECT* = 0x00000008
  AUTO_PROXY_FLAG_USER_SET* = 0x00000001
  AUTO_PROXY_FLAG_ALWAYS_DETECT* = 0x00000002
  AUTO_PROXY_FLAG_DETECTION_RUN* = 0x00000004
  AUTO_PROXY_FLAG_MIGRATED* = 0x00000008
  AUTO_PROXY_FLAG_DONT_CACHE_PROXY_RESULT* = 0x00000010
  AUTO_PROXY_FLAG_CACHE_INIT_RUN* = 0x00000020
  AUTO_PROXY_FLAG_DETECTION_SUSPECT* = 0x00000040
  ISO_FORCE_DISCONNECTED* = 0x00000001
  INTERNET_RFC1123_FORMAT* = 0
  INTERNET_RFC1123_BUFSIZE* = 30
  ICU_ESCAPE* = 0x80000000'i32
  ICU_USERNAME* = 0x40000000
  ICU_NO_ENCODE* = 0x20000000
  ICU_DECODE* = 0x10000000
  ICU_NO_META* = 0x08000000
  ICU_ENCODE_SPACES_ONLY* = 0x04000000
  ICU_BROWSER_MODE* = 0x02000000
  ICU_ENCODE_PERCENT* = 0x00001000
  INTERNET_OPEN_TYPE_PRECONFIG* = 0
  INTERNET_OPEN_TYPE_DIRECT* = 1
  INTERNET_OPEN_TYPE_PROXY* = 3
  INTERNET_OPEN_TYPE_PRECONFIG_WITH_NO_AUTOPROXY* = 4
  PRE_CONFIG_INTERNET_ACCESS* = INTERNET_OPEN_TYPE_PRECONFIG
  LOCAL_INTERNET_ACCESS* = INTERNET_OPEN_TYPE_DIRECT
  CERN_PROXY_INTERNET_ACCESS* = INTERNET_OPEN_TYPE_PROXY
  INTERNET_SERVICE_FTP* = 1
  INTERNET_SERVICE_GOPHER* = 2
  INTERNET_SERVICE_HTTP* = 3
  IRF_ASYNC* = WININET_API_FLAG_ASYNC
  IRF_SYNC* = WININET_API_FLAG_SYNC
  IRF_USE_CONTEXT* = WININET_API_FLAG_USE_CONTEXT
  IRF_NO_WAIT* = 0x00000008
  ISO_GLOBAL* = 0x00000001
  ISO_REGISTRY* = 0x00000002
  ISO_VALID_FLAGS* = ISO_GLOBAL or ISO_REGISTRY
  INTERNET_OPTION_CALLBACK* = 1
  INTERNET_OPTION_CONNECT_TIMEOUT* = 2
  INTERNET_OPTION_CONNECT_RETRIES* = 3
  INTERNET_OPTION_CONNECT_BACKOFF* = 4
  INTERNET_OPTION_SEND_TIMEOUT* = 5
  INTERNET_OPTION_CONTROL_SEND_TIMEOUT* = INTERNET_OPTION_SEND_TIMEOUT
  INTERNET_OPTION_RECEIVE_TIMEOUT* = 6
  INTERNET_OPTION_CONTROL_RECEIVE_TIMEOUT* = INTERNET_OPTION_RECEIVE_TIMEOUT
  INTERNET_OPTION_DATA_SEND_TIMEOUT* = 7
  INTERNET_OPTION_DATA_RECEIVE_TIMEOUT* = 8
  INTERNET_OPTION_HANDLE_TYPE* = 9
  INTERNET_OPTION_LISTEN_TIMEOUT* = 11
  INTERNET_OPTION_READ_BUFFER_SIZE* = 12
  INTERNET_OPTION_WRITE_BUFFER_SIZE* = 13
  INTERNET_OPTION_ASYNC_ID* = 15
  INTERNET_OPTION_ASYNC_PRIORITY* = 16
  INTERNET_OPTION_PARENT_HANDLE* = 21
  INTERNET_OPTION_KEEP_CONNECTION* = 22
  INTERNET_OPTION_REQUEST_FLAGS* = 23
  INTERNET_OPTION_EXTENDED_ERROR* = 24
  INTERNET_OPTION_OFFLINE_MODE* = 26
  INTERNET_OPTION_CACHE_STREAM_HANDLE* = 27
  INTERNET_OPTION_USERNAME* = 28
  INTERNET_OPTION_PASSWORD* = 29
  INTERNET_OPTION_ASYNC* = 30
  INTERNET_OPTION_SECURITY_FLAGS* = 31
  INTERNET_OPTION_SECURITY_CERTIFICATE_STRUCT* = 32
  INTERNET_OPTION_DATAFILE_NAME* = 33
  INTERNET_OPTION_URL* = 34
  INTERNET_OPTION_SECURITY_CERTIFICATE* = 35
  INTERNET_OPTION_SECURITY_KEY_BITNESS* = 36
  INTERNET_OPTION_REFRESH* = 37
  INTERNET_OPTION_PROXY* = 38
  INTERNET_OPTION_SETTINGS_CHANGED* = 39
  INTERNET_OPTION_VERSION* = 40
  INTERNET_OPTION_USER_AGENT* = 41
  INTERNET_OPTION_END_BROWSER_SESSION* = 42
  INTERNET_OPTION_PROXY_USERNAME* = 43
  INTERNET_OPTION_PROXY_PASSWORD* = 44
  INTERNET_OPTION_CONTEXT_VALUE* = 45
  INTERNET_OPTION_CONNECT_LIMIT* = 46
  INTERNET_OPTION_SECURITY_SELECT_CLIENT_CERT* = 47
  INTERNET_OPTION_POLICY* = 48
  INTERNET_OPTION_DISCONNECTED_TIMEOUT* = 49
  INTERNET_OPTION_CONNECTED_STATE* = 50
  INTERNET_OPTION_IDLE_STATE* = 51
  INTERNET_OPTION_OFFLINE_SEMANTICS* = 52
  INTERNET_OPTION_SECONDARY_CACHE_KEY* = 53
  INTERNET_OPTION_CALLBACK_FILTER* = 54
  INTERNET_OPTION_CONNECT_TIME* = 55
  INTERNET_OPTION_SEND_THROUGHPUT* = 56
  INTERNET_OPTION_RECEIVE_THROUGHPUT* = 57
  INTERNET_OPTION_REQUEST_PRIORITY* = 58
  INTERNET_OPTION_HTTP_VERSION* = 59
  INTERNET_OPTION_RESET_URLCACHE_SESSION* = 60
  INTERNET_OPTION_ERROR_MASK* = 62
  INTERNET_OPTION_FROM_CACHE_TIMEOUT* = 63
  INTERNET_OPTION_BYPASS_EDITED_ENTRY* = 64
  INTERNET_OPTION_DIAGNOSTIC_SOCKET_INFO* = 67
  INTERNET_OPTION_CODEPAGE* = 68
  INTERNET_OPTION_CACHE_TIMESTAMPS* = 69
  INTERNET_OPTION_DISABLE_AUTODIAL* = 70
  INTERNET_OPTION_MAX_CONNS_PER_SERVER* = 73
  INTERNET_OPTION_MAX_CONNS_PER_1_0_SERVER* = 74
  INTERNET_OPTION_PER_CONNECTION_OPTION* = 75
  INTERNET_OPTION_DIGEST_AUTH_UNLOAD* = 76
  INTERNET_OPTION_IGNORE_OFFLINE* = 77
  INTERNET_OPTION_IDENTITY* = 78
  INTERNET_OPTION_REMOVE_IDENTITY* = 79
  INTERNET_OPTION_ALTER_IDENTITY* = 80
  INTERNET_OPTION_SUPPRESS_BEHAVIOR* = 81
  INTERNET_OPTION_AUTODIAL_MODE* = 82
  INTERNET_OPTION_AUTODIAL_CONNECTION* = 83
  INTERNET_OPTION_CLIENT_CERT_CONTEXT* = 84
  INTERNET_OPTION_AUTH_FLAGS* = 85
  INTERNET_OPTION_COOKIES_3RD_PARTY* = 86
  INTERNET_OPTION_DISABLE_PASSPORT_AUTH* = 87
  INTERNET_OPTION_SEND_UTF8_SERVERNAME_TO_PROXY* = 88
  INTERNET_OPTION_EXEMPT_CONNECTION_LIMIT* = 89
  INTERNET_OPTION_ENABLE_PASSPORT_AUTH* = 90
  INTERNET_OPTION_HIBERNATE_INACTIVE_WORKER_THREADS* = 91
  INTERNET_OPTION_ACTIVATE_WORKER_THREADS* = 92
  INTERNET_OPTION_RESTORE_WORKER_THREAD_DEFAULTS* = 93
  INTERNET_OPTION_SOCKET_SEND_BUFFER_LENGTH* = 94
  INTERNET_OPTION_PROXY_SETTINGS_CHANGED* = 95
  INTERNET_OPTION_DATAFILE_EXT* = 96
  INTERNET_FIRST_OPTION* = INTERNET_OPTION_CALLBACK
  INTERNET_LAST_OPTION* = INTERNET_OPTION_DATAFILE_EXT
  INTERNET_PRIORITY_FOREGROUND* = 1000
  INTERNET_HANDLE_TYPE_INTERNET* = 1
  INTERNET_HANDLE_TYPE_CONNECT_FTP* = 2
  INTERNET_HANDLE_TYPE_CONNECT_GOPHER* = 3
  INTERNET_HANDLE_TYPE_CONNECT_HTTP* = 4
  INTERNET_HANDLE_TYPE_FTP_FIND* = 5
  INTERNET_HANDLE_TYPE_FTP_FIND_HTML* = 6
  INTERNET_HANDLE_TYPE_FTP_FILE* = 7
  INTERNET_HANDLE_TYPE_FTP_FILE_HTML* = 8
  INTERNET_HANDLE_TYPE_GOPHER_FIND* = 9
  INTERNET_HANDLE_TYPE_GOPHER_FIND_HTML* = 10
  INTERNET_HANDLE_TYPE_GOPHER_FILE* = 11
  INTERNET_HANDLE_TYPE_GOPHER_FILE_HTML* = 12
  INTERNET_HANDLE_TYPE_HTTP_REQUEST* = 13
  INTERNET_HANDLE_TYPE_FILE_REQUEST* = 14
  AUTH_FLAG_DISABLE_NEGOTIATE* = 0x00000001
  AUTH_FLAG_ENABLE_NEGOTIATE* = 0x00000002
  AUTH_FLAG_DISABLE_BASIC_CLEARCHANNEL* = 0x00000004
  SECURITY_FLAG_SECURE* = 0x00000001
  SECURITY_FLAG_STRENGTH_WEAK* = 0x10000000
  SECURITY_FLAG_STRENGTH_MEDIUM* = 0x40000000
  SECURITY_FLAG_STRENGTH_STRONG* = 0x20000000
  SECURITY_FLAG_UNKNOWNBIT* = 0x80000000'i32
  SECURITY_FLAG_FORTEZZA* = 0x08000000
  SECURITY_FLAG_NORMALBITNESS* = SECURITY_FLAG_STRENGTH_WEAK
  SECURITY_FLAG_SSL* = 0x00000002
  SECURITY_FLAG_SSL3* = 0x00000004
  SECURITY_FLAG_PCT* = 0x00000008
  SECURITY_FLAG_PCT4* = 0x00000010
  SECURITY_FLAG_IETFSSL4* = 0x00000020
  SECURITY_FLAG_40BIT* = SECURITY_FLAG_STRENGTH_WEAK
  SECURITY_FLAG_128BIT* = SECURITY_FLAG_STRENGTH_STRONG
  SECURITY_FLAG_56BIT* = SECURITY_FLAG_STRENGTH_MEDIUM
  SECURITY_FLAG_IGNORE_REVOCATION* = 0x00000080
  SECURITY_FLAG_IGNORE_UNKNOWN_CA* = 0x00000100
  SECURITY_FLAG_IGNORE_WRONG_USAGE* = 0x00000200
  SECURITY_FLAG_IGNORE_CERT_CN_INVALID* = INTERNET_FLAG_IGNORE_CERT_CN_INVALID
  SECURITY_FLAG_IGNORE_CERT_DATE_INVALID* = INTERNET_FLAG_IGNORE_CERT_DATE_INVALID
  SECURITY_FLAG_IGNORE_REDIRECT_TO_HTTPS* = INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS
  SECURITY_FLAG_IGNORE_REDIRECT_TO_HTTP* = INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP
  SECURITY_SET_MASK* = SECURITY_FLAG_IGNORE_REVOCATION or SECURITY_FLAG_IGNORE_UNKNOWN_CA or SECURITY_FLAG_IGNORE_CERT_CN_INVALID or SECURITY_FLAG_IGNORE_CERT_DATE_INVALID or SECURITY_FLAG_IGNORE_WRONG_USAGE
  AUTODIAL_MODE_NEVER* = 1
  AUTODIAL_MODE_ALWAYS* = 2
  AUTODIAL_MODE_NO_NETWORK_PRESENT* = 4
  INTERNET_STATUS_RESOLVING_NAME* = 10
  INTERNET_STATUS_NAME_RESOLVED* = 11
  INTERNET_STATUS_CONNECTING_TO_SERVER* = 20
  INTERNET_STATUS_CONNECTED_TO_SERVER* = 21
  INTERNET_STATUS_SENDING_REQUEST* = 30
  INTERNET_STATUS_REQUEST_SENT* = 31
  INTERNET_STATUS_RECEIVING_RESPONSE* = 40
  INTERNET_STATUS_RESPONSE_RECEIVED* = 41
  INTERNET_STATUS_CTL_RESPONSE_RECEIVED* = 42
  INTERNET_STATUS_PREFETCH* = 43
  INTERNET_STATUS_CLOSING_CONNECTION* = 50
  INTERNET_STATUS_CONNECTION_CLOSED* = 51
  INTERNET_STATUS_HANDLE_CREATED* = 60
  INTERNET_STATUS_HANDLE_CLOSING* = 70
  INTERNET_STATUS_DETECTING_PROXY* = 80
  INTERNET_STATUS_REQUEST_COMPLETE* = 100
  INTERNET_STATUS_REDIRECT* = 110
  INTERNET_STATUS_INTERMEDIATE_RESPONSE* = 120
  INTERNET_STATUS_USER_INPUT_REQUIRED* = 140
  INTERNET_STATUS_STATE_CHANGE* = 200
  INTERNET_STATUS_COOKIE_SENT* = 320
  INTERNET_STATUS_COOKIE_RECEIVED* = 321
  INTERNET_STATUS_PRIVACY_IMPACTED* = 324
  INTERNET_STATUS_P3P_HEADER* = 325
  INTERNET_STATUS_P3P_POLICYREF* = 326
  INTERNET_STATUS_COOKIE_HISTORY* = 327
  INTERNET_STATE_CONNECTED* = 0x00000001
  INTERNET_STATE_DISCONNECTED* = 0x00000002
  INTERNET_STATE_DISCONNECTED_BY_USER* = 0x00000010
  INTERNET_STATE_IDLE* = 0x00000100
  INTERNET_STATE_BUSY* = 0x00000200
  COOKIE_STATE_UNKNOWN* = 0x0
  COOKIE_STATE_ACCEPT* = 0x1
  COOKIE_STATE_PROMPT* = 0x2
  COOKIE_STATE_LEASH* = 0x3
  COOKIE_STATE_DOWNGRADE* = 0x4
  COOKIE_STATE_REJECT* = 0x5
  COOKIE_STATE_MAX* = COOKIE_STATE_REJECT
  FTP_TRANSFER_TYPE_UNKNOWN* = 0x00000000
  FTP_TRANSFER_TYPE_MASK* = FTP_TRANSFER_TYPE_ASCII or FTP_TRANSFER_TYPE_BINARY
  GOPHER_TYPE_TEXT_FILE* = 0x00000001
  GOPHER_TYPE_DIRECTORY* = 0x00000002
  GOPHER_TYPE_CSO* = 0x00000004
  GOPHER_TYPE_ERROR* = 0x00000008
  GOPHER_TYPE_MAC_BINHEX* = 0x00000010
  GOPHER_TYPE_DOS_ARCHIVE* = 0x00000020
  GOPHER_TYPE_UNIX_UUENCODED* = 0x00000040
  GOPHER_TYPE_INDEX_SERVER* = 0x00000080
  GOPHER_TYPE_TELNET* = 0x00000100
  GOPHER_TYPE_BINARY* = 0x00000200
  GOPHER_TYPE_REDUNDANT* = 0x00000400
  GOPHER_TYPE_TN3270* = 0x00000800
  GOPHER_TYPE_GIF* = 0x00001000
  GOPHER_TYPE_IMAGE* = 0x00002000
  GOPHER_TYPE_BITMAP* = 0x00004000
  GOPHER_TYPE_MOVIE* = 0x00008000
  GOPHER_TYPE_SOUND* = 0x00010000
  GOPHER_TYPE_HTML* = 0x00020000
  GOPHER_TYPE_PDF* = 0x00040000
  GOPHER_TYPE_CALENDAR* = 0x00080000
  GOPHER_TYPE_INLINE* = 0x00100000
  GOPHER_TYPE_UNKNOWN* = 0x20000000
  GOPHER_TYPE_ASK* = 0x40000000
  GOPHER_TYPE_GOPHER_PLUS* = 0x80000000'i32
  GOPHER_TYPE_FILE_MASK* = GOPHER_TYPE_TEXT_FILE or GOPHER_TYPE_MAC_BINHEX or GOPHER_TYPE_DOS_ARCHIVE or GOPHER_TYPE_UNIX_UUENCODED or GOPHER_TYPE_BINARY or GOPHER_TYPE_GIF or GOPHER_TYPE_IMAGE or GOPHER_TYPE_BITMAP or GOPHER_TYPE_MOVIE or GOPHER_TYPE_SOUND or GOPHER_TYPE_HTML or GOPHER_TYPE_PDF or GOPHER_TYPE_CALENDAR or GOPHER_TYPE_INLINE
  MAX_GOPHER_CATEGORY_NAME* = 128
  MAX_GOPHER_ATTRIBUTE_NAME* = 128
  MIN_GOPHER_ATTRIBUTE_LENGTH* = 256
  GOPHER_INFO_CATEGORY* = "+INFO"
  GOPHER_ADMIN_CATEGORY* = "+ADMIN"
  GOPHER_VIEWS_CATEGORY* = "+VIEWS"
  GOPHER_ABSTRACT_CATEGORY* = "+ABSTRACT"
  GOPHER_VERONICA_CATEGORY* = "+VERONICA"
  GOPHER_ADMIN_ATTRIBUTE* = "Admin"
  GOPHER_MOD_DATE_ATTRIBUTE* = "Mod-Date"
  GOPHER_TTL_ATTRIBUTE* = "TT"
  GOPHER_SCORE_ATTRIBUTE* = "Score"
  GOPHER_RANGE_ATTRIBUTE* = "Score-range"
  GOPHER_SITE_ATTRIBUTE* = "Site"
  GOPHER_ORG_ATTRIBUTE* = "Org"
  GOPHER_LOCATION_ATTRIBUTE* = "Loc"
  GOPHER_GEOG_ATTRIBUTE* = "Geog"
  GOPHER_TIMEZONE_ATTRIBUTE* = "TZ"
  GOPHER_PROVIDER_ATTRIBUTE* = "Provider"
  GOPHER_VERSION_ATTRIBUTE* = "Version"
  GOPHER_ABSTRACT_ATTRIBUTE* = "Abstract"
  GOPHER_VIEW_ATTRIBUTE* = "View"
  GOPHER_TREEWALK_ATTRIBUTE* = "treewalk"
  GOPHER_ATTRIBUTE_ID_BASE* = 0xabcccc00'i32
  GOPHER_CATEGORY_ID_ALL* = GOPHER_ATTRIBUTE_ID_BASE+1
  GOPHER_CATEGORY_ID_INFO* = GOPHER_ATTRIBUTE_ID_BASE+2
  GOPHER_CATEGORY_ID_ADMIN* = GOPHER_ATTRIBUTE_ID_BASE+3
  GOPHER_CATEGORY_ID_VIEWS* = GOPHER_ATTRIBUTE_ID_BASE+4
  GOPHER_CATEGORY_ID_ABSTRACT* = GOPHER_ATTRIBUTE_ID_BASE+5
  GOPHER_CATEGORY_ID_VERONICA* = GOPHER_ATTRIBUTE_ID_BASE+6
  GOPHER_CATEGORY_ID_ASK* = GOPHER_ATTRIBUTE_ID_BASE+7
  GOPHER_CATEGORY_ID_UNKNOWN* = GOPHER_ATTRIBUTE_ID_BASE+8
  GOPHER_ATTRIBUTE_ID_ALL* = GOPHER_ATTRIBUTE_ID_BASE+9
  GOPHER_ATTRIBUTE_ID_ADMIN* = GOPHER_ATTRIBUTE_ID_BASE+10
  GOPHER_ATTRIBUTE_ID_MOD_DATE* = GOPHER_ATTRIBUTE_ID_BASE+11
  GOPHER_ATTRIBUTE_ID_TTL* = GOPHER_ATTRIBUTE_ID_BASE+12
  GOPHER_ATTRIBUTE_ID_SCORE* = GOPHER_ATTRIBUTE_ID_BASE+13
  GOPHER_ATTRIBUTE_ID_RANGE* = GOPHER_ATTRIBUTE_ID_BASE+14
  GOPHER_ATTRIBUTE_ID_SITE* = GOPHER_ATTRIBUTE_ID_BASE+15
  GOPHER_ATTRIBUTE_ID_ORG* = GOPHER_ATTRIBUTE_ID_BASE+16
  GOPHER_ATTRIBUTE_ID_LOCATION* = GOPHER_ATTRIBUTE_ID_BASE+17
  GOPHER_ATTRIBUTE_ID_GEOG* = GOPHER_ATTRIBUTE_ID_BASE+18
  GOPHER_ATTRIBUTE_ID_TIMEZONE* = GOPHER_ATTRIBUTE_ID_BASE+19
  GOPHER_ATTRIBUTE_ID_PROVIDER* = GOPHER_ATTRIBUTE_ID_BASE+20
  GOPHER_ATTRIBUTE_ID_VERSION* = GOPHER_ATTRIBUTE_ID_BASE+21
  GOPHER_ATTRIBUTE_ID_ABSTRACT* = GOPHER_ATTRIBUTE_ID_BASE+22
  GOPHER_ATTRIBUTE_ID_VIEW* = GOPHER_ATTRIBUTE_ID_BASE+23
  GOPHER_ATTRIBUTE_ID_TREEWALK* = GOPHER_ATTRIBUTE_ID_BASE+24
  GOPHER_ATTRIBUTE_ID_UNKNOWN* = GOPHER_ATTRIBUTE_ID_BASE+25
  HTTP_MAJOR_VERSION* = 1
  HTTP_MINOR_VERSION* = 0
  HTTP_QUERY_MIME_VERSION* = 0
  HTTP_QUERY_CONTENT_TYPE* = 1
  HTTP_QUERY_CONTENT_TRANSFER_ENCODING* = 2
  HTTP_QUERY_CONTENT_ID* = 3
  HTTP_QUERY_CONTENT_DESCRIPTION* = 4
  HTTP_QUERY_CONTENT_LENGTH* = 5
  HTTP_QUERY_CONTENT_LANGUAGE* = 6
  HTTP_QUERY_ALLOW* = 7
  HTTP_QUERY_PUBLIC* = 8
  HTTP_QUERY_DATE* = 9
  HTTP_QUERY_EXPIRES* = 10
  HTTP_QUERY_LAST_MODIFIED* = 11
  HTTP_QUERY_MESSAGE_ID* = 12
  HTTP_QUERY_URI* = 13
  HTTP_QUERY_DERIVED_FROM* = 14
  HTTP_QUERY_COST* = 15
  HTTP_QUERY_LINK* = 16
  HTTP_QUERY_PRAGMA* = 17
  HTTP_QUERY_VERSION* = 18
  HTTP_QUERY_STATUS_CODE* = 19
  HTTP_QUERY_STATUS_TEXT* = 20
  HTTP_QUERY_RAW_HEADERS* = 21
  HTTP_QUERY_RAW_HEADERS_CRLF* = 22
  HTTP_QUERY_CONNECTION* = 23
  HTTP_QUERY_ACCEPT* = 24
  HTTP_QUERY_ACCEPT_CHARSET* = 25
  HTTP_QUERY_ACCEPT_ENCODING* = 26
  HTTP_QUERY_ACCEPT_LANGUAGE* = 27
  HTTP_QUERY_AUTHORIZATION* = 28
  HTTP_QUERY_CONTENT_ENCODING* = 29
  HTTP_QUERY_FORWARDED* = 30
  HTTP_QUERY_FROM* = 31
  HTTP_QUERY_IF_MODIFIED_SINCE* = 32
  HTTP_QUERY_LOCATION* = 33
  HTTP_QUERY_ORIG_URI* = 34
  HTTP_QUERY_REFERER* = 35
  HTTP_QUERY_RETRY_AFTER* = 36
  HTTP_QUERY_SERVER* = 37
  HTTP_QUERY_TITLE* = 38
  HTTP_QUERY_USER_AGENT* = 39
  HTTP_QUERY_WWW_AUTHENTICATE* = 40
  HTTP_QUERY_PROXY_AUTHENTICATE* = 41
  HTTP_QUERY_ACCEPT_RANGES* = 42
  HTTP_QUERY_SET_COOKIE* = 43
  HTTP_QUERY_COOKIE* = 44
  HTTP_QUERY_REQUEST_METHOD* = 45
  HTTP_QUERY_REFRESH* = 46
  HTTP_QUERY_CONTENT_DISPOSITION* = 47
  HTTP_QUERY_AGE* = 48
  HTTP_QUERY_CACHE_CONTROL* = 49
  HTTP_QUERY_CONTENT_BASE* = 50
  HTTP_QUERY_CONTENT_LOCATION* = 51
  HTTP_QUERY_CONTENT_MD5* = 52
  HTTP_QUERY_CONTENT_RANGE* = 53
  HTTP_QUERY_ETAG* = 54
  HTTP_QUERY_HOST* = 55
  HTTP_QUERY_IF_MATCH* = 56
  HTTP_QUERY_IF_NONE_MATCH* = 57
  HTTP_QUERY_IF_RANGE* = 58
  HTTP_QUERY_IF_UNMODIFIED_SINCE* = 59
  HTTP_QUERY_MAX_FORWARDS* = 60
  HTTP_QUERY_PROXY_AUTHORIZATION* = 61
  HTTP_QUERY_RANGE* = 62
  HTTP_QUERY_TRANSFER_ENCODING* = 63
  HTTP_QUERY_UPGRADE* = 64
  HTTP_QUERY_VARY* = 65
  HTTP_QUERY_VIA* = 66
  HTTP_QUERY_WARNING* = 67
  HTTP_QUERY_EXPECT* = 68
  HTTP_QUERY_PROXY_CONNECTION* = 69
  HTTP_QUERY_UNLESS_MODIFIED_SINCE* = 70
  HTTP_QUERY_ECHO_REQUEST* = 71
  HTTP_QUERY_ECHO_REPLY* = 72
  HTTP_QUERY_ECHO_HEADERS* = 73
  HTTP_QUERY_ECHO_HEADERS_CRLF* = 74
  HTTP_QUERY_PROXY_SUPPORT* = 75
  HTTP_QUERY_AUTHENTICATION_INFO* = 76
  HTTP_QUERY_PASSPORT_URLS* = 77
  HTTP_QUERY_PASSPORT_CONFIG* = 78
  HTTP_QUERY_MAX* = 78
  HTTP_QUERY_CUSTOM* = 65535
  HTTP_QUERY_FLAG_REQUEST_HEADERS* = 0x80000000'i32
  HTTP_QUERY_FLAG_SYSTEMTIME* = 0x40000000
  HTTP_QUERY_FLAG_NUMBER* = 0x20000000
  HTTP_QUERY_FLAG_COALESCE* = 0x10000000
  HTTP_QUERY_MODIFIER_FLAGS_MASK* = HTTP_QUERY_FLAG_REQUEST_HEADERS or HTTP_QUERY_FLAG_SYSTEMTIME or HTTP_QUERY_FLAG_NUMBER or HTTP_QUERY_FLAG_COALESCE
  HTTP_QUERY_HEADER_MASK* = not HTTP_QUERY_MODIFIER_FLAGS_MASK
  HTTP_STATUS_CONTINUE* = 100
  HTTP_STATUS_SWITCH_PROTOCOLS* = 101
  HTTP_STATUS_OK* = 200
  HTTP_STATUS_CREATED* = 201
  HTTP_STATUS_ACCEPTED* = 202
  HTTP_STATUS_PARTIAL* = 203
  HTTP_STATUS_NO_CONTENT* = 204
  HTTP_STATUS_RESET_CONTENT* = 205
  HTTP_STATUS_PARTIAL_CONTENT* = 206
  HTTP_STATUS_AMBIGUOUS* = 300
  HTTP_STATUS_MOVED* = 301
  HTTP_STATUS_REDIRECT* = 302
  HTTP_STATUS_REDIRECT_METHOD* = 303
  HTTP_STATUS_NOT_MODIFIED* = 304
  HTTP_STATUS_USE_PROXY* = 305
  HTTP_STATUS_REDIRECT_KEEP_VERB* = 307
  HTTP_STATUS_BAD_REQUEST* = 400
  HTTP_STATUS_DENIED* = 401
  HTTP_STATUS_PAYMENT_REQ* = 402
  HTTP_STATUS_FORBIDDEN* = 403
  HTTP_STATUS_NOT_FOUND* = 404
  HTTP_STATUS_BAD_METHOD* = 405
  HTTP_STATUS_NONE_ACCEPTABLE* = 406
  HTTP_STATUS_PROXY_AUTH_REQ* = 407
  HTTP_STATUS_REQUEST_TIMEOUT* = 408
  HTTP_STATUS_CONFLICT* = 409
  HTTP_STATUS_GONE* = 410
  HTTP_STATUS_LENGTH_REQUIRED* = 411
  HTTP_STATUS_PRECOND_FAILED* = 412
  HTTP_STATUS_REQUEST_TOO_LARGE* = 413
  HTTP_STATUS_URI_TOO_LONG* = 414
  HTTP_STATUS_UNSUPPORTED_MEDIA* = 415
  HTTP_STATUS_RETRY_WITH* = 449
  HTTP_STATUS_SERVER_ERROR* = 500
  HTTP_STATUS_NOT_SUPPORTED* = 501
  HTTP_STATUS_BAD_GATEWAY* = 502
  HTTP_STATUS_SERVICE_UNAVAIL* = 503
  HTTP_STATUS_GATEWAY_TIMEOUT* = 504
  HTTP_STATUS_VERSION_NOT_SUP* = 505
  HTTP_STATUS_FIRST* = HTTP_STATUS_CONTINUE
  HTTP_STATUS_LAST* = HTTP_STATUS_VERSION_NOT_SUP
  HTTP_ADDREQ_INDEX_MASK* = 0x0000FFFF
  HTTP_ADDREQ_FLAGS_MASK* = 0xFFFF0000'i32
  HTTP_ADDREQ_FLAG_ADD_IF_NEW* = 0x10000000
  HTTP_ADDREQ_FLAG_ADD* = 0x20000000
  HTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA* = 0x40000000
  HTTP_ADDREQ_FLAG_COALESCE_WITH_SEMICOLON* = 0x01000000
  HTTP_ADDREQ_FLAG_COALESCE* = HTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA
  HTTP_ADDREQ_FLAG_REPLACE* = 0x80000000'i32
  HSR_ASYNC* = WININET_API_FLAG_ASYNC
  HSR_SYNC* = WININET_API_FLAG_SYNC
  HSR_USE_CONTEXT* = WININET_API_FLAG_USE_CONTEXT
  HSR_INITIATE* = 0x00000008
  HSR_DOWNLOAD* = 0x00000010
  HSR_CHUNKED* = 0x00000020
  INTERNET_COOKIE_IS_SECURE* = 0x01
  INTERNET_COOKIE_IS_SESSION* = 0x02
  INTERNET_COOKIE_THIRD_PARTY* = 0x10
  INTERNET_COOKIE_PROMPT_REQUIRED* = 0x20
  INTERNET_COOKIE_EVALUATE_P3P* = 0x40
  INTERNET_COOKIE_APPLY_P3P* = 0x80
  INTERNET_COOKIE_P3P_ENABLED* = 0x100
  INTERNET_COOKIE_IS_RESTRICTED* = 0x200
  INTERNET_COOKIE_IE6* = 0x400
  INTERNET_COOKIE_IS_LEGACY* = 0x800
  FLAG_ICC_FORCE_CONNECTION* = 0x00000001
  FLAGS_ERROR_UI_FILTER_FOR_ERRORS* = 0x01
  FLAGS_ERROR_UI_FLAGS_CHANGE_OPTIONS* = 0x02
  FLAGS_ERROR_UI_FLAGS_GENERATE_DATA* = 0x04
  FLAGS_ERROR_UI_FLAGS_NO_UI* = 0x08
  FLAGS_ERROR_UI_SERIALIZE_DIALOGS* = 0x10
  INTERNET_ERROR_BASE* = 12000
  ERROR_INTERNET_OUT_OF_HANDLES* = INTERNET_ERROR_BASE+1
  ERROR_INTERNET_TIMEOUT* = INTERNET_ERROR_BASE+2
  ERROR_INTERNET_EXTENDED_ERROR* = INTERNET_ERROR_BASE+3
  ERROR_INTERNET_INTERNAL_ERROR* = INTERNET_ERROR_BASE+4
  ERROR_INTERNET_INVALID_URL* = INTERNET_ERROR_BASE+5
  ERROR_INTERNET_UNRECOGNIZED_SCHEME* = INTERNET_ERROR_BASE+6
  ERROR_INTERNET_NAME_NOT_RESOLVED* = INTERNET_ERROR_BASE+7
  ERROR_INTERNET_PROTOCOL_NOT_FOUND* = INTERNET_ERROR_BASE+8
  ERROR_INTERNET_INVALID_OPTION* = INTERNET_ERROR_BASE+9
  ERROR_INTERNET_BAD_OPTION_LENGTH* = INTERNET_ERROR_BASE+10
  ERROR_INTERNET_OPTION_NOT_SETTABLE* = INTERNET_ERROR_BASE+11
  ERROR_INTERNET_SHUTDOWN* = INTERNET_ERROR_BASE+12
  ERROR_INTERNET_INCORRECT_USER_NAME* = INTERNET_ERROR_BASE+13
  ERROR_INTERNET_INCORRECT_PASSWORD* = INTERNET_ERROR_BASE+14
  ERROR_INTERNET_LOGIN_FAILURE* = INTERNET_ERROR_BASE+15
  ERROR_INTERNET_INVALID_OPERATION* = INTERNET_ERROR_BASE+16
  ERROR_INTERNET_OPERATION_CANCELLED* = INTERNET_ERROR_BASE+17
  ERROR_INTERNET_INCORRECT_HANDLE_TYPE* = INTERNET_ERROR_BASE+18
  ERROR_INTERNET_INCORRECT_HANDLE_STATE* = INTERNET_ERROR_BASE+19
  ERROR_INTERNET_NOT_PROXY_REQUEST* = INTERNET_ERROR_BASE+20
  ERROR_INTERNET_REGISTRY_VALUE_NOT_FOUND* = INTERNET_ERROR_BASE+21
  ERROR_INTERNET_BAD_REGISTRY_PARAMETER* = INTERNET_ERROR_BASE+22
  ERROR_INTERNET_NO_DIRECT_ACCESS* = INTERNET_ERROR_BASE+23
  ERROR_INTERNET_NO_CONTEXT* = INTERNET_ERROR_BASE+24
  ERROR_INTERNET_NO_CALLBACK* = INTERNET_ERROR_BASE+25
  ERROR_INTERNET_REQUEST_PENDING* = INTERNET_ERROR_BASE+26
  ERROR_INTERNET_INCORRECT_FORMAT* = INTERNET_ERROR_BASE+27
  ERROR_INTERNET_ITEM_NOT_FOUND* = INTERNET_ERROR_BASE+28
  ERROR_INTERNET_CANNOT_CONNECT* = INTERNET_ERROR_BASE+29
  ERROR_INTERNET_CONNECTION_ABORTED* = INTERNET_ERROR_BASE+30
  ERROR_INTERNET_CONNECTION_RESET* = INTERNET_ERROR_BASE+31
  ERROR_INTERNET_FORCE_RETRY* = INTERNET_ERROR_BASE+32
  ERROR_INTERNET_INVALID_PROXY_REQUEST* = INTERNET_ERROR_BASE+33
  ERROR_INTERNET_NEED_UI* = INTERNET_ERROR_BASE+34
  ERROR_INTERNET_HANDLE_EXISTS* = INTERNET_ERROR_BASE+36
  ERROR_INTERNET_SEC_CERT_DATE_INVALID* = INTERNET_ERROR_BASE+37
  ERROR_INTERNET_SEC_CERT_CN_INVALID* = INTERNET_ERROR_BASE+38
  ERROR_INTERNET_HTTP_TO_HTTPS_ON_REDIR* = INTERNET_ERROR_BASE+39
  ERROR_INTERNET_HTTPS_TO_HTTP_ON_REDIR* = INTERNET_ERROR_BASE+40
  ERROR_INTERNET_MIXED_SECURITY* = INTERNET_ERROR_BASE+41
  ERROR_INTERNET_CHG_POST_IS_NON_SECURE* = INTERNET_ERROR_BASE+42
  ERROR_INTERNET_POST_IS_NON_SECURE* = INTERNET_ERROR_BASE+43
  ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED* = INTERNET_ERROR_BASE+44
  ERROR_INTERNET_INVALID_CA* = INTERNET_ERROR_BASE+45
  ERROR_INTERNET_CLIENT_AUTH_NOT_SETUP* = INTERNET_ERROR_BASE+46
  ERROR_INTERNET_ASYNC_THREAD_FAILED* = INTERNET_ERROR_BASE+47
  ERROR_INTERNET_REDIRECT_SCHEME_CHANGE* = INTERNET_ERROR_BASE+48
  ERROR_INTERNET_DIALOG_PENDING* = INTERNET_ERROR_BASE+49
  ERROR_INTERNET_RETRY_DIALOG* = INTERNET_ERROR_BASE+50
  ERROR_INTERNET_HTTPS_HTTP_SUBMIT_REDIR* = INTERNET_ERROR_BASE+52
  ERROR_INTERNET_INSERT_CDROM* = INTERNET_ERROR_BASE+53
  ERROR_INTERNET_FORTEZZA_LOGIN_NEEDED* = INTERNET_ERROR_BASE+54
  ERROR_INTERNET_SEC_CERT_ERRORS* = INTERNET_ERROR_BASE+55
  ERROR_INTERNET_SEC_CERT_NO_REV* = INTERNET_ERROR_BASE+56
  ERROR_INTERNET_SEC_CERT_REV_FAILED* = INTERNET_ERROR_BASE+57
  ERROR_FTP_TRANSFER_IN_PROGRESS* = INTERNET_ERROR_BASE+110
  ERROR_FTP_DROPPED* = INTERNET_ERROR_BASE+111
  ERROR_FTP_NO_PASSIVE_MODE* = INTERNET_ERROR_BASE+112
  ERROR_GOPHER_PROTOCOL_ERROR* = INTERNET_ERROR_BASE+130
  ERROR_GOPHER_NOT_FILE* = INTERNET_ERROR_BASE+131
  ERROR_GOPHER_DATA_ERROR* = INTERNET_ERROR_BASE+132
  ERROR_GOPHER_END_OF_DATA* = INTERNET_ERROR_BASE+133
  ERROR_GOPHER_INVALID_LOCATOR* = INTERNET_ERROR_BASE+134
  ERROR_GOPHER_INCORRECT_LOCATOR_TYPE* = INTERNET_ERROR_BASE+135
  ERROR_GOPHER_NOT_GOPHER_PLUS* = INTERNET_ERROR_BASE+136
  ERROR_GOPHER_ATTRIBUTE_NOT_FOUND* = INTERNET_ERROR_BASE+137
  ERROR_GOPHER_UNKNOWN_LOCATOR* = INTERNET_ERROR_BASE+138
  ERROR_HTTP_HEADER_NOT_FOUND* = INTERNET_ERROR_BASE+150
  ERROR_HTTP_DOWNLEVEL_SERVER* = INTERNET_ERROR_BASE+151
  ERROR_HTTP_INVALID_SERVER_RESPONSE* = INTERNET_ERROR_BASE+152
  ERROR_HTTP_INVALID_HEADER* = INTERNET_ERROR_BASE+153
  ERROR_HTTP_INVALID_QUERY_REQUEST* = INTERNET_ERROR_BASE+154
  ERROR_HTTP_HEADER_ALREADY_EXISTS* = INTERNET_ERROR_BASE+155
  ERROR_HTTP_REDIRECT_FAILED* = INTERNET_ERROR_BASE+156
  ERROR_HTTP_NOT_REDIRECTED* = INTERNET_ERROR_BASE+160
  ERROR_HTTP_COOKIE_NEEDS_CONFIRMATION* = INTERNET_ERROR_BASE+161
  ERROR_HTTP_COOKIE_DECLINED* = INTERNET_ERROR_BASE+162
  ERROR_HTTP_REDIRECT_NEEDS_CONFIRMATION* = INTERNET_ERROR_BASE+168
  ERROR_INTERNET_SECURITY_CHANNEL_ERROR* = INTERNET_ERROR_BASE+157
  ERROR_INTERNET_UNABLE_TO_CACHE_FILE* = INTERNET_ERROR_BASE+158
  ERROR_INTERNET_TCPIP_NOT_INSTALLED* = INTERNET_ERROR_BASE+159
  ERROR_INTERNET_DISCONNECTED* = INTERNET_ERROR_BASE+163
  ERROR_INTERNET_SERVER_UNREACHABLE* = INTERNET_ERROR_BASE+164
  ERROR_INTERNET_PROXY_SERVER_UNREACHABLE* = INTERNET_ERROR_BASE+165
  ERROR_INTERNET_BAD_AUTO_PROXY_SCRIPT* = INTERNET_ERROR_BASE+166
  ERROR_INTERNET_UNABLE_TO_DOWNLOAD_SCRIPT* = INTERNET_ERROR_BASE+167
  ERROR_INTERNET_SEC_INVALID_CERT* = INTERNET_ERROR_BASE+169
  ERROR_INTERNET_SEC_CERT_REVOKED* = INTERNET_ERROR_BASE+170
  ERROR_INTERNET_FAILED_DUETOSECURITYCHECK* = INTERNET_ERROR_BASE+171
  ERROR_INTERNET_NOT_INITIALIZED* = INTERNET_ERROR_BASE+172
  ERROR_INTERNET_NEED_MSN_SSPI_PKG* = INTERNET_ERROR_BASE+173
  ERROR_INTERNET_LOGIN_FAILURE_DISPLAY_ENTITY_BODY* = INTERNET_ERROR_BASE+174
  INTERNET_ERROR_LAST* = ERROR_INTERNET_LOGIN_FAILURE_DISPLAY_ENTITY_BODY
  NORMAL_CACHE_ENTRY* = 0x00000001
  STICKY_CACHE_ENTRY* = 0x00000004
  EDITED_CACHE_ENTRY* = 0x00000008
  TRACK_OFFLINE_CACHE_ENTRY* = 0x00000010
  TRACK_ONLINE_CACHE_ENTRY* = 0x00000020
  SPARSE_CACHE_ENTRY* = 0x00010000
  COOKIE_CACHE_ENTRY* = 0x00100000
  URLHISTORY_CACHE_ENTRY* = 0x00200000
  URLCACHE_FIND_DEFAULT_FILTER* = NORMAL_CACHE_ENTRY or COOKIE_CACHE_ENTRY or URLHISTORY_CACHE_ENTRY or TRACK_OFFLINE_CACHE_ENTRY or TRACK_ONLINE_CACHE_ENTRY or STICKY_CACHE_ENTRY
  CACHEGROUP_ATTRIBUTE_GET_ALL* = 0xffffffff'i32
  CACHEGROUP_ATTRIBUTE_BASIC* = 0x00000001
  CACHEGROUP_ATTRIBUTE_FLAG* = 0x00000002
  CACHEGROUP_ATTRIBUTE_TYPE* = 0x00000004
  CACHEGROUP_ATTRIBUTE_QUOTA* = 0x00000008
  CACHEGROUP_ATTRIBUTE_GROUPNAME* = 0x00000010
  CACHEGROUP_ATTRIBUTE_STORAGE* = 0x00000020
  CACHEGROUP_FLAG_NONPURGEABLE* = 0x00000001
  CACHEGROUP_FLAG_GIDONLY* = 0x00000004
  CACHEGROUP_FLAG_FLUSHURL_ONDELETE* = 0x00000002
  CACHEGROUP_SEARCH_ALL* = 0x00000000
  CACHEGROUP_SEARCH_BYURL* = 0x00000001
  CACHEGROUP_TYPE_INVALID* = 0x00000001
  CACHEGROUP_READWRITE_MASK* = CACHEGROUP_ATTRIBUTE_TYPE or CACHEGROUP_ATTRIBUTE_QUOTA or CACHEGROUP_ATTRIBUTE_GROUPNAME or CACHEGROUP_ATTRIBUTE_STORAGE
  CACHE_ENTRY_ATTRIBUTE_FC* = 0x00000004
  CACHE_ENTRY_HITRATE_FC* = 0x00000010
  CACHE_ENTRY_MODTIME_FC* = 0x00000040
  CACHE_ENTRY_EXPTIME_FC* = 0x00000080
  CACHE_ENTRY_ACCTIME_FC* = 0x00000100
  CACHE_ENTRY_SYNCTIME_FC* = 0x00000200
  CACHE_ENTRY_HEADERINFO_FC* = 0x00000400
  CACHE_ENTRY_EXEMPT_DELTA_FC* = 0x00000800
  INTERNET_CACHE_GROUP_ADD* = 0
  INTERNET_CACHE_GROUP_REMOVE* = 1
  INTERNET_DIAL_FORCE_PROMPT* = 0x2000
  INTERNET_DIAL_SHOW_OFFLINE* = 0x4000
  INTERNET_DIAL_UNATTENDED* = 0x8000
  INTERENT_GOONLINE_REFRESH* = 0x00000001
  INTERENT_GOONLINE_MASK* = 0x00000001
  INTERNET_AUTODIAL_FORCE_ONLINE* = 1
  INTERNET_AUTODIAL_FORCE_UNATTENDED* = 2
  INTERNET_AUTODIAL_FAILIFSECURITYCHECK* = 4
  INTERNET_AUTODIAL_OVERRIDE_NET_PRESENT* = 8
  INTERNET_AUTODIAL_FLAGS_MASK* = INTERNET_AUTODIAL_FORCE_ONLINE or INTERNET_AUTODIAL_FORCE_UNATTENDED or INTERNET_AUTODIAL_FAILIFSECURITYCHECK or INTERNET_AUTODIAL_OVERRIDE_NET_PRESENT
  PROXY_AUTO_DETECT_TYPE_DHCP* = 1
  PROXY_AUTO_DETECT_TYPE_DNS_A* = 2
  INTERNET_CONNECTION_MODEM* = 0x01
  INTERNET_CONNECTION_LAN* = 0x02
  INTERNET_CONNECTION_PROXY* = 0x04
  INTERNET_CONNECTION_MODEM_BUSY* = 0x08
  INTERNET_RAS_INSTALLED* = 0x10
  INTERNET_CONNECTION_OFFLINE* = 0x20
  INTERNET_CONNECTION_CONFIGURED* = 0x40
  INTERNET_CUSTOMDIAL_CONNECT* = 0
  INTERNET_CUSTOMDIAL_UNATTENDED* = 1
  INTERNET_CUSTOMDIAL_DISCONNECT* = 2
  INTERNET_CUSTOMDIAL_SHOWOFFLINE* = 4
  INTERNET_CUSTOMDIAL_SAFE_FOR_UNATTENDED* = 1
  INTERNET_CUSTOMDIAL_WILL_SUPPLY_STATE* = 2
  INTERNET_CUSTOMDIAL_CAN_HANGUP* = 4
  INTERNET_DIALSTATE_DISCONNECTED* = 1
  INTERNET_IDENTITY_FLAG_PRIVATE_CACHE* = 0x01
  INTERNET_IDENTITY_FLAG_SHARED_CACHE* = 0x02
  INTERNET_IDENTITY_FLAG_CLEAR_DATA* = 0x04
  INTERNET_IDENTITY_FLAG_CLEAR_COOKIES* = 0x08
  INTERNET_IDENTITY_FLAG_CLEAR_HISTORY* = 0x10
  INTERNET_IDENTITY_FLAG_CLEAR_CONTENT* = 0x20
  INTERNET_SUPPRESS_RESET_ALL* = 0x00
  INTERNET_SUPPRESS_COOKIE_POLICY* = 0x01
  INTERNET_SUPPRESS_COOKIE_POLICY_RESET* = 0x02
  PRIVACY_TEMPLATE_NO_COOKIES* = 0
  PRIVACY_TEMPLATE_HIGH* = 1
  PRIVACY_TEMPLATE_MEDIUM_HIGH* = 2
  PRIVACY_TEMPLATE_MEDIUM* = 3
  PRIVACY_TEMPLATE_MEDIUM_LOW* = 4
  PRIVACY_TEMPLATE_LOW* = 5
  PRIVACY_TEMPLATE_CUSTOM* = 100
  PRIVACY_TEMPLATE_ADVANCED* = 101
  PRIVACY_TEMPLATE_MAX* = PRIVACY_TEMPLATE_LOW
  PRIVACY_TYPE_FIRST_PARTY* = 0
  PRIVACY_TYPE_THIRD_PARTY* = 1
  INTERNET_MAX_URL_LENGTH* = 2084
  INTERNET_INVALID_STATUS_CALLBACK* = cast[INTERNET_STATUS_CALLBACK](-1)
type
  GOPHER_ATTRIBUTE_ENUMERATOR* = proc (lpAttributeInfo: LPGOPHER_ATTRIBUTE_TYPE, dwError: DWORD): WINBOOL {.stdcall.}
  PFN_AUTH_NOTIFY* = proc (P1: DWORD_PTR, P2: DWORD, P3: LPVOID): DWORD {.stdcall.}
  AutoProxyHelperFunctions* {.pure.} = object
    lpVtbl*: ptr AutoProxyHelperVtbl
  pfnInternetInitializeAutoProxyDll* = proc (dwVersion: DWORD, lpszDownloadedTempFile: LPSTR, lpszMime: LPSTR, lpAutoProxyCallbacks: ptr AutoProxyHelperFunctions, lpAutoProxyScriptBuffer: LPAUTO_PROXY_SCRIPT_BUFFER): WINBOOL {.stdcall.}
  pfnInternetDeInitializeAutoProxyDll* = proc (lpszMime: LPSTR, dwReserved: DWORD): WINBOOL {.stdcall.}
  pfnInternetGetProxyInfo* = proc (lpszUrl: LPCSTR, dwUrlLength: DWORD, lpszUrlHostName: LPSTR, dwUrlHostNameLength: DWORD, lplpszProxyHostName: ptr LPSTR, lpdwProxyHostNameLength: LPDWORD): WINBOOL {.stdcall.}
  PFN_DIAL_HANDLER* = proc (P1: HWND, P2: LPCSTR, P3: DWORD, P4: LPDWORD): DWORD {.stdcall.}
  IncomingCookieState* {.pure.} = object
    cSession*: int32
    cPersistent*: int32
    cAccepted*: int32
    cLeashed*: int32
    cDowngraded*: int32
    cBlocked*: int32
    pszLocation*: ptr char
  OutgoingCookieState* {.pure.} = object
    cSent*: int32
    cSuppressed*: int32
    pszLocation*: ptr char
  InternetCookieHistory* {.pure.} = object
    fAccepted*: WINBOOL
    fLeashed*: WINBOOL
    fDowngraded*: WINBOOL
    fRejected*: WINBOOL
  CookieDecision* {.pure.} = object
    dwCookieState*: DWORD
    fAllowSession*: WINBOOL
  INTERNET_AUTH_NOTIFY_DATA* {.pure.} = object
    cbStruct*: DWORD
    dwOptions*: DWORD
    pfnNotify*: PFN_AUTH_NOTIFY
    dwContext*: DWORD_PTR
  AutoProxyHelperVtbl* {.pure.} = object
    IsResolvable*: proc(lpszHost: LPSTR): WINBOOL {.stdcall.}
    GetIPAddress*: proc(lpszIPAddress: LPSTR, lpdwIPAddressSize: LPDWORD): DWORD {.stdcall.}
    ResolveHostName*: proc(lpszHostName: LPSTR, lpszIPAddress: LPSTR, lpdwIPAddressSize: LPDWORD): DWORD {.stdcall.}
    IsInNet*: proc(lpszIPAddress: LPSTR, lpszDest: LPSTR, lpszMask: LPSTR): WINBOOL {.stdcall.}
proc InternetTimeFromSystemTimeA*(pst: ptr SYSTEMTIME, dwRFC: DWORD, lpszTime: LPSTR, cbTime: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetTimeFromSystemTimeW*(pst: ptr SYSTEMTIME, dwRFC: DWORD, lpszTime: LPWSTR, cbTime: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetTimeToSystemTimeA*(lpszTime: LPCSTR, pst: ptr SYSTEMTIME, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetTimeToSystemTimeW*(lpszTime: LPCWSTR, pst: ptr SYSTEMTIME, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetCrackUrlA*(lpszUrl: LPCSTR, dwUrlLength: DWORD, dwFlags: DWORD, lpUrlComponents: LPURL_COMPONENTSA): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetCrackUrlW*(lpszUrl: LPCWSTR, dwUrlLength: DWORD, dwFlags: DWORD, lpUrlComponents: LPURL_COMPONENTSW): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetCreateUrlA*(lpUrlComponents: LPURL_COMPONENTSA, dwFlags: DWORD, lpszUrl: LPSTR, lpdwUrlLength: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetCreateUrlW*(lpUrlComponents: LPURL_COMPONENTSW, dwFlags: DWORD, lpszUrl: LPWSTR, lpdwUrlLength: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetCanonicalizeUrlA*(lpszUrl: LPCSTR, lpszBuffer: LPSTR, lpdwBufferLength: LPDWORD, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetCanonicalizeUrlW*(lpszUrl: LPCWSTR, lpszBuffer: LPWSTR, lpdwBufferLength: LPDWORD, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetCombineUrlA*(lpszBaseUrl: LPCSTR, lpszRelativeUrl: LPCSTR, lpszBuffer: LPSTR, lpdwBufferLength: LPDWORD, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetCombineUrlW*(lpszBaseUrl: LPCWSTR, lpszRelativeUrl: LPCWSTR, lpszBuffer: LPWSTR, lpdwBufferLength: LPDWORD, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetOpenA*(lpszAgent: LPCSTR, dwAccessType: DWORD, lpszProxy: LPCSTR, lpszProxyBypass: LPCSTR, dwFlags: DWORD): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetOpenW*(lpszAgent: LPCWSTR, dwAccessType: DWORD, lpszProxy: LPCWSTR, lpszProxyBypass: LPCWSTR, dwFlags: DWORD): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetCloseHandle*(hInternet: HINTERNET): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetConnectA*(hInternet: HINTERNET, lpszServerName: LPCSTR, nServerPort: INTERNET_PORT, lpszUserName: LPCSTR, lpszPassword: LPCSTR, dwService: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetConnectW*(hInternet: HINTERNET, lpszServerName: LPCWSTR, nServerPort: INTERNET_PORT, lpszUserName: LPCWSTR, lpszPassword: LPCWSTR, dwService: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetOpenUrlA*(hInternet: HINTERNET, lpszUrl: LPCSTR, lpszHeaders: LPCSTR, dwHeadersLength: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetOpenUrlW*(hInternet: HINTERNET, lpszUrl: LPCWSTR, lpszHeaders: LPCWSTR, dwHeadersLength: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetReadFile*(hFile: HINTERNET, lpBuffer: LPVOID, dwNumberOfBytesToRead: DWORD, lpdwNumberOfBytesRead: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetReadFileExA*(hFile: HINTERNET, lpBuffersOut: LPINTERNET_BUFFERSA, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetReadFileExW*(hFile: HINTERNET, lpBuffersOut: LPINTERNET_BUFFERSW, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetSetFilePointer*(hFile: HINTERNET, lDistanceToMove: LONG, pReserved: PVOID, dwMoveMethod: DWORD, dwContext: DWORD_PTR): DWORD {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetWriteFile*(hFile: HINTERNET, lpBuffer: LPCVOID, dwNumberOfBytesToWrite: DWORD, lpdwNumberOfBytesWritten: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetQueryDataAvailable*(hFile: HINTERNET, lpdwNumberOfBytesAvailable: LPDWORD, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetFindNextFileA*(hFind: HINTERNET, lpvFindData: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetFindNextFileW*(hFind: HINTERNET, lpvFindData: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetQueryOptionA*(hInternet: HINTERNET, dwOption: DWORD, lpBuffer: LPVOID, lpdwBufferLength: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetQueryOptionW*(hInternet: HINTERNET, dwOption: DWORD, lpBuffer: LPVOID, lpdwBufferLength: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetSetOptionA*(hInternet: HINTERNET, dwOption: DWORD, lpBuffer: LPVOID, dwBufferLength: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetSetOptionW*(hInternet: HINTERNET, dwOption: DWORD, lpBuffer: LPVOID, dwBufferLength: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetSetOptionExA*(hInternet: HINTERNET, dwOption: DWORD, lpBuffer: LPVOID, dwBufferLength: DWORD, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetSetOptionExW*(hInternet: HINTERNET, dwOption: DWORD, lpBuffer: LPVOID, dwBufferLength: DWORD, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetLockRequestFile*(hInternet: HINTERNET, lphLockRequestInfo: ptr HANDLE): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetUnlockRequestFile*(hLockRequestInfo: HANDLE): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetGetLastResponseInfoA*(lpdwError: LPDWORD, lpszBuffer: LPSTR, lpdwBufferLength: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetGetLastResponseInfoW*(lpdwError: LPDWORD, lpszBuffer: LPWSTR, lpdwBufferLength: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetSetStatusCallbackA*(hInternet: HINTERNET, lpfnInternetCallback: INTERNET_STATUS_CALLBACK): INTERNET_STATUS_CALLBACK {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetSetStatusCallbackW*(hInternet: HINTERNET, lpfnInternetCallback: INTERNET_STATUS_CALLBACK): INTERNET_STATUS_CALLBACK {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpFindFirstFileA*(hConnect: HINTERNET, lpszSearchFile: LPCSTR, lpFindFileData: LPWIN32_FIND_DATAA, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpFindFirstFileW*(hConnect: HINTERNET, lpszSearchFile: LPCWSTR, lpFindFileData: LPWIN32_FIND_DATAW, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpGetFileA*(hConnect: HINTERNET, lpszRemoteFile: LPCSTR, lpszNewFile: LPCSTR, fFailIfExists: WINBOOL, dwFlagsAndAttributes: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpGetFileW*(hConnect: HINTERNET, lpszRemoteFile: LPCWSTR, lpszNewFile: LPCWSTR, fFailIfExists: WINBOOL, dwFlagsAndAttributes: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpPutFileA*(hConnect: HINTERNET, lpszLocalFile: LPCSTR, lpszNewRemoteFile: LPCSTR, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpPutFileW*(hConnect: HINTERNET, lpszLocalFile: LPCWSTR, lpszNewRemoteFile: LPCWSTR, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpGetFileEx*(hFtpSession: HINTERNET, lpszRemoteFile: LPCSTR, lpszNewFile: LPCWSTR, fFailIfExists: WINBOOL, dwFlagsAndAttributes: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpPutFileEx*(hFtpSession: HINTERNET, lpszLocalFile: LPCWSTR, lpszNewRemoteFile: LPCSTR, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpDeleteFileA*(hConnect: HINTERNET, lpszFileName: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpDeleteFileW*(hConnect: HINTERNET, lpszFileName: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpRenameFileA*(hConnect: HINTERNET, lpszExisting: LPCSTR, lpszNew: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpRenameFileW*(hConnect: HINTERNET, lpszExisting: LPCWSTR, lpszNew: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpOpenFileA*(hConnect: HINTERNET, lpszFileName: LPCSTR, dwAccess: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpOpenFileW*(hConnect: HINTERNET, lpszFileName: LPCWSTR, dwAccess: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpCreateDirectoryA*(hConnect: HINTERNET, lpszDirectory: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpCreateDirectoryW*(hConnect: HINTERNET, lpszDirectory: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpRemoveDirectoryA*(hConnect: HINTERNET, lpszDirectory: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpRemoveDirectoryW*(hConnect: HINTERNET, lpszDirectory: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpSetCurrentDirectoryA*(hConnect: HINTERNET, lpszDirectory: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpSetCurrentDirectoryW*(hConnect: HINTERNET, lpszDirectory: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpGetCurrentDirectoryA*(hConnect: HINTERNET, lpszCurrentDirectory: LPSTR, lpdwCurrentDirectory: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpGetCurrentDirectoryW*(hConnect: HINTERNET, lpszCurrentDirectory: LPWSTR, lpdwCurrentDirectory: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpCommandA*(hConnect: HINTERNET, fExpectResponse: WINBOOL, dwFlags: DWORD, lpszCommand: LPCSTR, dwContext: DWORD_PTR, phFtpCommand: ptr HINTERNET): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpCommandW*(hConnect: HINTERNET, fExpectResponse: WINBOOL, dwFlags: DWORD, lpszCommand: LPCWSTR, dwContext: DWORD_PTR, phFtpCommand: ptr HINTERNET): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FtpGetFileSize*(hFile: HINTERNET, lpdwFileSizeHigh: LPDWORD): DWORD {.winapi, stdcall, dynlib: "wininet", importc.}
proc GopherCreateLocatorA*(lpszHost: LPCSTR, nServerPort: INTERNET_PORT, lpszDisplayString: LPCSTR, lpszSelectorString: LPCSTR, dwGopherType: DWORD, lpszLocator: LPSTR, lpdwBufferLength: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc GopherCreateLocatorW*(lpszHost: LPCWSTR, nServerPort: INTERNET_PORT, lpszDisplayString: LPCWSTR, lpszSelectorString: LPCWSTR, dwGopherType: DWORD, lpszLocator: LPWSTR, lpdwBufferLength: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc GopherGetLocatorTypeA*(lpszLocator: LPCSTR, lpdwGopherType: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc GopherGetLocatorTypeW*(lpszLocator: LPCWSTR, lpdwGopherType: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc GopherFindFirstFileA*(hConnect: HINTERNET, lpszLocator: LPCSTR, lpszSearchString: LPCSTR, lpFindData: LPGOPHER_FIND_DATAA, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc.}
proc GopherFindFirstFileW*(hConnect: HINTERNET, lpszLocator: LPCWSTR, lpszSearchString: LPCWSTR, lpFindData: LPGOPHER_FIND_DATAW, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc.}
proc GopherOpenFileA*(hConnect: HINTERNET, lpszLocator: LPCSTR, lpszView: LPCSTR, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc.}
proc GopherOpenFileW*(hConnect: HINTERNET, lpszLocator: LPCWSTR, lpszView: LPCWSTR, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc.}
proc GopherGetAttributeA*(hConnect: HINTERNET, lpszLocator: LPCSTR, lpszAttributeName: LPCSTR, lpBuffer: LPBYTE, dwBufferLength: DWORD, lpdwCharactersReturned: LPDWORD, lpfnEnumerator: GOPHER_ATTRIBUTE_ENUMERATOR, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc GopherGetAttributeW*(hConnect: HINTERNET, lpszLocator: LPCWSTR, lpszAttributeName: LPCWSTR, lpBuffer: LPBYTE, dwBufferLength: DWORD, lpdwCharactersReturned: LPDWORD, lpfnEnumerator: GOPHER_ATTRIBUTE_ENUMERATOR, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc HttpOpenRequestA*(hConnect: HINTERNET, lpszVerb: LPCSTR, lpszObjectName: LPCSTR, lpszVersion: LPCSTR, lpszReferrer: LPCSTR, lplpszAcceptTypes: ptr LPCSTR, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc.}
proc HttpOpenRequestW*(hConnect: HINTERNET, lpszVerb: LPCWSTR, lpszObjectName: LPCWSTR, lpszVersion: LPCWSTR, lpszReferrer: LPCWSTR, lplpszAcceptTypes: ptr LPCWSTR, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc.}
proc HttpAddRequestHeadersA*(hRequest: HINTERNET, lpszHeaders: LPCSTR, dwHeadersLength: DWORD, dwModifiers: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc HttpAddRequestHeadersW*(hRequest: HINTERNET, lpszHeaders: LPCWSTR, dwHeadersLength: DWORD, dwModifiers: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc HttpSendRequestA*(hRequest: HINTERNET, lpszHeaders: LPCSTR, dwHeadersLength: DWORD, lpOptional: LPVOID, dwOptionalLength: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc HttpSendRequestW*(hRequest: HINTERNET, lpszHeaders: LPCWSTR, dwHeadersLength: DWORD, lpOptional: LPVOID, dwOptionalLength: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc HttpSendRequestExA*(hRequest: HINTERNET, lpBuffersIn: LPINTERNET_BUFFERSA, lpBuffersOut: LPINTERNET_BUFFERSA, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc HttpSendRequestExW*(hRequest: HINTERNET, lpBuffersIn: LPINTERNET_BUFFERSW, lpBuffersOut: LPINTERNET_BUFFERSW, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc HttpEndRequestA*(hRequest: HINTERNET, lpBuffersOut: LPINTERNET_BUFFERSA, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc HttpEndRequestW*(hRequest: HINTERNET, lpBuffersOut: LPINTERNET_BUFFERSW, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc HttpQueryInfoA*(hRequest: HINTERNET, dwInfoLevel: DWORD, lpBuffer: LPVOID, lpdwBufferLength: LPDWORD, lpdwIndex: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc HttpQueryInfoW*(hRequest: HINTERNET, dwInfoLevel: DWORD, lpBuffer: LPVOID, lpdwBufferLength: LPDWORD, lpdwIndex: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetSetCookieA*(lpszUrl: LPCSTR, lpszCookieName: LPCSTR, lpszCookieData: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetSetCookieW*(lpszUrl: LPCWSTR, lpszCookieName: LPCWSTR, lpszCookieData: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetGetCookieA*(lpszUrl: LPCSTR, lpszCookieName: LPCSTR, lpszCookieData: LPSTR, lpdwSize: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetGetCookieW*(lpszUrl: LPCWSTR, lpszCookieName: LPCWSTR, lpszCookieData: LPWSTR, lpdwSize: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetSetCookieExA*(lpszUrl: LPCSTR, lpszCookieName: LPCSTR, lpszCookieData: LPCSTR, dwFlags: DWORD, dwReserved: DWORD_PTR): DWORD {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetSetCookieExW*(lpszUrl: LPCWSTR, lpszCookieName: LPCWSTR, lpszCookieData: LPCWSTR, dwFlags: DWORD, dwReserved: DWORD_PTR): DWORD {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetGetCookieExA*(lpszUrl: LPCSTR, lpszCookieName: LPCSTR, lpszCookieData: LPSTR, lpdwSize: LPDWORD, dwFlags: DWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetGetCookieExW*(lpszUrl: LPCWSTR, lpszCookieName: LPCWSTR, lpszCookieData: LPWSTR, lpdwSize: LPDWORD, dwFlags: DWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetAttemptConnect*(dwReserved: DWORD): DWORD {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetCheckConnectionA*(lpszUrl: LPCSTR, dwFlags: DWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetCheckConnectionW*(lpszUrl: LPCWSTR, dwFlags: DWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc ResumeSuspendedDownload*(hRequest: HINTERNET, dwResultCode: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetErrorDlg*(hWnd: HWND, hRequest: HINTERNET, dwError: DWORD, dwFlags: DWORD, lppvData: ptr LPVOID): DWORD {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetConfirmZoneCrossingA*(hWnd: HWND, szUrlPrev: LPSTR, szUrlNew: LPSTR, bPost: WINBOOL): DWORD {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetConfirmZoneCrossingW*(hWnd: HWND, szUrlPrev: LPWSTR, szUrlNew: LPWSTR, bPost: WINBOOL): DWORD {.winapi, stdcall, dynlib: "wininet", importc.}
proc CreateUrlCacheEntryA*(lpszUrlName: LPCSTR, dwExpectedFileSize: DWORD, lpszFileExtension: LPCSTR, lpszFileName: LPSTR, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc CreateUrlCacheEntryW*(lpszUrlName: LPCWSTR, dwExpectedFileSize: DWORD, lpszFileExtension: LPCWSTR, lpszFileName: LPWSTR, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc CommitUrlCacheEntryA*(lpszUrlName: LPCSTR, lpszLocalFileName: LPCSTR, ExpireTime: FILETIME, LastModifiedTime: FILETIME, CacheEntryType: DWORD, lpHeaderInfo: LPBYTE, dwHeaderSize: DWORD, lpszFileExtension: LPCSTR, lpszOriginalUrl: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc CommitUrlCacheEntryW*(lpszUrlName: LPCWSTR, lpszLocalFileName: LPCWSTR, ExpireTime: FILETIME, LastModifiedTime: FILETIME, CacheEntryType: DWORD, lpszHeaderInfo: LPWSTR, dwHeaders: DWORD, lpszFileExtension: LPCWSTR, lpszOriginalUrl: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc RetrieveUrlCacheEntryFileA*(lpszUrlName: LPCSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, lpcbCacheEntryInfo: LPDWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc RetrieveUrlCacheEntryFileW*(lpszUrlName: LPCWSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, lpcbCacheEntryInfo: LPDWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc UnlockUrlCacheEntryFileA*(lpszUrlName: LPCSTR, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc UnlockUrlCacheEntryFileW*(lpszUrlName: LPCWSTR, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc RetrieveUrlCacheEntryStreamA*(lpszUrlName: LPCSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, lpcbCacheEntryInfo: LPDWORD, fRandomRead: WINBOOL, dwReserved: DWORD): HANDLE {.winapi, stdcall, dynlib: "wininet", importc.}
proc RetrieveUrlCacheEntryStreamW*(lpszUrlName: LPCWSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, lpcbCacheEntryInfo: LPDWORD, fRandomRead: WINBOOL, dwReserved: DWORD): HANDLE {.winapi, stdcall, dynlib: "wininet", importc.}
proc ReadUrlCacheEntryStream*(hUrlCacheStream: HANDLE, dwLocation: DWORD, lpBuffer: LPVOID, lpdwLen: LPDWORD, Reserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc UnlockUrlCacheEntryStream*(hUrlCacheStream: HANDLE, Reserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc GetUrlCacheEntryInfoA*(lpszUrlName: LPCSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, lpcbCacheEntryInfo: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc GetUrlCacheEntryInfoW*(lpszUrlName: LPCWSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, lpcbCacheEntryInfo: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FindFirstUrlCacheGroup*(dwFlags: DWORD, dwFilter: DWORD, lpSearchCondition: LPVOID, dwSearchCondition: DWORD, lpGroupId: ptr GROUPID, lpReserved: LPVOID): HANDLE {.winapi, stdcall, dynlib: "wininet", importc.}
proc FindNextUrlCacheGroup*(hFind: HANDLE, lpGroupId: ptr GROUPID, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc GetUrlCacheGroupAttributeA*(gid: GROUPID, dwFlags: DWORD, dwAttributes: DWORD, lpGroupInfo: LPINTERNET_CACHE_GROUP_INFOA, lpdwGroupInfo: LPDWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc GetUrlCacheGroupAttributeW*(gid: GROUPID, dwFlags: DWORD, dwAttributes: DWORD, lpGroupInfo: LPINTERNET_CACHE_GROUP_INFOW, lpdwGroupInfo: LPDWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc SetUrlCacheGroupAttributeA*(gid: GROUPID, dwFlags: DWORD, dwAttributes: DWORD, lpGroupInfo: LPINTERNET_CACHE_GROUP_INFOA, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc SetUrlCacheGroupAttributeW*(gid: GROUPID, dwFlags: DWORD, dwAttributes: DWORD, lpGroupInfo: LPINTERNET_CACHE_GROUP_INFOW, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc CreateUrlCacheGroup*(dwFlags: DWORD, lpReserved: LPVOID): GROUPID {.winapi, stdcall, dynlib: "wininet", importc.}
proc DeleteUrlCacheGroup*(GroupId: GROUPID, dwFlags: DWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc GetUrlCacheEntryInfoExA*(lpszUrl: LPCSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, lpcbCacheEntryInfo: LPDWORD, lpszRedirectUrl: LPSTR, lpcbRedirectUrl: LPDWORD, lpReserved: LPVOID, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc GetUrlCacheEntryInfoExW*(lpszUrl: LPCWSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, lpcbCacheEntryInfo: LPDWORD, lpszRedirectUrl: LPWSTR, lpcbRedirectUrl: LPDWORD, lpReserved: LPVOID, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc SetUrlCacheEntryInfoA*(lpszUrlName: LPCSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, dwFieldControl: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc SetUrlCacheEntryInfoW*(lpszUrlName: LPCWSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, dwFieldControl: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc SetUrlCacheEntryGroupA*(lpszUrlName: LPCSTR, dwFlags: DWORD, GroupId: GROUPID, pbGroupAttributes: LPBYTE, cbGroupAttributes: DWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc SetUrlCacheEntryGroupW*(lpszUrlName: LPCWSTR, dwFlags: DWORD, GroupId: GROUPID, pbGroupAttributes: LPBYTE, cbGroupAttributes: DWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FindFirstUrlCacheEntryExA*(lpszUrlSearchPattern: LPCSTR, dwFlags: DWORD, dwFilter: DWORD, GroupId: GROUPID, lpFirstCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, lpcbEntryInfo: LPDWORD, lpGroupAttributes: LPVOID, lpcbGroupAttributes: LPDWORD, lpReserved: LPVOID): HANDLE {.winapi, stdcall, dynlib: "wininet", importc.}
proc FindFirstUrlCacheEntryExW*(lpszUrlSearchPattern: LPCWSTR, dwFlags: DWORD, dwFilter: DWORD, GroupId: GROUPID, lpFirstCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, lpcbEntryInfo: LPDWORD, lpGroupAttributes: LPVOID, lpcbGroupAttributes: LPDWORD, lpReserved: LPVOID): HANDLE {.winapi, stdcall, dynlib: "wininet", importc.}
proc FindNextUrlCacheEntryExA*(hEnumHandle: HANDLE, lpNextCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, lpcbEntryInfo: LPDWORD, lpGroupAttributes: LPVOID, lpcbGroupAttributes: LPDWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FindNextUrlCacheEntryExW*(hEnumHandle: HANDLE, lpNextCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, lpcbEntryInfo: LPDWORD, lpGroupAttributes: LPVOID, lpcbGroupAttributes: LPDWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FindFirstUrlCacheEntryA*(lpszUrlSearchPattern: LPCSTR, lpFirstCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, lpcbCacheEntryInfo: LPDWORD): HANDLE {.winapi, stdcall, dynlib: "wininet", importc.}
proc FindFirstUrlCacheEntryW*(lpszUrlSearchPattern: LPCWSTR, lpFirstCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, lpcbCacheEntryInfo: LPDWORD): HANDLE {.winapi, stdcall, dynlib: "wininet", importc.}
proc FindNextUrlCacheEntryA*(hEnumHandle: HANDLE, lpNextCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, lpcbCacheEntryInfo: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FindNextUrlCacheEntryW*(hEnumHandle: HANDLE, lpNextCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, lpcbCacheEntryInfo: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc FindCloseUrlCache*(hEnumHandle: HANDLE): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc DeleteUrlCacheEntryA*(lpszUrlName: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc DeleteUrlCacheEntryW*(lpszUrlName: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetDialA*(hwndParent: HWND, lpszConnectoid: LPSTR, dwFlags: DWORD, lpdwConnection: ptr DWORD_PTR, dwReserved: DWORD): DWORD {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetDialW*(hwndParent: HWND, lpszConnectoid: LPWSTR, dwFlags: DWORD, lpdwConnection: ptr DWORD_PTR, dwReserved: DWORD): DWORD {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetHangUp*(dwConnection: DWORD_PTR, dwReserved: DWORD): DWORD {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetGoOnlineA*(lpszURL: LPSTR, hwndParent: HWND, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetGoOnlineW*(lpszURL: LPWSTR, hwndParent: HWND, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetAutodial*(dwFlags: DWORD, hwndParent: HWND): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetAutodialHangup*(dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetGetConnectedState*(lpdwFlags: LPDWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetGetConnectedStateExA*(lpdwFlags: LPDWORD, lpszConnectionName: LPSTR, dwBufLen: DWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetGetConnectedStateExW*(lpdwFlags: LPDWORD, lpszConnectionName: LPWSTR, dwBufLen: DWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetInitializeAutoProxyDll*(dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc DetectAutoProxyUrl*(lpszAutoProxyUrl: LPSTR, dwAutoProxyUrlLength: DWORD, dwDetectFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc CreateMD5SSOHash*(pszChallengeInfo: PWSTR, pwszRealm: PWSTR, pwszTarget: PWSTR, pbHexHash: PBYTE): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetSetDialStateA*(lpszConnectoid: LPCSTR, dwState: DWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetSetDialStateW*(lpszConnectoid: LPCWSTR, dwState: DWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetSetPerSiteCookieDecisionA*(pchHostName: LPCSTR, dwDecision: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetSetPerSiteCookieDecisionW*(pchHostName: LPCWSTR, dwDecision: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetGetPerSiteCookieDecisionA*(pchHostName: LPCSTR, pResult: ptr int32): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetGetPerSiteCookieDecisionW*(pchHostName: LPCWSTR, pResult: ptr int32): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetClearAllPerSiteCookieDecisions*(): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetEnumPerSiteCookieDecisionA*(pszSiteName: LPSTR, pcSiteNameSize: ptr int32, pdwDecision: ptr int32, dwIndex: int32): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc InternetEnumPerSiteCookieDecisionW*(pszSiteName: LPWSTR, pcSiteNameSize: ptr int32, pdwDecision: ptr int32, dwIndex: int32): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc.}
proc PrivacySetZonePreferenceW*(dwZone: DWORD, dwType: DWORD, dwTemplate: DWORD, pszPreference: LPCWSTR): DWORD {.winapi, stdcall, dynlib: "wininet", importc.}
proc PrivacyGetZonePreferenceW*(dwZone: DWORD, dwType: DWORD, pdwTemplate: LPDWORD, pszBuffer: LPWSTR, pdwBufferLength: LPDWORD): DWORD {.winapi, stdcall, dynlib: "wininet", importc.}
proc `dwReserved=`*(self: var INTERNET_CACHE_ENTRY_INFOA, x: DWORD) {.inline.} = self.union1.dwReserved = x
proc dwReserved*(self: INTERNET_CACHE_ENTRY_INFOA): DWORD {.inline.} = self.union1.dwReserved
proc dwReserved*(self: var INTERNET_CACHE_ENTRY_INFOA): var DWORD {.inline.} = self.union1.dwReserved
proc `dwExemptDelta=`*(self: var INTERNET_CACHE_ENTRY_INFOA, x: DWORD) {.inline.} = self.union1.dwExemptDelta = x
proc dwExemptDelta*(self: INTERNET_CACHE_ENTRY_INFOA): DWORD {.inline.} = self.union1.dwExemptDelta
proc dwExemptDelta*(self: var INTERNET_CACHE_ENTRY_INFOA): var DWORD {.inline.} = self.union1.dwExemptDelta
proc `dwReserved=`*(self: var INTERNET_CACHE_ENTRY_INFOW, x: DWORD) {.inline.} = self.union1.dwReserved = x
proc dwReserved*(self: INTERNET_CACHE_ENTRY_INFOW): DWORD {.inline.} = self.union1.dwReserved
proc dwReserved*(self: var INTERNET_CACHE_ENTRY_INFOW): var DWORD {.inline.} = self.union1.dwReserved
proc `dwExemptDelta=`*(self: var INTERNET_CACHE_ENTRY_INFOW, x: DWORD) {.inline.} = self.union1.dwExemptDelta = x
proc dwExemptDelta*(self: INTERNET_CACHE_ENTRY_INFOW): DWORD {.inline.} = self.union1.dwExemptDelta
proc dwExemptDelta*(self: var INTERNET_CACHE_ENTRY_INFOW): var DWORD {.inline.} = self.union1.dwExemptDelta
when winimUnicode:
  type
    INTERNET_PER_CONN_OPTION* = INTERNET_PER_CONN_OPTIONW
    LPINTERNET_PER_CONN_OPTION* = LPINTERNET_PER_CONN_OPTIONW
    INTERNET_PER_CONN_OPTION_LIST* = INTERNET_PER_CONN_OPTION_LISTW
    LPINTERNET_PER_CONN_OPTION_LIST* = LPINTERNET_PER_CONN_OPTION_LISTW
    URL_COMPONENTS* = URL_COMPONENTSW
    LPURL_COMPONENTS* = LPURL_COMPONENTSW
    INTERNET_BUFFERS* = INTERNET_BUFFERSW
    LPINTERNET_BUFFERS* = LPINTERNET_BUFFERSW
    GOPHER_FIND_DATA* = GOPHER_FIND_DATAW
    LPGOPHER_FIND_DATA* = LPGOPHER_FIND_DATAW
    INTERNET_CACHE_ENTRY_INFO* = INTERNET_CACHE_ENTRY_INFOW
    LPINTERNET_CACHE_ENTRY_INFO* = LPINTERNET_CACHE_ENTRY_INFOW
    INTERNET_CACHE_GROUP_INFO* = INTERNET_CACHE_GROUP_INFOW
    LPINTERNET_CACHE_GROUP_INFO* = LPINTERNET_CACHE_GROUP_INFOW
  proc InternetCrackUrl*(lpszUrl: LPCWSTR, dwUrlLength: DWORD, dwFlags: DWORD, lpUrlComponents: LPURL_COMPONENTSW): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetCrackUrlW".}
  proc InternetCreateUrl*(lpUrlComponents: LPURL_COMPONENTSW, dwFlags: DWORD, lpszUrl: LPWSTR, lpdwUrlLength: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetCreateUrlW".}
  proc InternetCanonicalizeUrl*(lpszUrl: LPCWSTR, lpszBuffer: LPWSTR, lpdwBufferLength: LPDWORD, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetCanonicalizeUrlW".}
  proc InternetCombineUrl*(lpszBaseUrl: LPCWSTR, lpszRelativeUrl: LPCWSTR, lpszBuffer: LPWSTR, lpdwBufferLength: LPDWORD, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetCombineUrlW".}
  proc InternetOpen*(lpszAgent: LPCWSTR, dwAccessType: DWORD, lpszProxy: LPCWSTR, lpszProxyBypass: LPCWSTR, dwFlags: DWORD): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc: "InternetOpenW".}
  proc InternetConnect*(hInternet: HINTERNET, lpszServerName: LPCWSTR, nServerPort: INTERNET_PORT, lpszUserName: LPCWSTR, lpszPassword: LPCWSTR, dwService: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc: "InternetConnectW".}
  proc InternetOpenUrl*(hInternet: HINTERNET, lpszUrl: LPCWSTR, lpszHeaders: LPCWSTR, dwHeadersLength: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc: "InternetOpenUrlW".}
  proc InternetReadFileEx*(hFile: HINTERNET, lpBuffersOut: LPINTERNET_BUFFERSW, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetReadFileExW".}
  proc InternetFindNextFile*(hFind: HINTERNET, lpvFindData: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetFindNextFileW".}
  proc InternetQueryOption*(hInternet: HINTERNET, dwOption: DWORD, lpBuffer: LPVOID, lpdwBufferLength: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetQueryOptionW".}
  proc InternetSetOption*(hInternet: HINTERNET, dwOption: DWORD, lpBuffer: LPVOID, dwBufferLength: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetSetOptionW".}
  proc InternetSetOptionEx*(hInternet: HINTERNET, dwOption: DWORD, lpBuffer: LPVOID, dwBufferLength: DWORD, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetSetOptionExW".}
  proc InternetGetLastResponseInfo*(lpdwError: LPDWORD, lpszBuffer: LPWSTR, lpdwBufferLength: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetGetLastResponseInfoW".}
  proc FtpFindFirstFile*(hConnect: HINTERNET, lpszSearchFile: LPCWSTR, lpFindFileData: LPWIN32_FIND_DATAW, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc: "FtpFindFirstFileW".}
  proc FtpGetFile*(hConnect: HINTERNET, lpszRemoteFile: LPCWSTR, lpszNewFile: LPCWSTR, fFailIfExists: WINBOOL, dwFlagsAndAttributes: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpGetFileW".}
  proc FtpPutFile*(hConnect: HINTERNET, lpszLocalFile: LPCWSTR, lpszNewRemoteFile: LPCWSTR, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpPutFileW".}
  proc FtpDeleteFile*(hConnect: HINTERNET, lpszFileName: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpDeleteFileW".}
  proc FtpRenameFile*(hConnect: HINTERNET, lpszExisting: LPCWSTR, lpszNew: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpRenameFileW".}
  proc FtpOpenFile*(hConnect: HINTERNET, lpszFileName: LPCWSTR, dwAccess: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc: "FtpOpenFileW".}
  proc FtpCreateDirectory*(hConnect: HINTERNET, lpszDirectory: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpCreateDirectoryW".}
  proc FtpRemoveDirectory*(hConnect: HINTERNET, lpszDirectory: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpRemoveDirectoryW".}
  proc FtpSetCurrentDirectory*(hConnect: HINTERNET, lpszDirectory: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpSetCurrentDirectoryW".}
  proc FtpGetCurrentDirectory*(hConnect: HINTERNET, lpszCurrentDirectory: LPWSTR, lpdwCurrentDirectory: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpGetCurrentDirectoryW".}
  proc FtpCommand*(hConnect: HINTERNET, fExpectResponse: WINBOOL, dwFlags: DWORD, lpszCommand: LPCWSTR, dwContext: DWORD_PTR, phFtpCommand: ptr HINTERNET): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpCommandW".}
  proc GopherCreateLocator*(lpszHost: LPCWSTR, nServerPort: INTERNET_PORT, lpszDisplayString: LPCWSTR, lpszSelectorString: LPCWSTR, dwGopherType: DWORD, lpszLocator: LPWSTR, lpdwBufferLength: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "GopherCreateLocatorW".}
  proc GopherGetLocatorType*(lpszLocator: LPCWSTR, lpdwGopherType: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "GopherGetLocatorTypeW".}
  proc GopherFindFirstFile*(hConnect: HINTERNET, lpszLocator: LPCWSTR, lpszSearchString: LPCWSTR, lpFindData: LPGOPHER_FIND_DATAW, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc: "GopherFindFirstFileW".}
  proc GopherOpenFile*(hConnect: HINTERNET, lpszLocator: LPCWSTR, lpszView: LPCWSTR, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc: "GopherOpenFileW".}
  proc GopherGetAttribute*(hConnect: HINTERNET, lpszLocator: LPCWSTR, lpszAttributeName: LPCWSTR, lpBuffer: LPBYTE, dwBufferLength: DWORD, lpdwCharactersReturned: LPDWORD, lpfnEnumerator: GOPHER_ATTRIBUTE_ENUMERATOR, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "GopherGetAttributeW".}
  proc HttpOpenRequest*(hConnect: HINTERNET, lpszVerb: LPCWSTR, lpszObjectName: LPCWSTR, lpszVersion: LPCWSTR, lpszReferrer: LPCWSTR, lplpszAcceptTypes: ptr LPCWSTR, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc: "HttpOpenRequestW".}
  proc HttpAddRequestHeaders*(hRequest: HINTERNET, lpszHeaders: LPCWSTR, dwHeadersLength: DWORD, dwModifiers: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "HttpAddRequestHeadersW".}
  proc HttpSendRequest*(hRequest: HINTERNET, lpszHeaders: LPCWSTR, dwHeadersLength: DWORD, lpOptional: LPVOID, dwOptionalLength: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "HttpSendRequestW".}
  proc HttpSendRequestEx*(hRequest: HINTERNET, lpBuffersIn: LPINTERNET_BUFFERSW, lpBuffersOut: LPINTERNET_BUFFERSW, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "HttpSendRequestExW".}
  proc HttpEndRequest*(hRequest: HINTERNET, lpBuffersOut: LPINTERNET_BUFFERSW, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "HttpEndRequestW".}
  proc HttpQueryInfo*(hRequest: HINTERNET, dwInfoLevel: DWORD, lpBuffer: LPVOID, lpdwBufferLength: LPDWORD, lpdwIndex: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "HttpQueryInfoW".}
  proc InternetSetCookie*(lpszUrl: LPCWSTR, lpszCookieName: LPCWSTR, lpszCookieData: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetSetCookieW".}
  proc InternetGetCookie*(lpszUrl: LPCWSTR, lpszCookieName: LPCWSTR, lpszCookieData: LPWSTR, lpdwSize: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetGetCookieW".}
  proc InternetSetCookieEx*(lpszUrl: LPCWSTR, lpszCookieName: LPCWSTR, lpszCookieData: LPCWSTR, dwFlags: DWORD, dwReserved: DWORD_PTR): DWORD {.winapi, stdcall, dynlib: "wininet", importc: "InternetSetCookieExW".}
  proc InternetGetCookieEx*(lpszUrl: LPCWSTR, lpszCookieName: LPCWSTR, lpszCookieData: LPWSTR, lpdwSize: LPDWORD, dwFlags: DWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetGetCookieExW".}
  proc InternetCheckConnection*(lpszUrl: LPCWSTR, dwFlags: DWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetCheckConnectionW".}
  proc CreateUrlCacheEntry*(lpszUrlName: LPCWSTR, dwExpectedFileSize: DWORD, lpszFileExtension: LPCWSTR, lpszFileName: LPWSTR, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "CreateUrlCacheEntryW".}
  proc CommitUrlCacheEntry*(lpszUrlName: LPCWSTR, lpszLocalFileName: LPCWSTR, ExpireTime: FILETIME, LastModifiedTime: FILETIME, CacheEntryType: DWORD, lpszHeaderInfo: LPWSTR, dwHeaders: DWORD, lpszFileExtension: LPCWSTR, lpszOriginalUrl: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "CommitUrlCacheEntryW".}
  proc RetrieveUrlCacheEntryFile*(lpszUrlName: LPCWSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, lpcbCacheEntryInfo: LPDWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "RetrieveUrlCacheEntryFileW".}
  proc UnlockUrlCacheEntryFile*(lpszUrlName: LPCWSTR, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "UnlockUrlCacheEntryFileW".}
  proc RetrieveUrlCacheEntryStream*(lpszUrlName: LPCWSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, lpcbCacheEntryInfo: LPDWORD, fRandomRead: WINBOOL, dwReserved: DWORD): HANDLE {.winapi, stdcall, dynlib: "wininet", importc: "RetrieveUrlCacheEntryStreamW".}
  proc GetUrlCacheEntryInfo*(lpszUrlName: LPCWSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, lpcbCacheEntryInfo: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "GetUrlCacheEntryInfoW".}
  proc GetUrlCacheGroupAttribute*(gid: GROUPID, dwFlags: DWORD, dwAttributes: DWORD, lpGroupInfo: LPINTERNET_CACHE_GROUP_INFOW, lpdwGroupInfo: LPDWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "GetUrlCacheGroupAttributeW".}
  proc SetUrlCacheGroupAttribute*(gid: GROUPID, dwFlags: DWORD, dwAttributes: DWORD, lpGroupInfo: LPINTERNET_CACHE_GROUP_INFOW, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "SetUrlCacheGroupAttributeW".}
  proc GetUrlCacheEntryInfoEx*(lpszUrl: LPCWSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, lpcbCacheEntryInfo: LPDWORD, lpszRedirectUrl: LPWSTR, lpcbRedirectUrl: LPDWORD, lpReserved: LPVOID, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "GetUrlCacheEntryInfoExW".}
  proc SetUrlCacheEntryInfo*(lpszUrlName: LPCWSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, dwFieldControl: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "SetUrlCacheEntryInfoW".}
  proc FindFirstUrlCacheEntryEx*(lpszUrlSearchPattern: LPCWSTR, dwFlags: DWORD, dwFilter: DWORD, GroupId: GROUPID, lpFirstCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, lpcbEntryInfo: LPDWORD, lpGroupAttributes: LPVOID, lpcbGroupAttributes: LPDWORD, lpReserved: LPVOID): HANDLE {.winapi, stdcall, dynlib: "wininet", importc: "FindFirstUrlCacheEntryExW".}
  proc FindNextUrlCacheEntryEx*(hEnumHandle: HANDLE, lpNextCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, lpcbEntryInfo: LPDWORD, lpGroupAttributes: LPVOID, lpcbGroupAttributes: LPDWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FindNextUrlCacheEntryExW".}
  proc FindFirstUrlCacheEntry*(lpszUrlSearchPattern: LPCWSTR, lpFirstCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, lpcbCacheEntryInfo: LPDWORD): HANDLE {.winapi, stdcall, dynlib: "wininet", importc: "FindFirstUrlCacheEntryW".}
  proc FindNextUrlCacheEntry*(hEnumHandle: HANDLE, lpNextCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOW, lpcbCacheEntryInfo: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FindNextUrlCacheEntryW".}
  proc InternetSetPerSiteCookieDecision*(pchHostName: LPCWSTR, dwDecision: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetSetPerSiteCookieDecisionW".}
  proc InternetGetPerSiteCookieDecision*(pchHostName: LPCWSTR, pResult: ptr int32): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetGetPerSiteCookieDecisionW".}
  proc InternetEnumPerSiteCookieDecision*(pszSiteName: LPWSTR, pcSiteNameSize: ptr int32, pdwDecision: ptr int32, dwIndex: int32): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetEnumPerSiteCookieDecisionW".}
  proc InternetTimeFromSystemTime*(pst: ptr SYSTEMTIME, dwRFC: DWORD, lpszTime: LPWSTR, cbTime: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetTimeFromSystemTimeW".}
  proc InternetTimeToSystemTime*(lpszTime: LPCWSTR, pst: ptr SYSTEMTIME, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetTimeToSystemTimeW".}
  proc InternetSetStatusCallback*(hInternet: HINTERNET, lpfnInternetCallback: INTERNET_STATUS_CALLBACK): INTERNET_STATUS_CALLBACK {.winapi, stdcall, dynlib: "wininet", importc: "InternetSetStatusCallbackW".}
  proc InternetConfirmZoneCrossing*(hWnd: HWND, szUrlPrev: LPWSTR, szUrlNew: LPWSTR, bPost: WINBOOL): DWORD {.winapi, stdcall, dynlib: "wininet", importc: "InternetConfirmZoneCrossingW".}
  proc InternetDial*(hwndParent: HWND, lpszConnectoid: LPWSTR, dwFlags: DWORD, lpdwConnection: ptr DWORD_PTR, dwReserved: DWORD): DWORD {.winapi, stdcall, dynlib: "wininet", importc: "InternetDialW".}
  proc InternetGoOnline*(lpszURL: LPWSTR, hwndParent: HWND, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetGoOnlineW".}
  proc DeleteUrlCacheEntry*(lpszUrlName: LPCWSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "DeleteUrlCacheEntryW".}
  proc SetUrlCacheEntryGroup*(lpszUrlName: LPCWSTR, dwFlags: DWORD, GroupId: GROUPID, pbGroupAttributes: LPBYTE, cbGroupAttributes: DWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "SetUrlCacheEntryGroupW".}
  proc InternetSetDialState*(lpszConnectoid: LPCWSTR, dwState: DWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetSetDialStateW".}
  proc InternetGetConnectedStateEx*(lpdwFlags: LPDWORD, lpszConnectionName: LPWSTR, dwBufLen: DWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetGetConnectedStateExW".}
when winimAnsi:
  type
    INTERNET_PER_CONN_OPTION* = INTERNET_PER_CONN_OPTIONA
    LPINTERNET_PER_CONN_OPTION* = LPINTERNET_PER_CONN_OPTIONA
    INTERNET_PER_CONN_OPTION_LIST* = INTERNET_PER_CONN_OPTION_LISTA
    LPINTERNET_PER_CONN_OPTION_LIST* = LPINTERNET_PER_CONN_OPTION_LISTA
    URL_COMPONENTS* = URL_COMPONENTSA
    LPURL_COMPONENTS* = LPURL_COMPONENTSA
    INTERNET_BUFFERS* = INTERNET_BUFFERSA
    LPINTERNET_BUFFERS* = LPINTERNET_BUFFERSA
    GOPHER_FIND_DATA* = GOPHER_FIND_DATAA
    LPGOPHER_FIND_DATA* = LPGOPHER_FIND_DATAA
    INTERNET_CACHE_ENTRY_INFO* = INTERNET_CACHE_ENTRY_INFOA
    LPINTERNET_CACHE_ENTRY_INFO* = LPINTERNET_CACHE_ENTRY_INFOA
    INTERNET_CACHE_GROUP_INFO* = INTERNET_CACHE_GROUP_INFOA
    LPINTERNET_CACHE_GROUP_INFO* = LPINTERNET_CACHE_GROUP_INFOA
  proc InternetCrackUrl*(lpszUrl: LPCSTR, dwUrlLength: DWORD, dwFlags: DWORD, lpUrlComponents: LPURL_COMPONENTSA): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetCrackUrlA".}
  proc InternetCreateUrl*(lpUrlComponents: LPURL_COMPONENTSA, dwFlags: DWORD, lpszUrl: LPSTR, lpdwUrlLength: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetCreateUrlA".}
  proc InternetCanonicalizeUrl*(lpszUrl: LPCSTR, lpszBuffer: LPSTR, lpdwBufferLength: LPDWORD, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetCanonicalizeUrlA".}
  proc InternetCombineUrl*(lpszBaseUrl: LPCSTR, lpszRelativeUrl: LPCSTR, lpszBuffer: LPSTR, lpdwBufferLength: LPDWORD, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetCombineUrlA".}
  proc InternetOpen*(lpszAgent: LPCSTR, dwAccessType: DWORD, lpszProxy: LPCSTR, lpszProxyBypass: LPCSTR, dwFlags: DWORD): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc: "InternetOpenA".}
  proc InternetConnect*(hInternet: HINTERNET, lpszServerName: LPCSTR, nServerPort: INTERNET_PORT, lpszUserName: LPCSTR, lpszPassword: LPCSTR, dwService: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc: "InternetConnectA".}
  proc InternetOpenUrl*(hInternet: HINTERNET, lpszUrl: LPCSTR, lpszHeaders: LPCSTR, dwHeadersLength: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc: "InternetOpenUrlA".}
  proc InternetReadFileEx*(hFile: HINTERNET, lpBuffersOut: LPINTERNET_BUFFERSA, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetReadFileExA".}
  proc InternetFindNextFile*(hFind: HINTERNET, lpvFindData: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetFindNextFileA".}
  proc InternetQueryOption*(hInternet: HINTERNET, dwOption: DWORD, lpBuffer: LPVOID, lpdwBufferLength: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetQueryOptionA".}
  proc InternetSetOption*(hInternet: HINTERNET, dwOption: DWORD, lpBuffer: LPVOID, dwBufferLength: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetSetOptionA".}
  proc InternetSetOptionEx*(hInternet: HINTERNET, dwOption: DWORD, lpBuffer: LPVOID, dwBufferLength: DWORD, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetSetOptionExA".}
  proc InternetGetLastResponseInfo*(lpdwError: LPDWORD, lpszBuffer: LPSTR, lpdwBufferLength: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetGetLastResponseInfoA".}
  proc FtpFindFirstFile*(hConnect: HINTERNET, lpszSearchFile: LPCSTR, lpFindFileData: LPWIN32_FIND_DATAA, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc: "FtpFindFirstFileA".}
  proc FtpGetFile*(hConnect: HINTERNET, lpszRemoteFile: LPCSTR, lpszNewFile: LPCSTR, fFailIfExists: WINBOOL, dwFlagsAndAttributes: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpGetFileA".}
  proc FtpPutFile*(hConnect: HINTERNET, lpszLocalFile: LPCSTR, lpszNewRemoteFile: LPCSTR, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpPutFileA".}
  proc FtpDeleteFile*(hConnect: HINTERNET, lpszFileName: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpDeleteFileA".}
  proc FtpRenameFile*(hConnect: HINTERNET, lpszExisting: LPCSTR, lpszNew: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpRenameFileA".}
  proc FtpOpenFile*(hConnect: HINTERNET, lpszFileName: LPCSTR, dwAccess: DWORD, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc: "FtpOpenFileA".}
  proc FtpCreateDirectory*(hConnect: HINTERNET, lpszDirectory: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpCreateDirectoryA".}
  proc FtpRemoveDirectory*(hConnect: HINTERNET, lpszDirectory: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpRemoveDirectoryA".}
  proc FtpSetCurrentDirectory*(hConnect: HINTERNET, lpszDirectory: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpSetCurrentDirectoryA".}
  proc FtpGetCurrentDirectory*(hConnect: HINTERNET, lpszCurrentDirectory: LPSTR, lpdwCurrentDirectory: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpGetCurrentDirectoryA".}
  proc FtpCommand*(hConnect: HINTERNET, fExpectResponse: WINBOOL, dwFlags: DWORD, lpszCommand: LPCSTR, dwContext: DWORD_PTR, phFtpCommand: ptr HINTERNET): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FtpCommandA".}
  proc GopherCreateLocator*(lpszHost: LPCSTR, nServerPort: INTERNET_PORT, lpszDisplayString: LPCSTR, lpszSelectorString: LPCSTR, dwGopherType: DWORD, lpszLocator: LPSTR, lpdwBufferLength: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "GopherCreateLocatorA".}
  proc GopherGetLocatorType*(lpszLocator: LPCSTR, lpdwGopherType: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "GopherGetLocatorTypeA".}
  proc GopherFindFirstFile*(hConnect: HINTERNET, lpszLocator: LPCSTR, lpszSearchString: LPCSTR, lpFindData: LPGOPHER_FIND_DATAA, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc: "GopherFindFirstFileA".}
  proc GopherOpenFile*(hConnect: HINTERNET, lpszLocator: LPCSTR, lpszView: LPCSTR, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc: "GopherOpenFileA".}
  proc GopherGetAttribute*(hConnect: HINTERNET, lpszLocator: LPCSTR, lpszAttributeName: LPCSTR, lpBuffer: LPBYTE, dwBufferLength: DWORD, lpdwCharactersReturned: LPDWORD, lpfnEnumerator: GOPHER_ATTRIBUTE_ENUMERATOR, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "GopherGetAttributeA".}
  proc HttpOpenRequest*(hConnect: HINTERNET, lpszVerb: LPCSTR, lpszObjectName: LPCSTR, lpszVersion: LPCSTR, lpszReferrer: LPCSTR, lplpszAcceptTypes: ptr LPCSTR, dwFlags: DWORD, dwContext: DWORD_PTR): HINTERNET {.winapi, stdcall, dynlib: "wininet", importc: "HttpOpenRequestA".}
  proc HttpAddRequestHeaders*(hRequest: HINTERNET, lpszHeaders: LPCSTR, dwHeadersLength: DWORD, dwModifiers: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "HttpAddRequestHeadersA".}
  proc HttpSendRequest*(hRequest: HINTERNET, lpszHeaders: LPCSTR, dwHeadersLength: DWORD, lpOptional: LPVOID, dwOptionalLength: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "HttpSendRequestA".}
  proc HttpSendRequestEx*(hRequest: HINTERNET, lpBuffersIn: LPINTERNET_BUFFERSA, lpBuffersOut: LPINTERNET_BUFFERSA, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "HttpSendRequestExA".}
  proc HttpEndRequest*(hRequest: HINTERNET, lpBuffersOut: LPINTERNET_BUFFERSA, dwFlags: DWORD, dwContext: DWORD_PTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "HttpEndRequestA".}
  proc HttpQueryInfo*(hRequest: HINTERNET, dwInfoLevel: DWORD, lpBuffer: LPVOID, lpdwBufferLength: LPDWORD, lpdwIndex: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "HttpQueryInfoA".}
  proc InternetSetCookie*(lpszUrl: LPCSTR, lpszCookieName: LPCSTR, lpszCookieData: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetSetCookieA".}
  proc InternetGetCookie*(lpszUrl: LPCSTR, lpszCookieName: LPCSTR, lpszCookieData: LPSTR, lpdwSize: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetGetCookieA".}
  proc InternetSetCookieEx*(lpszUrl: LPCSTR, lpszCookieName: LPCSTR, lpszCookieData: LPCSTR, dwFlags: DWORD, dwReserved: DWORD_PTR): DWORD {.winapi, stdcall, dynlib: "wininet", importc: "InternetSetCookieExA".}
  proc InternetGetCookieEx*(lpszUrl: LPCSTR, lpszCookieName: LPCSTR, lpszCookieData: LPSTR, lpdwSize: LPDWORD, dwFlags: DWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetGetCookieExA".}
  proc InternetCheckConnection*(lpszUrl: LPCSTR, dwFlags: DWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetCheckConnectionA".}
  proc CreateUrlCacheEntry*(lpszUrlName: LPCSTR, dwExpectedFileSize: DWORD, lpszFileExtension: LPCSTR, lpszFileName: LPSTR, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "CreateUrlCacheEntryA".}
  proc CommitUrlCacheEntry*(lpszUrlName: LPCSTR, lpszLocalFileName: LPCSTR, ExpireTime: FILETIME, LastModifiedTime: FILETIME, CacheEntryType: DWORD, lpHeaderInfo: LPBYTE, dwHeaderSize: DWORD, lpszFileExtension: LPCSTR, lpszOriginalUrl: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "CommitUrlCacheEntryA".}
  proc RetrieveUrlCacheEntryFile*(lpszUrlName: LPCSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, lpcbCacheEntryInfo: LPDWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "RetrieveUrlCacheEntryFileA".}
  proc UnlockUrlCacheEntryFile*(lpszUrlName: LPCSTR, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "UnlockUrlCacheEntryFileA".}
  proc RetrieveUrlCacheEntryStream*(lpszUrlName: LPCSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, lpcbCacheEntryInfo: LPDWORD, fRandomRead: WINBOOL, dwReserved: DWORD): HANDLE {.winapi, stdcall, dynlib: "wininet", importc: "RetrieveUrlCacheEntryStreamA".}
  proc GetUrlCacheEntryInfo*(lpszUrlName: LPCSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, lpcbCacheEntryInfo: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "GetUrlCacheEntryInfoA".}
  proc GetUrlCacheGroupAttribute*(gid: GROUPID, dwFlags: DWORD, dwAttributes: DWORD, lpGroupInfo: LPINTERNET_CACHE_GROUP_INFOA, lpdwGroupInfo: LPDWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "GetUrlCacheGroupAttributeA".}
  proc SetUrlCacheGroupAttribute*(gid: GROUPID, dwFlags: DWORD, dwAttributes: DWORD, lpGroupInfo: LPINTERNET_CACHE_GROUP_INFOA, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "SetUrlCacheGroupAttributeA".}
  proc GetUrlCacheEntryInfoEx*(lpszUrl: LPCSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, lpcbCacheEntryInfo: LPDWORD, lpszRedirectUrl: LPSTR, lpcbRedirectUrl: LPDWORD, lpReserved: LPVOID, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "GetUrlCacheEntryInfoExA".}
  proc SetUrlCacheEntryInfo*(lpszUrlName: LPCSTR, lpCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, dwFieldControl: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "SetUrlCacheEntryInfoA".}
  proc FindFirstUrlCacheEntryEx*(lpszUrlSearchPattern: LPCSTR, dwFlags: DWORD, dwFilter: DWORD, GroupId: GROUPID, lpFirstCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, lpcbEntryInfo: LPDWORD, lpGroupAttributes: LPVOID, lpcbGroupAttributes: LPDWORD, lpReserved: LPVOID): HANDLE {.winapi, stdcall, dynlib: "wininet", importc: "FindFirstUrlCacheEntryExA".}
  proc FindNextUrlCacheEntryEx*(hEnumHandle: HANDLE, lpNextCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, lpcbEntryInfo: LPDWORD, lpGroupAttributes: LPVOID, lpcbGroupAttributes: LPDWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FindNextUrlCacheEntryExA".}
  proc FindFirstUrlCacheEntry*(lpszUrlSearchPattern: LPCSTR, lpFirstCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, lpcbCacheEntryInfo: LPDWORD): HANDLE {.winapi, stdcall, dynlib: "wininet", importc: "FindFirstUrlCacheEntryA".}
  proc FindNextUrlCacheEntry*(hEnumHandle: HANDLE, lpNextCacheEntryInfo: LPINTERNET_CACHE_ENTRY_INFOA, lpcbCacheEntryInfo: LPDWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "FindNextUrlCacheEntryA".}
  proc InternetSetPerSiteCookieDecision*(pchHostName: LPCSTR, dwDecision: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetSetPerSiteCookieDecisionA".}
  proc InternetGetPerSiteCookieDecision*(pchHostName: LPCSTR, pResult: ptr int32): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetGetPerSiteCookieDecisionA".}
  proc InternetEnumPerSiteCookieDecision*(pszSiteName: LPSTR, pcSiteNameSize: ptr int32, pdwDecision: ptr int32, dwIndex: int32): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetEnumPerSiteCookieDecisionA".}
  proc InternetTimeFromSystemTime*(pst: ptr SYSTEMTIME, dwRFC: DWORD, lpszTime: LPSTR, cbTime: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetTimeFromSystemTimeA".}
  proc InternetTimeToSystemTime*(lpszTime: LPCSTR, pst: ptr SYSTEMTIME, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetTimeToSystemTimeA".}
  proc InternetSetStatusCallback*(hInternet: HINTERNET, lpfnInternetCallback: INTERNET_STATUS_CALLBACK): INTERNET_STATUS_CALLBACK {.winapi, stdcall, dynlib: "wininet", importc: "InternetSetStatusCallbackA".}
  proc InternetConfirmZoneCrossing*(hWnd: HWND, szUrlPrev: LPSTR, szUrlNew: LPSTR, bPost: WINBOOL): DWORD {.winapi, stdcall, dynlib: "wininet", importc: "InternetConfirmZoneCrossingA".}
  proc InternetDial*(hwndParent: HWND, lpszConnectoid: LPSTR, dwFlags: DWORD, lpdwConnection: ptr DWORD_PTR, dwReserved: DWORD): DWORD {.winapi, stdcall, dynlib: "wininet", importc: "InternetDialA".}
  proc InternetGoOnline*(lpszURL: LPSTR, hwndParent: HWND, dwFlags: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetGoOnlineA".}
  proc DeleteUrlCacheEntry*(lpszUrlName: LPCSTR): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "DeleteUrlCacheEntryA".}
  proc SetUrlCacheEntryGroup*(lpszUrlName: LPCSTR, dwFlags: DWORD, GroupId: GROUPID, pbGroupAttributes: LPBYTE, cbGroupAttributes: DWORD, lpReserved: LPVOID): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "SetUrlCacheEntryGroupA".}
  proc InternetSetDialState*(lpszConnectoid: LPCSTR, dwState: DWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetSetDialStateA".}
  proc InternetGetConnectedStateEx*(lpdwFlags: LPDWORD, lpszConnectionName: LPSTR, dwBufLen: DWORD, dwReserved: DWORD): WINBOOL {.winapi, stdcall, dynlib: "wininet", importc: "InternetGetConnectedStateExA".}
