doc ///
Node
  Key
    Truncations
  Headline
    truncations of graded ring, ideals and modules
  Description
    Text
      This package provides methods for truncation of a graded ring, or a graded module or
      ideal over a graded ring (see @TO (truncate, List, Module)@). Truncation is functorial:
      it can be applied to maps of modules as well, and the truncation of a composition
      of maps is the composition of the truncations (see @TO (truncate, List, Matrix)@).

      Let $S$ be a $\ZZ^r$-graded ring whose variables have non-negative degrees
      and $M$ be a graded $S$-module. Then for a finite subset of degrees $L\subset\ZZ^r$
      the method {\tt truncate(L, M)} computes $$M_{\ge L} = \bigoplus_{m\in L+\NN^r} M_m,$$
      where the sum is taken over all degrees $m \in \ZZ^r$ which are component-wise greater
      than or equal to some degree $d\in L$. In this case the truncation is a submodule of $M$.
    Example
      R = ZZ/101[a..d, Degrees => {1,2,3,4}];
      truncate(4, ideal"a3,b3")
    Text
      More generally, let $S$ be the total coordinate ring of a simplicial toric variety $X$
      with Picard group $\operatorname{Pic} X$. Then for a finite subset $L\subset\operatorname{Pic} X$,
      the truncation $F_{\ge L}$ of a free module $F$ may be defined as the submodule generated by
      $$F_{\ge L} = \bigoplus_{m\in L+\operatorname{Nef} X} F_m,$$ where $\operatorname{Nef} X$ is
      the semigroup of nef line bundles in $\operatorname{Pic} X$ (c.f. Definition 5.1 in [MS04]).
      Then for a graded $S$-module $M$ with @TO presentation@ $0 \gets M \gets G \gets H,$ where
      $G$ and $H$ are free modules, the truncation $M_{\ge L}$ is the $S$-module with presentation
      $$0 \gets M_{\ge L} \gets G_{\ge L} \gets H_{\ge L}.$$
      Note that $M_{\ge L}$ is not a submodule of $M$ in general, but exact sequences are preserved
      and since $M/M_{\ge L}$ is annihilated by a power of the irrelevant ideal of $S$, a module
      and its truncation define the same sheaf.
    Example
      needsPackage "NormalToricVarieties";
      dP6 = smoothFanoToricVariety(2, 4);
      S = ring dP6;
      M = S^{-{0,0,1,0}};
      N = truncate({0,0,0,0}, M)
      N == coker truncate({0,0,0,0}, presentation M)
    Text
      For the most general case, if $S$ is a $\ZZ^r$-graded ring where the degree components of
      variables may be negative, the result is the same as the above but we fix the nef cone to
      be the positive orthant $\NN^r$.
    Example
      R = ZZ/101[a..d, Degrees => {2:{1,0},{0,1},{-3,1}}];
      M = R^1/ideal d
      N = truncate({0,0}, M)
      isSubset(M, N)
    Text
      The polyhedral algorithms implemented in this package correctly handle many cases.
      The behavior of @TO "truncate"@ changed as of Macaulay2 version 1.13 to support
      @TO "Macaulay2Doc :: exterior algebras"@, and again in Macaulay2 version 1.19
      to support Cox rings of simplicial @TO2 {NormalToricVarieties, "normal toric varieties"}@.
  References
    @UL {
        {"[MS04]: Maclagan and Smith, Multigraded Castelnuovo-Mumford Regularity (see ", arXiv "math/0305214", ")."}
        }@
  Contributors
    Lauren Cranton Heller contributed to the code and documentation for this package.
  Subnodes
    (truncate, List, Module)
    (truncate, List, Matrix)
  SeeAlso
    basis

Node
  Key
    (truncate, List, Module)
    (truncate, List, Ideal)
    (truncate, List, Ring)
    (truncate, ZZ,   Module)
    (truncate, ZZ,   Ideal)
    (truncate, ZZ,   Ring)
   [(truncate, List, Module), MinimalGenerators]
  Headline
    truncation of the graded ring, ideal or module at a specified degree or set of degrees
  Usage
    truncate(degs, M)
  Inputs
    degs:{ZZ,List}
       a single degree, a multidegree, or a list of degrees or multidegrees
    M:{Module,Ideal,Ring}
    MinimalGenerators=>Boolean
      indicates whether the result should be @TO2 {trim, "trimmed"}@
  Outputs
    :{Module,Ideal}
      the truncation submodule $M_{\ge degs}$
  Description
    Text
      The truncation to degree $d$ in the singly graded case of a module (or ring or ideal)
      is generated by all homogeneous elements of degree at least $d$ in $M$.
      The resulting truncation is minimally generated (assuming that $M$ is graded).
    Example
      R = ZZ/101[a..c];
      truncate(2, R)
      truncate(2, R^1)
      truncate(2, R^{0,-3})
    Text
      The coefficient ring of $R$ may be $\ZZ$ or another polynomial ring.
      Over $\ZZ$, the generators may not be minimal, but they do generate.
    Example
      A = ZZ[x,y,z];
      truncate(2, ideal(3*x, 5*y, 15))
    Text
      If a multi-degree $d$ is given, then the result is the submodule generated by
      elements of degree $d+\NN\mathcal C$ where $\mathcal C$ is either a generating
      set for the degree semigroup of $R$ or the Nef cone of the toric variety.

      The following example finds the 11 generators needed to obtain all graded elements
      whose degrees are at least $\{7,24\}$.
    Example
      S = ZZ/101[x,y,z, Degrees => {{1,3},{1,4},{1,0}}];
      trunc = truncate({7,24}, S^1 ++ S^{{-8,-20}})
      degrees trunc
    Text
      Given a list of multi-degrees $D$, then the result is the submodule generated by
      elements of degree $d+\NN\mathcal C$ for any $d\in D$.

      The following example finds the generators needed to obtain all graded elements
      whose degrees at least $\{3,0\}$ or at least $\{0,1\}$.
      The resulting module is also minimally generated.
    Example
      S = ZZ/101[x,y,z, Degrees => {{1,3},{1,4},{1,0}}];
      trunc = truncate({{3,0}, {0,1}}, S^1 ++ S^{{-8,-20}})
      degrees trunc
    Text
      The coefficient ring may also be a polynomial ring. In this example, the
      coefficient variables also have degree one. The given generators will
      generate the truncation over the coefficient ring.
    Example
      B = R[x,y,z, Join => false];
      degrees B
      truncate(2, B^1)
      truncate(4, ideal(b^2*y,x^3))
    Text
      If the coefficient variables have degree 0:
    Example
      A1 = ZZ/101[a,b,c, Degrees => {3:{}}];
      degrees A1
      B1 = A1[x,y];
      degrees B1
      truncate(2, B1^1)
      truncate(2, ideal(a^3*x, b*y^2))
  Caveat
    The behavior of this function has changed as of Macaulay2 version 1.13.
    This is a (potentially) breaking change. Before, it used a less useful
    notion of truncation, involving the heft vector, and was often not what
    one wanted in the multi-graded case. Additionally, in the tower ring case,
    when the coefficient ring had variables of nonzero degree, sometimes
    incorrect answers resulted.

    Also, the function expects a graded module, ring, or ideal, but this is not
    checked, and some answer is returned.
  SeeAlso
    basis
    module
    comodule

Node
  Key
    (truncate, List, Matrix)
    (truncate, ZZ,   Matrix)
   [(truncate, List, Matrix), MinimalGenerators]
  Headline
    truncation of a map of free modules
  Usage
    truncate(degs, f)
  Inputs
    degs:{ZZ,List}
      a single degree, a multidegree, or a list of degrees or multidegrees
    f:Matrix
      a graded map between graded modules (not necessarily free modules)
    MinimalGenerators=>Boolean
      indicates whether the source and target of the result should be @TO2 {trim, "trimmed"}@
  Outputs
    :Matrix
      a graded map between the truncations of the source and target of $f$
  Description
    Text
      This function truncates the source and target of a module map,
      and returns the induced map between them.
    Example
      R = ZZ/101[a..d, Degrees => {{1,3},{1,0},{1,3},{1,2}}];
      I = ideal "a,b2,c3,d4"
      C = res I
      g1 = truncate({1,1}, C.dd_1)
      g2 = truncate({1,1}, C.dd_2)
      g3 = truncate({1,1}, C.dd_3)
      g4 = truncate({1,1}, C.dd_4)
      D = chainComplex {g1, g2, g3, g4}
    Text
      This functor is exact.
    Example
      prune HH D
      HH_0 D == truncate({1,1}, comodule ideal"a,b2,c3,d4")
  SeeAlso
    (truncate, List, Module)
///

end--

doc ///
Node
  Key
  Headline
  Usage
  Inputs
  Outputs
  Description
    Text
    Example
  Caveat
  SeeAlso
///
