/*
 * Decompiled with CFR 0.152.
 */
package cqure.repeng;

import cqure.repeng.ReportObject;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ReportTree
extends DefaultTreeModel
implements Serializable {
    private boolean m_bShowLinks = true;
    private boolean m_bSorted = true;

    public ReportTree() {
        super(new DefaultMutableTreeNode("root"));
    }

    public void setShowLinks(boolean b) {
        this.m_bShowLinks = b;
    }

    public void setSorted(boolean b) {
        this.m_bSorted = b;
    }

    public TreePath find(TreePath oParent, Object[] oNodes, int nDepth) {
        TreeNode oNode = (TreeNode)oParent.getLastPathComponent();
        String s = oNode.toString();
        if (s.equalsIgnoreCase((String)oNodes[nDepth])) {
            if (nDepth == oNodes.length - 1) {
                return oParent;
            }
            if (oNode.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> e = oNode.children();
                while (e.hasMoreElements()) {
                    TreeNode oN = e.nextElement();
                    TreePath oPath = oParent.pathByAddingChild(oN);
                    TreePath oResult = this.find(oPath, oNodes, nDepth + 1);
                    if (oResult == null) continue;
                    return oResult;
                }
            }
        }
        return null;
    }

    private TreePath findItemByName(Object[] sPath) {
        TreeNode oNode = (TreeNode)this.getRoot();
        return this.find(new TreePath(oNode), sPath, 0);
    }

    private Object[] createSearchArray(String sPath) {
        Vector<String> oV = new Vector<String>();
        if (sPath != null) {
            sPath = "root/" + sPath;
        }
        if (sPath != null && sPath.length() > 0) {
            StringTokenizer oTokenizer = new StringTokenizer(sPath, "/");
            while (oTokenizer.hasMoreTokens()) {
                String s = (String)oTokenizer.nextElement();
                oV.add(s);
            }
        } else {
            return null;
        }
        return oV.toArray();
    }

    public ReportObject findReportItem(String sPath) {
        Object[] oSrchArray = null;
        TreePath oPath = null;
        if (sPath == null) {
            return null;
        }
        oSrchArray = this.createSearchArray(sPath);
        oPath = this.findItemByName(oSrchArray);
        if (oPath == null) {
            return null;
        }
        return (ReportObject)oPath.getLastPathComponent();
    }

    public boolean addReportItem(String sPath, ReportObject o) {
        TreePath oPath;
        Object[] oSrchArray = null;
        if (o == null) {
            return false;
        }
        oSrchArray = this.createSearchArray(String.valueOf(sPath) + "/" + o.toString());
        if (oSrchArray != null) {
            oPath = this.findItemByName(oSrchArray);
            if (oPath != null) {
                oPath = new TreePath(o.getRoot());
                return true;
            }
            if (sPath != null && sPath.length() > 0) {
                oSrchArray = this.createSearchArray(sPath);
                oPath = this.findItemByName(oSrchArray);
            } else {
                oPath = new TreePath((TreeNode)this.getRoot());
            }
        } else {
            oPath = new TreePath((TreeNode)this.getRoot());
        }
        if (oPath != null) {
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oPath.getLastPathComponent();
            ReportObject oNewNode = o;
            if (this.m_bSorted && oNode.getChildCount() > 0) {
                int i = 0;
                while (i < oNode.getChildCount()) {
                    ReportObject o1 = (ReportObject)oNode.getChildAt(i);
                    if (o.toString().compareTo(o1.toString()) < 0) {
                        this.insertNodeInto(oNewNode, oNode, i);
                        return true;
                    }
                    ++i;
                }
                this.insertNodeInto(oNewNode, oNode, oNode.getChildCount());
            } else {
                this.insertNodeInto(oNewNode, oNode, oNode.getChildCount());
            }
            return true;
        }
        return false;
    }

    public boolean storeToFile(String sName) {
        try {
            FileOutputStream oF = new FileOutputStream(sName);
            XMLEncoder oEncoder = new XMLEncoder(oF);
            oEncoder.writeObject(this.getRoot());
            oEncoder.close();
            return true;
        }
        catch (IOException e) {
            System.err.println("[x] Failed to write report file");
            System.err.println("[x] " + e.getMessage());
            return false;
        }
    }

    public boolean loadFromFile(String sName) {
        FileInputStream oFIS = null;
        XMLDecoder oDecoder = null;
        DefaultMutableTreeNode oNode = null;
        try {
            oFIS = new FileInputStream(sName);
            oDecoder = new XMLDecoder(oFIS);
            oNode = (DefaultMutableTreeNode)oDecoder.readObject();
            this.getTreeModel().setRoot(oNode);
            oDecoder.close();
            oFIS.close();
        }
        catch (Exception e) {
            System.err.println("[x] Failed to load report");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public DefaultTreeModel getTreeModel() {
        return this;
    }

    public int getChildCount(Object parent) {
        int nCount = super.getChildCount(parent);
        Object o = null;
        ReportObject oRo = null;
        if (nCount > 0) {
            int nTmp = nCount;
            int i = 0;
            while (i < nTmp) {
                o = super.getChild(parent, i);
                if (o instanceof ReportObject && (oRo = (ReportObject)o).getType() == 1002 && !this.m_bShowLinks) {
                    --nCount;
                }
                ++i;
            }
        }
        return nCount;
    }

    public boolean isLeaf(Object oNode) {
        return this.getChildCount(oNode) <= 0;
    }

    public Object getChild(Object parent, int index) {
        Object o = super.getChild(parent, index);
        if (o instanceof ReportObject) {
            ReportObject oRo = (ReportObject)o;
            ReportObject oLink = null;
            if (oRo.getType() == 1002) {
                oLink = this.findReportItem((String)oRo.getValue());
                if (oLink == null) {
                    oLink = oRo;
                    oLink.setValue("!! THIS IS A BROKEN LINK !!");
                }
                if (this.m_bShowLinks) {
                    return oLink;
                }
                return null;
            }
        }
        return o;
    }
}

